/*
 * Decompiled with CFR 0.152.
 */
package com.zego.zegoavkit2.receiver;

import android.annotation.TargetApi;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkInfo;
import android.os.Build;
import java.net.InetAddress;

public class NetworkStateChangeReceiver2
extends BroadcastReceiver {
    private long mThis;
    private Context mContext;

    public void setThis(long pThis) {
        this.mThis = pThis;
    }

    public int init(Context ctx) {
        this.mContext = ctx;
        if (this.mContext == null) {
            return -1;
        }
        IntentFilter intentFilterNetwork = new IntentFilter();
        intentFilterNetwork.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        this.mContext.registerReceiver((BroadcastReceiver)this, intentFilterNetwork);
        this.onReceive(null, null);
        return 0;
    }

    public int uninit() {
        if (this.mContext == null) {
            return -1;
        }
        this.mContext.unregisterReceiver((BroadcastReceiver)this);
        this.mContext = null;
        return 0;
    }

    public void checkCurrentNetType() {
        this.onReceive(null, null);
    }

    public void onReceive(Context context, Intent intent) {
        if (this.mContext == null) {
            return;
        }
        int nt = 32;
        ConnectivityManager cm = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        NetworkInfo ni = null;
        if (cm != null) {
            ni = cm.getActiveNetworkInfo();
        }
        String networkInfo = "";
        if (ni == null) {
            nt = 0;
        } else {
            networkInfo = ni.toString();
            nt = this.getNetType(ni);
        }
        NetworkStateChangeReceiver2.onNetTypeChanged(this.mThis, nt, networkInfo);
    }

    private int getNetType(NetworkInfo ni) {
        int nt;
        block0 : switch (ni.getType()) {
            case 1: {
                nt = 2;
                break;
            }
            case 0: {
                switch (ni.getSubtype()) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 7: 
                    case 11: 
                    case 16: {
                        nt = 3;
                        break block0;
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 12: 
                    case 14: 
                    case 15: 
                    case 17: {
                        nt = 4;
                        break block0;
                    }
                    case 13: 
                    case 18: {
                        nt = 5;
                        break block0;
                    }
                    case 20: {
                        nt = 6;
                        break block0;
                    }
                }
                nt = 32;
                break;
            }
            case 9: {
                nt = 1;
                break;
            }
            default: {
                nt = 32;
            }
        }
        return nt;
    }

    @TargetApi(value=26)
    private String GetDnsSevers() {
        StringBuilder result = new StringBuilder();
        ConnectivityManager cm = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        NetworkInfo activeInfo = cm.getActiveNetworkInfo();
        Network work = cm.getActiveNetwork();
        if (activeInfo != null || work != null) {
            LinkProperties properties = cm.getLinkProperties(work);
            if (activeInfo.isConnected() && null != properties) {
                for (InetAddress addr : properties.getDnsServers()) {
                    String dnsIp = addr.getHostAddress() + ";";
                    result.append(dnsIp);
                }
            }
        }
        return result.toString();
    }

    public String getDnsSeverInfo() {
        if (Build.VERSION.SDK_INT > 25) {
            return this.GetDnsSevers();
        }
        String strArray = "getdnsC";
        return strArray;
    }

    static native void onNetTypeChanged(long var0, int var2, String var3);
}

