/*
 * Decompiled with CFR 0.152.
 */
package im.zego.zegoexpress.internal;

import android.app.Application;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import android.widget.Toast;
import im.zego.zegoexpress.ZegoAudioEffectPlayer;
import im.zego.zegoexpress.ZegoExpressEngine;
import im.zego.zegoexpress.ZegoMediaPlayer;
import im.zego.zegoexpress.callback.IZegoApiCalledEventHandler;
import im.zego.zegoexpress.callback.IZegoAudioDataHandler;
import im.zego.zegoexpress.callback.IZegoAudioMixingHandler;
import im.zego.zegoexpress.callback.IZegoCustomAudioProcessHandler;
import im.zego.zegoexpress.callback.IZegoCustomVideoCaptureHandler;
import im.zego.zegoexpress.callback.IZegoCustomVideoProcessHandler;
import im.zego.zegoexpress.callback.IZegoCustomVideoRenderHandler;
import im.zego.zegoexpress.callback.IZegoDataRecordEventHandler;
import im.zego.zegoexpress.callback.IZegoDestroyCompletionCallback;
import im.zego.zegoexpress.callback.IZegoEventHandler;
import im.zego.zegoexpress.callback.IZegoIMSendBarrageMessageCallback;
import im.zego.zegoexpress.callback.IZegoIMSendBroadcastMessageCallback;
import im.zego.zegoexpress.callback.IZegoIMSendCustomCommandCallback;
import im.zego.zegoexpress.callback.IZegoMixerStartCallback;
import im.zego.zegoexpress.callback.IZegoMixerStopCallback;
import im.zego.zegoexpress.callback.IZegoNetworkProbeResultCallback;
import im.zego.zegoexpress.callback.IZegoPlayerTakeSnapshotCallback;
import im.zego.zegoexpress.callback.IZegoPublisherSetStreamExtraInfoCallback;
import im.zego.zegoexpress.callback.IZegoPublisherTakeSnapshotCallback;
import im.zego.zegoexpress.callback.IZegoPublisherUpdateCdnUrlCallback;
import im.zego.zegoexpress.callback.IZegoRoomSetRoomExtraInfoCallback;
import im.zego.zegoexpress.callback.IZegoTestNetworkConnectivityCallback;
import im.zego.zegoexpress.callback.IZegoUploadLogResultCallback;
import im.zego.zegoexpress.constants.ZegoAECMode;
import im.zego.zegoexpress.constants.ZegoANSMode;
import im.zego.zegoexpress.constants.ZegoAudioCaptureStereoMode;
import im.zego.zegoexpress.constants.ZegoAudioRoute;
import im.zego.zegoexpress.constants.ZegoCapturePipelineScaleMode;
import im.zego.zegoexpress.constants.ZegoDataRecordType;
import im.zego.zegoexpress.constants.ZegoLanguage;
import im.zego.zegoexpress.constants.ZegoOrientation;
import im.zego.zegoexpress.constants.ZegoPlayerVideoLayer;
import im.zego.zegoexpress.constants.ZegoPublishChannel;
import im.zego.zegoexpress.constants.ZegoReverbPreset;
import im.zego.zegoexpress.constants.ZegoScenario;
import im.zego.zegoexpress.constants.ZegoStreamResourceMode;
import im.zego.zegoexpress.constants.ZegoTrafficControlFocusOnMode;
import im.zego.zegoexpress.constants.ZegoTrafficControlMinVideoBitrateMode;
import im.zego.zegoexpress.constants.ZegoVideoCodecID;
import im.zego.zegoexpress.constants.ZegoVideoFlipMode;
import im.zego.zegoexpress.constants.ZegoVideoMirrorMode;
import im.zego.zegoexpress.constants.ZegoVideoStreamType;
import im.zego.zegoexpress.constants.ZegoViewMode;
import im.zego.zegoexpress.constants.ZegoVoiceChangerPreset;
import im.zego.zegoexpress.constants.ZegoVolumeType;
import im.zego.zegoexpress.entity.ZegoAudioConfig;
import im.zego.zegoexpress.entity.ZegoAudioFrameParam;
import im.zego.zegoexpress.entity.ZegoBeautifyOption;
import im.zego.zegoexpress.entity.ZegoCDNConfig;
import im.zego.zegoexpress.entity.ZegoCanvas;
import im.zego.zegoexpress.entity.ZegoCustomAudioConfig;
import im.zego.zegoexpress.entity.ZegoCustomAudioProcessConfig;
import im.zego.zegoexpress.entity.ZegoCustomVideoCaptureConfig;
import im.zego.zegoexpress.entity.ZegoCustomVideoProcessConfig;
import im.zego.zegoexpress.entity.ZegoCustomVideoRenderConfig;
import im.zego.zegoexpress.entity.ZegoDataRecordConfig;
import im.zego.zegoexpress.entity.ZegoEngineConfig;
import im.zego.zegoexpress.entity.ZegoLogConfig;
import im.zego.zegoexpress.entity.ZegoMixerTask;
import im.zego.zegoexpress.entity.ZegoNetworkProbeConfig;
import im.zego.zegoexpress.entity.ZegoNetworkSpeedTestConfig;
import im.zego.zegoexpress.entity.ZegoPlayerConfig;
import im.zego.zegoexpress.entity.ZegoReverbAdvancedParam;
import im.zego.zegoexpress.entity.ZegoReverbEchoParam;
import im.zego.zegoexpress.entity.ZegoReverbParam;
import im.zego.zegoexpress.entity.ZegoRoomConfig;
import im.zego.zegoexpress.entity.ZegoSEIConfig;
import im.zego.zegoexpress.entity.ZegoUser;
import im.zego.zegoexpress.entity.ZegoVideoConfig;
import im.zego.zegoexpress.entity.ZegoVideoEncodedFrameParam;
import im.zego.zegoexpress.entity.ZegoVideoFrameParam;
import im.zego.zegoexpress.entity.ZegoVoiceChangerParam;
import im.zego.zegoexpress.entity.ZegoWatermark;
import im.zego.zegoexpress.internal.ZegoAudioEffectPlayerInternalImpl;
import im.zego.zegoexpress.internal.ZegoExpressEngineJniAPI;
import im.zego.zegoexpress.internal.ZegoMediaPlayerInternalImpl;
import im.zego.zegoexpress.utils.ZegoDebugLevel;
import im.zego.zegoexpress.utils.ZegoLibraryLoadUtil;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;

public class ZegoExpressEngineInternalImpl
extends ZegoExpressEngine {
    public static Handler mUIHandler;
    private static volatile boolean hasSoLoaded;
    private static volatile ZegoExpressEngine engine;
    private static Application context;
    private static boolean mIsTestEnv;
    private static boolean enableToastOnTestEnv;
    private static boolean enableDebugErrorAlways;
    private static ZegoLanguage language;
    public static IZegoEventHandler eventHandler;
    public static IZegoApiCalledEventHandler apiCalledEventHandler;
    public static IZegoCustomAudioProcessHandler iZegoCustomAudioProcessHandler;
    public static HashMap<Integer, IZegoRoomSetRoomExtraInfoCallback> sRoomSetExtraInfoHandler;
    public static HashMap<Integer, IZegoPublisherUpdateCdnUrlCallback> sPublisherUpdateCDNURLHandler;
    public static HashMap<Integer, IZegoPublisherSetStreamExtraInfoCallback> sPublisherUpdateStreamExtraInfoHandler;
    public static HashMap<Integer, IZegoIMSendBarrageMessageCallback> sIMSendBarragetMssageHandler;
    public static HashMap<Integer, IZegoMixerStartCallback> sMixerStartResultHandler;
    public static HashMap<Integer, IZegoMixerStopCallback> sMixerStopResultHandler;
    public static HashMap<Integer, IZegoIMSendBroadcastMessageCallback> sIMSendBoradcastMssageHandler;
    public static HashMap<Integer, IZegoIMSendCustomCommandCallback> sIMSendCustomCommandHandler;
    public static HashMap<Integer, IZegoPublisherTakeSnapshotCallback> sPublisherTakeSnapshotResultHandler;
    public static HashMap<String, IZegoPlayerTakeSnapshotCallback> sPlayerTakeSnapshotResultHandler;
    public static HashMap<Integer, IZegoTestNetworkConnectivityCallback> sTestNetworkConnectivityHandler;
    public static HashMap<Integer, IZegoNetworkProbeResultCallback> sNetworkProbeResultHandler;
    public static HashMap<Integer, IZegoUploadLogResultCallback> sUploadLogResultHandler;
    private static final int MAX_EVENT_HANDLE_COUNT = 16;
    private static final int ZEGO_EXPRESS_MODULE_JNI = 12;
    private static final int RESERVE_SEGMENT = 1000000;
    private static final int ERRCODE_OFFSET = 1000;
    private static final int ZEGO_ERRCODE_SUCCESS = 0;
    private static final int ZEGO_ERRCODE_COMMON_ENGINE_NOT_CREATED = 1000001;
    private static final int ZEGO_ERRCODE_ENGINE_APPID_ZERO = 1001000;
    private static final int ZEGO_ERRCODE_ENGINE_APPSIGN_INVALID_LENGTH = 1001001;
    private static final int ZEGO_ERRCODE_ENGINE_APPSIGN_INVALID_CHARACTER = 1001002;
    private static final int ZEGO_ERRCODE_ENGINE_APPSIGN_NULL = 1001003;
    private static final int ZEGO_ERRCODE_ENGINE_EVENT_HANDLER_NULL = 1001027;
    private static final int ZEGO_ERRCODE_ENGINE_EVENT_HANDLER_COUNT_EXCEED = 1001028;
    public static Object mCustomVideoRenderHandler;
    public static IZegoDestroyCompletionCallback iZegoDestroyCompletionCallback;
    public static Object mCustomVideoCaptureHandler;
    public static Object mCustomVideoProcessHandler;
    public static IZegoAudioMixingHandler iZegoAudioMixingHandler;
    public static IZegoAudioDataHandler iZegoAudioDataHandler;
    public static IZegoDataRecordEventHandler iZegoDataRecordEventHandler;
    private static ZegoEngineConfig mEngineConfig;
    public static boolean isCustomVideoCapturing;

    @Override
    public void setCustomAudioProcessHandler(IZegoCustomAudioProcessHandler handler) {
        iZegoCustomAudioProcessHandler = handler;
    }

    static boolean ensureSoLoaded(Context appContext, String customizeSoPath) {
        if (!hasSoLoaded && !TextUtils.isEmpty((CharSequence)customizeSoPath)) {
            try {
                hasSoLoaded = ZegoLibraryLoadUtil.loadSpecialLibrary(customizeSoPath, appContext);
            }
            catch (UnsatisfiedLinkError e) {
                Log.e((String)"ZEGO", (String)String.format("Load library %s failed", customizeSoPath), (Throwable)e);
                return false;
            }
            catch (Exception e) {
                Log.e((String)"ZEGO", (String)String.format("Load library %s failed", customizeSoPath), (Throwable)e);
                return false;
            }
        }
        if (!hasSoLoaded) {
            try {
                hasSoLoaded = ZegoLibraryLoadUtil.loadSoFile("libZegoExpressSDK.so", appContext);
                return hasSoLoaded;
            }
            catch (UnsatisfiedLinkError e) {
                Log.e((String)"ZEGO", (String)"Load library libZegoExpressSDK.so failed", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public static void setEngineConfig(ZegoEngineConfig engineConfig) {
        if (engineConfig != null) {
            if (engineConfig.advancedConfig != null) {
                String enableDebugErrorAlwaysStr;
                String enableToastOnTestEnvStr;
                if (engineConfig.advancedConfig.containsKey("enable_toast_on_test_env") && (enableToastOnTestEnvStr = engineConfig.advancedConfig.get("enable_toast_on_test_env")) != null) {
                    boolean bl = enableToastOnTestEnv = !enableToastOnTestEnvStr.equals("false");
                }
                if (engineConfig.advancedConfig.containsKey("enable_debug_error_always") && (enableDebugErrorAlwaysStr = engineConfig.advancedConfig.get("enable_debug_error_always")) != null) {
                    enableDebugErrorAlways = !enableDebugErrorAlwaysStr.equals("false");
                }
            }
            mEngineConfig = engineConfig;
        } else {
            mEngineConfig = new ZegoEngineConfig();
        }
        String advanceConfig = "";
        if (ZegoExpressEngineInternalImpl.mEngineConfig.advancedConfig != null) {
            for (String key : ZegoExpressEngineInternalImpl.mEngineConfig.advancedConfig.keySet()) {
                advanceConfig = advanceConfig + key + "=" + ZegoExpressEngineInternalImpl.mEngineConfig.advancedConfig.get(key) + ";";
            }
        }
        ZegoExpressEngineJniAPI.setEngineInitConfigToJni(mEngineConfig, ZegoExpressEngineInternalImpl.mEngineConfig.logConfig.logPath, ZegoExpressEngineInternalImpl.mEngineConfig.logConfig.logSize, advanceConfig);
    }

    public static void setLogConfig(ZegoLogConfig config) {
        if (config == null) {
            config = new ZegoLogConfig();
        }
        ZegoExpressEngineJniAPI.setLogConfigToJni(config.logPath, config.logSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ZegoExpressEngine createEngine(long appID, String appSign, boolean isTestEnvironment, ZegoScenario scenario, Application application, IZegoEventHandler handler) {
        Class<ZegoExpressEngineInternalImpl> clazz = ZegoExpressEngineInternalImpl.class;
        synchronized (ZegoExpressEngineInternalImpl.class) {
            int errorCode;
            if (engine != null) {
                ZegoExpressEngineInternalImpl.printDebugInfo(ZegoDebugLevel.INFO, 1, "createEngine", 0, new Object[0]);
                // ** MonitorExit[var7_6] (shouldn't be in output)
                return engine;
            }
            if (application == null) {
                switch (language) {
                    case ENGLISH: {
                        throw new RuntimeException("Input application parameter abnormal");
                    }
                    case CHINESE: {
                        throw new RuntimeException("\u8f93\u5165application\u53c2\u6570\u5f02\u5e38");
                    }
                }
            }
            ZegoExpressEngineInternalImpl.printDebugInfo((errorCode = ZegoExpressEngineJniAPI.engineInitJni(appID, appSign, isTestEnvironment, scenario.value(), (Context)application)) == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 1, "createEngine", errorCode, new Object[0]);
            if (errorCode != 0) {
                // ** MonitorExit[var7_6] (shouldn't be in output)
                return null;
            }
            mUIHandler = new Handler(Looper.getMainLooper());
            context = application;
            mIsTestEnv = isTestEnvironment;
            engine = new ZegoExpressEngineInternalImpl();
            if (handler != null) {
                engine.setEventHandler(handler);
            }
            // ** MonitorExit[var7_6] (shouldn't be in output)
            return engine;
        }
    }

    public static ZegoExpressEngine getEngine() {
        return engine;
    }

    @Override
    public ZegoAudioConfig getAudioConfig() {
        return this.getAudioConfig(ZegoPublishChannel.MAIN);
    }

    @Override
    public ZegoAudioConfig getAudioConfig(ZegoPublishChannel channel) {
        return ZegoExpressEngineJniAPI.getAudioConfigJni(channel.value());
    }

    @Override
    public ZegoAudioRoute getAudioRouteType() {
        return ZegoExpressEngineJniAPI.getAudioRouteTypeJni();
    }

    @Override
    public void setPublishStreamEncryptionKey(String key) {
        this.setPublishStreamEncryptionKey(key, ZegoPublishChannel.MAIN);
    }

    @Override
    public void setPublishStreamEncryptionKey(String key, ZegoPublishChannel channel) {
        int errorCode = ZegoExpressEngineJniAPI.setPublishStreamEncryptionKeyJni(key, channel.value());
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "setPublishStreamEncryptionKey", errorCode, new Object[0]);
    }

    public void takePublishStreamSnapshot(IZegoPublisherTakeSnapshotCallback callback) {
        this.takePublishStreamSnapshot(callback, ZegoPublishChannel.MAIN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void takePublishStreamSnapshot(IZegoPublisherTakeSnapshotCallback callback, ZegoPublishChannel channel) {
        Class<ZegoExpressEngineInternalImpl> clazz = ZegoExpressEngineInternalImpl.class;
        synchronized (ZegoExpressEngineInternalImpl.class) {
            sPublisherTakeSnapshotResultHandler.put(channel.value(), callback);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            int errorCode = ZegoExpressEngineJniAPI.takePublishStreamSnapshotJni(channel.value());
            ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "takePublishStreamSnapshot", errorCode, new Object[0]);
            return;
        }
    }

    @Override
    public void mutePublishStreamAudio(boolean mute) {
        this.mutePublishStreamAudio(mute, ZegoPublishChannel.MAIN);
    }

    public ZegoVideoConfig getVideoConfig(ZegoPublishChannel main) {
        return ZegoExpressEngineJniAPI.getVideoConfigJni(main.value());
    }

    public void setVideoMirrorMode(ZegoVideoMirrorMode mirrorMode) {
        this.setVideoMirrorMode(mirrorMode, ZegoPublishChannel.MAIN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroyEngine(IZegoDestroyCompletionCallback callback) {
        Class<ZegoExpressEngineInternalImpl> clazz = ZegoExpressEngineInternalImpl.class;
        synchronized (ZegoExpressEngineInternalImpl.class) {
            int errorCode = 0;
            if (engine != null) {
                iZegoDestroyCompletionCallback = callback;
                ((ZegoExpressEngineInternalImpl)engine).release();
                errorCode = ZegoExpressEngineJniAPI.engineUninitAsyncJni();
            } else if (iZegoDestroyCompletionCallback != null) {
                iZegoDestroyCompletionCallback.onDestroyCompletion();
            }
            ZegoExpressEngineJniAPI.printDebugInfoJni(errorCode == 0 ? ZegoDebugLevel.INFO.value() : ZegoDebugLevel.ERROR.value(), 1, "destroyEngine", errorCode, new Object[0]);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEventHandler(IZegoEventHandler handler) {
        int errorCode = 0;
        Class<ZegoExpressEngineInternalImpl> clazz = ZegoExpressEngineInternalImpl.class;
        synchronized (ZegoExpressEngineInternalImpl.class) {
            if (engine == null) {
                errorCode = 1000001;
            } else if (eventHandler != null && handler != null) {
                errorCode = 1000008;
                ZegoExpressEngineInternalImpl.printDebugInfo(ZegoDebugLevel.ERROR, 1, "setEventHandler", 1000008, new Object[0]);
            } else {
                eventHandler = handler;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setApiCalledCallback(IZegoApiCalledEventHandler callback) {
        Class<ZegoExpressEngineInternalImpl> clazz = ZegoExpressEngineInternalImpl.class;
        synchronized (ZegoExpressEngineInternalImpl.class) {
            apiCalledEventHandler = callback;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void release() {
        eventHandler = null;
        if (sRoomSetExtraInfoHandler != null) {
            sRoomSetExtraInfoHandler.clear();
        }
        if (sPublisherUpdateCDNURLHandler != null) {
            sPublisherUpdateCDNURLHandler.clear();
        }
        if (sPublisherUpdateStreamExtraInfoHandler != null) {
            sPublisherUpdateStreamExtraInfoHandler.clear();
        }
        if (sMixerStartResultHandler != null) {
            sMixerStartResultHandler.clear();
        }
        if (sMixerStopResultHandler != null) {
            sMixerStopResultHandler.clear();
        }
        if (sIMSendBoradcastMssageHandler != null) {
            sIMSendBoradcastMssageHandler.clear();
        }
        if (sIMSendCustomCommandHandler != null) {
            sIMSendCustomCommandHandler.clear();
        }
        if (sIMSendBarragetMssageHandler != null) {
            sIMSendBarragetMssageHandler.clear();
        }
        if (sPublisherTakeSnapshotResultHandler != null) {
            sPublisherTakeSnapshotResultHandler.clear();
        }
        if (sPlayerTakeSnapshotResultHandler != null) {
            sPlayerTakeSnapshotResultHandler.clear();
        }
        if (sTestNetworkConnectivityHandler != null) {
            sTestNetworkConnectivityHandler.clear();
        }
        if (sNetworkProbeResultHandler != null) {
            sNetworkProbeResultHandler.clear();
        }
        if (sUploadLogResultHandler != null) {
            sUploadLogResultHandler.clear();
        }
        iZegoAudioMixingHandler = null;
        iZegoAudioDataHandler = null;
        mCustomVideoRenderHandler = null;
        mCustomVideoCaptureHandler = null;
        mCustomVideoProcessHandler = null;
        iZegoDataRecordEventHandler = null;
        iZegoCustomAudioProcessHandler = null;
        context = null;
        engine = null;
        mIsTestEnv = true;
        mUIHandler = null;
        language = ZegoLanguage.ENGLISH;
        ZegoMediaPlayerInternalImpl.destroyAllMediaPlayer();
    }

    public static String getVersion() {
        return ZegoExpressEngineJniAPI.getVersionJni();
    }

    @Override
    public void setDebugVerbose(boolean enable, ZegoLanguage language) {
        ZegoExpressEngineJniAPI.setDebugVerboseJni(enable, language.value());
        ZegoExpressEngineInternalImpl.printDebugInfo(ZegoDebugLevel.INFO, 1, "setDebugVerbose", 0, new Object[0]);
    }

    @Override
    public void loginRoom(String roomID, ZegoUser user) {
        this.loginRoom(roomID, user, null);
    }

    @Override
    public void uploadLog() {
        ZegoExpressEngineJniAPI.uploadLogJni();
        ZegoExpressEngineInternalImpl.printDebugInfo(ZegoDebugLevel.INFO, 1, "uploadLog", 0, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uploadLog(IZegoUploadLogResultCallback callback) {
        int seq = ZegoExpressEngineJniAPI.uploadLogJni();
        Class<ZegoExpressEngineInternalImpl> clazz = ZegoExpressEngineInternalImpl.class;
        synchronized (ZegoExpressEngineInternalImpl.class) {
            sUploadLogResultHandler.put(seq, callback);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            ZegoExpressEngineInternalImpl.printDebugInfo(ZegoDebugLevel.INFO, 1, "uploadLog", 0, new Object[0]);
            return;
        }
    }

    @Override
    public void loginRoom(String roomID, ZegoUser user, ZegoRoomConfig config) {
        int errorCode;
        if (roomID == null) {
            roomID = "";
        }
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode = ZegoExpressEngineJniAPI.loginRoomJni(user, roomID, config)) == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 2, "loginRoom", errorCode, new Object[0]);
    }

    @Override
    public void loginMultiRoom(String roomID, ZegoRoomConfig config) {
        int errorCode;
        if (roomID == null) {
            roomID = "";
        }
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode = ZegoExpressEngineJniAPI.loginMultiRoomJni(roomID, config)) == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 2, "loginMultiRoom", errorCode, new Object[0]);
    }

    public void loginRoom(String roomID, ZegoUser user, ZegoRoomConfig config, String token) {
        int errorCode = ZegoExpressEngineJniAPI.loginRoomJni(user, roomID, config, token);
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 2, "loginRoom", errorCode, new Object[0]);
    }

    @Override
    public void startPublishingStream(String streamID) {
        this.startPublishingStream(streamID, ZegoPublishChannel.MAIN);
    }

    @Override
    public boolean isMicrophoneMuted() {
        return ZegoExpressEngineJniAPI.isMicrophoneMutedJni();
    }

    @Override
    public boolean isSpeakerMuted() {
        return ZegoExpressEngineJniAPI.isSpeakerMutedJni();
    }

    @Override
    public void enableHeadphoneMonitor(boolean enable) {
        int errorCode = ZegoExpressEngineJniAPI.enableHeadphoneMonitorJni(enable);
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 6, "enableHeadphoneMonitor", errorCode, new Object[0]);
    }

    @Override
    public void enableAudioDataCallback(boolean enable, int callbackBitMask, ZegoAudioFrameParam param) {
        int errorCode;
        if (param == null) {
            param = new ZegoAudioFrameParam();
        }
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode = ZegoExpressEngineJniAPI.enableAudioDataCallbackJni(enable, callbackBitMask, param.sampleRate.value(), param.channel.value())) == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 12, "enablePlaybackAudioData", errorCode, new Object[0]);
    }

    @Override
    public void enableVirtualStereo(boolean enable, int angle) {
        int errorCode = ZegoExpressEngineJniAPI.enableVirtualStereoJni(enable, angle);
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 7, "enableVirtualStereo", errorCode, new Object[0]);
    }

    @Override
    public void setAudioEqualizerGain(int bandIndex, float bandGain) {
        int errorCode = ZegoExpressEngineJniAPI.setAudioEqualizerGainJni(bandIndex, bandGain);
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 7, "setAudioEqualizerGain", errorCode, new Object[0]);
    }

    @Override
    public void setVoiceChangerPreset(ZegoVoiceChangerPreset preset) {
        int errorCode = ZegoExpressEngineJniAPI.setVoiceChangerPresetJni(preset.value());
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 7, "setVoiceChangerPreset", errorCode, new Object[0]);
    }

    @Override
    public void setVoiceChangerParam(ZegoVoiceChangerParam param) {
        int errorCode = param != null ? ZegoExpressEngineJniAPI.setVoiceChangerParamJni(param.pitch) : 1007007;
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 7, "setVoiceChangerParam", errorCode, new Object[0]);
    }

    @Override
    public void setReverbPreset(ZegoReverbPreset preset) {
        int errorCode = ZegoExpressEngineJniAPI.setReverbPresetJni(preset.value());
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 7, "setReverbPreset", errorCode, new Object[0]);
    }

    @Override
    public void setReverbParam(ZegoReverbParam param) {
        int errorCode = param != null ? ZegoExpressEngineJniAPI.setReverbParamJni(param.damping, param.dryWetRatio, param.reverberance, param.roomSize) : 1007006;
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 7, "setVoiceChangerParam", errorCode, new Object[0]);
    }

    @Override
    public void setReverbAdvancedParam(ZegoReverbAdvancedParam param) {
        int errorCode = param != null ? ZegoExpressEngineJniAPI.setReverbAdvancedParam(param.roomSize, param.reverberance, param.damping, param.wetOnly, param.wetGain, param.dryGain, param.toneLow, param.toneHigh, param.preDelay, param.stereoWidth) : 1007006;
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 7, "setReverbAdvancedParam", errorCode, new Object[0]);
    }

    @Override
    public void setReverbEchoParam(ZegoReverbEchoParam param) {
        int errorCode = param != null ? ZegoExpressEngineJniAPI.setReverbEchoParamJni(param) : 1007017;
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 7, "setReverbEchoParam", errorCode, new Object[0]);
    }

    public void enableCustomVideoCapture(boolean enable, ZegoCustomVideoCaptureConfig config, ZegoPublishChannel channel) {
        int errorCode = ZegoExpressEngineJniAPI.enableCustomVideoCaptureJni(enable, config, channel.value());
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 1, "enableCustomVideoCapture", errorCode, new Object[0]);
    }

    public void enableCustomVideoRender(boolean enable, ZegoCustomVideoRenderConfig config) {
        int errorCode = ZegoExpressEngineJniAPI.enableCustomVideoRenderJni(enable, config);
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 1, "enableCustomVideoRender", errorCode, new Object[0]);
    }

    @Override
    public void setHeadphoneMonitorVolume(int volume) {
        int errorCode = ZegoExpressEngineJniAPI.setHeadphoneMonitorVolumeJni(volume);
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 6, "setHeadphoneMonitorVolume", errorCode, new Object[0]);
    }

    @Override
    public void logoutRoom(String roomID) {
        int errorCode = ZegoExpressEngineJniAPI.logoutRoomJni(roomID);
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 2, "logoutRoom", errorCode, new Object[0]);
    }

    @Override
    public void switchRoom(String fromRoomID, String toRoomID) {
        this.switchRoom(fromRoomID, toRoomID, null);
    }

    @Override
    public void switchRoom(String fromRoomID, String toRoomID, ZegoRoomConfig config) {
        int errorCode = ZegoExpressEngineJniAPI.switchRoomJni(fromRoomID, toRoomID, config);
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 2, "switchRoomJni", errorCode, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRoomExtraInfo(String roomID, String key, String value, IZegoRoomSetRoomExtraInfoCallback callback) {
        int seq = ZegoExpressEngineJniAPI.setRoomExtraInfoJni(roomID, key, value);
        Class<ZegoExpressEngineInternalImpl> clazz = ZegoExpressEngineInternalImpl.class;
        synchronized (ZegoExpressEngineInternalImpl.class) {
            sRoomSetExtraInfoHandler.put(seq, callback);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    public void setVideoMirrorMode(ZegoVideoMirrorMode mirrorMode, ZegoPublishChannel channel) {
        int errorCode = mirrorMode == null ? ZegoExpressEngineJniAPI.ZegoVideoMirrorModeJni(ZegoVideoMirrorMode.ONLY_PREVIEW_MIRROR.value(), channel.value()) : ZegoExpressEngineJniAPI.ZegoVideoMirrorModeJni(mirrorMode.value(), channel.value());
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "setVideoMirrorMode", errorCode, new Object[0]);
    }

    public void setAppOrientation(ZegoOrientation orientation) {
        this.setAppOrientation(orientation, ZegoPublishChannel.MAIN);
    }

    public void setAppOrientation(ZegoOrientation orientation, ZegoPublishChannel channel) {
        int errorCode = orientation == null ? ZegoExpressEngineJniAPI.setAppOrientationJni(ZegoOrientation.ORIENTATION_0.value(), channel.value()) : ZegoExpressEngineJniAPI.setAppOrientationJni(orientation.value(), channel.value());
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "setAppOrientation", errorCode, new Object[0]);
    }

    public void startPreview(ZegoCanvas canvas, ZegoPublishChannel channel) {
        int errorCode = canvas == null ? ZegoExpressEngineJniAPI.startPreviewJni(null, ZegoViewMode.ASPECT_FILL.value(), 0, channel.value()) : (canvas.viewMode == null ? ZegoExpressEngineJniAPI.startPreviewJni(canvas.view, ZegoViewMode.ASPECT_FILL.value(), canvas.backgroundColor, channel.value()) : ZegoExpressEngineJniAPI.startPreviewJni(canvas.view, canvas.viewMode.value(), canvas.backgroundColor, channel.value()));
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "startPreview", errorCode, new Object[0]);
    }

    @Override
    public void startPreview() {
        this.startPreview(null, ZegoPublishChannel.MAIN);
    }

    @Override
    public void stopPreview() {
        this.stopPreview(ZegoPublishChannel.MAIN);
    }

    public void stopPreview(ZegoPublishChannel channel) {
        int errorCode = ZegoExpressEngineJniAPI.stopPreviewJni(channel.value());
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "stopPreview", errorCode, new Object[0]);
    }

    public void setVideoConfig(ZegoVideoConfig config) {
        this.setVideoConfig(config, ZegoPublishChannel.MAIN);
    }

    public void setVideoConfig(ZegoVideoConfig videoConfig, ZegoPublishChannel channel) {
        int errorCode;
        ZegoVideoCodecID zegoVideoCodecID = ZegoVideoCodecID.DEFAULT;
        if (videoConfig != null && videoConfig.codecID != null) {
            zegoVideoCodecID = videoConfig.codecID;
        }
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode = ZegoExpressEngineJniAPI.setVideoConfigJni(videoConfig, channel.value(), zegoVideoCodecID.value())) == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "setVideoConfig", errorCode, new Object[0]);
    }

    public ZegoVideoConfig getVideoConfig() {
        return this.getVideoConfig(ZegoPublishChannel.MAIN);
    }

    @Override
    public void startPublishingStream(String streamID, ZegoPublishChannel channel) {
        int errorCode = ZegoExpressEngineJniAPI.startPublishingStreamJni(streamID, channel.value());
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "startPublish", errorCode, new Object[0]);
    }

    @Override
    public void stopPublishingStream() {
        this.stopPublishingStream(ZegoPublishChannel.MAIN);
    }

    @Override
    public void stopPublishingStream(ZegoPublishChannel channel) {
        int errorCode = ZegoExpressEngineJniAPI.stopPublishingStreamJni(channel.value());
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "stopPublishJni", errorCode, new Object[0]);
    }

    @Override
    public void setStreamExtraInfo(String extraInfo, IZegoPublisherSetStreamExtraInfoCallback callback) {
        this.setStreamExtraInfo(extraInfo, ZegoPublishChannel.MAIN, callback);
    }

    @Override
    public void mutePublishStreamAudio(boolean mute, ZegoPublishChannel channel) {
        int errorCode = ZegoExpressEngineJniAPI.mutePublishStreamAudioJni(mute, channel.value());
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "mutePublishStreamAudio", errorCode, new Object[0]);
    }

    public void mutePublishStreamVideo(boolean mute) {
        this.mutePublishStreamVideo(mute, ZegoPublishChannel.MAIN);
    }

    public void mutePublishStreamVideo(boolean mute, ZegoPublishChannel channel) {
        int errorCode = ZegoExpressEngineJniAPI.mutePublishStreamVideoJni(mute, channel.value());
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "mutePublishStreamVideo", errorCode, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStreamExtraInfo(String extraInfo, ZegoPublishChannel channel, IZegoPublisherSetStreamExtraInfoCallback handler) {
        int seq = ZegoExpressEngineJniAPI.setStreamExtraInfoJni(extraInfo, channel.value());
        Class<ZegoExpressEngineInternalImpl> clazz = ZegoExpressEngineInternalImpl.class;
        synchronized (ZegoExpressEngineInternalImpl.class) {
            sPublisherUpdateStreamExtraInfoHandler.put(new Integer(seq), handler);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    public void startPreview(ZegoCanvas canvas) {
        this.startPreview(canvas, ZegoPublishChannel.MAIN);
    }

    @Override
    public void setCaptureVolume(int volume) {
        int errorCode = ZegoExpressEngineJniAPI.setCaptureVolumeJni(volume);
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "setCaptureVolume", errorCode, new Object[0]);
    }

    @Override
    public void setAudioCaptureStereoMode(ZegoAudioCaptureStereoMode mode) {
        int errorCode = ZegoExpressEngineJniAPI.setAudioCaptureStereoModeJni(mode.value());
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "setAudioCaptureStereoMode", errorCode, new Object[0]);
    }

    @Override
    public void setAudioConfig(ZegoAudioConfig config) {
        this.setAudioConfig(config, ZegoPublishChannel.MAIN);
    }

    @Override
    public void setAudioConfig(ZegoAudioConfig config, ZegoPublishChannel publishChannel) {
        int errorCode = 0;
        errorCode = config != null ? ZegoExpressEngineJniAPI.setAudioConfigJni(config.bitrate, config.channel.value(), config.codecID.value(), publishChannel.value()) : ZegoExpressEngineJniAPI.setAudioConfigJni(-1, -1, -1, -1);
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "setAudioConfig", errorCode, new Object[0]);
    }

    @Override
    public void enableTrafficControl(boolean enable, int property) {
        this.enableTrafficControl(enable, property, ZegoPublishChannel.MAIN);
    }

    @Override
    public void enableTrafficControl(boolean enable, int property, ZegoPublishChannel channel) {
        int errorCode = ZegoExpressEngineJniAPI.enableTrafficControlJni(enable, property, channel.value());
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "enableTrafficControl", errorCode, new Object[0]);
    }

    public void setMinVideoBitrateForTrafficControl(int bitrate, ZegoTrafficControlMinVideoBitrateMode mode) {
        this.setMinVideoBitrateForTrafficControl(bitrate, mode, ZegoPublishChannel.MAIN);
    }

    public void setMinVideoBitrateForTrafficControl(int bitrate, ZegoTrafficControlMinVideoBitrateMode mode, ZegoPublishChannel channel) {
        int errorCode = ZegoExpressEngineJniAPI.setMinVideoBitrateForTrafficControlJni(bitrate, mode.value(), channel.value());
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "setMinVideoBitrateForTrafficControl", errorCode, new Object[0]);
    }

    @Override
    public void setTrafficControlFocusOn(ZegoTrafficControlFocusOnMode mode) {
        this.setTrafficControlFocusOn(mode, ZegoPublishChannel.MAIN);
    }

    @Override
    public void setTrafficControlFocusOn(ZegoTrafficControlFocusOnMode mode, ZegoPublishChannel channel) {
        int errorCode = ZegoExpressEngineJniAPI.setTrafficControlFocusOnJni(mode.value(), channel.value());
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "setTrafficControlFocusOn", errorCode, new Object[0]);
    }

    @Override
    public void enablePublishDirectToCDN(boolean enable, ZegoCDNConfig zegoCDNConfig, ZegoPublishChannel channel) {
        ZegoExpressEngineJniAPI.enablePublishDirectToCDNJni(enable, zegoCDNConfig, channel.value());
    }

    public void setPublishWatermark(ZegoWatermark watermark, boolean isPreviewVisible) {
        this.setPublishWatermark(watermark, isPreviewVisible, ZegoPublishChannel.MAIN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPublishCdnUrl(String streamID, String targetURL, IZegoPublisherUpdateCdnUrlCallback handler) {
        int seq = ZegoExpressEngineJniAPI.addPublishCdnUrlJni(streamID, targetURL);
        Class<ZegoExpressEngineInternalImpl> clazz = ZegoExpressEngineInternalImpl.class;
        synchronized (ZegoExpressEngineInternalImpl.class) {
            sPublisherUpdateCDNURLHandler.put(new Integer(seq), handler);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePublishCdnUrl(String streamID, String targetURL, IZegoPublisherUpdateCdnUrlCallback handler) {
        int seq = ZegoExpressEngineJniAPI.removePublishCdnUrlJni(streamID, targetURL);
        Class<ZegoExpressEngineInternalImpl> clazz = ZegoExpressEngineInternalImpl.class;
        synchronized (ZegoExpressEngineInternalImpl.class) {
            sPublisherUpdateCDNURLHandler.put(new Integer(seq), handler);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void enablePublishDirectToCDN(boolean enable, ZegoCDNConfig config) {
        this.enablePublishDirectToCDN(enable, config, ZegoPublishChannel.MAIN);
    }

    public void setCapturePipelineScaleMode(ZegoCapturePipelineScaleMode mode) {
        int errorCode = ZegoExpressEngineJniAPI.setCapturePipelineScaleModeJni(mode.value());
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "setCapturePipelineScaleMode", errorCode, new Object[0]);
    }

    public void startPlayingStream(String streamID, ZegoCanvas canvas) {
        this.startPlayingStream(streamID, canvas, null);
    }

    public void setPublishWatermark(ZegoWatermark watermark, boolean isPreviewVisible, ZegoPublishChannel channel) {
        int errorCode = ZegoExpressEngineJniAPI.setPublishWatermarkJni(watermark, isPreviewVisible, channel.value());
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "setPublishWatermark", errorCode, new Object[0]);
    }

    @Override
    public void setSEIConfig(ZegoSEIConfig config) {
        int errorCode = ZegoExpressEngineJniAPI.setSEIConfigJni(config);
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "setSEIConfig", errorCode, new Object[0]);
    }

    @Override
    public void sendSEI(byte[] data) {
        this.sendSEI(data, ZegoPublishChannel.MAIN);
    }

    @Override
    public void enableHardwareEncoder(boolean enable) {
        int errorCode = ZegoExpressEngineJniAPI.enableHardwareEncoderJni(enable);
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "enableHardwareEncoder", errorCode, new Object[0]);
    }

    public void startPlayingStream(String streamID, ZegoCanvas canvas, ZegoPlayerConfig config) {
        int videoLayer = 99;
        if (config != null && config.videoLayer != null) {
            videoLayer = config.videoLayer.value();
        }
        ZegoCDNConfig zegoCDNConfig = null;
        if (config != null && config.cdnConfig != null) {
            zegoCDNConfig = config.cdnConfig;
        }
        ZegoStreamResourceMode zegoStreamResourceMode = ZegoStreamResourceMode.DEFAULT;
        if (config != null && config.resourceMode != null) {
            zegoStreamResourceMode = config.resourceMode;
        }
        int errorCode = canvas == null ? ZegoExpressEngineJniAPI.startPlayingStreamJni(streamID, null, 0, 0, zegoCDNConfig, videoLayer, zegoStreamResourceMode.value()) : ZegoExpressEngineJniAPI.startPlayingStreamJni(streamID, canvas.view, canvas.viewMode == null ? ZegoViewMode.ASPECT_FIT.value() : canvas.viewMode.value(), canvas.backgroundColor, zegoCDNConfig, videoLayer, zegoStreamResourceMode.value());
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 4, "startPlayingStream", errorCode, new Object[0]);
    }

    @Override
    public void startPlayingStream(String streamID) {
        this.startPlayingStream(streamID, null, null);
    }

    @Override
    public void startPlayingStream(String streamID, ZegoPlayerConfig config) {
        this.startPlayingStream(streamID, null, config);
    }

    @Override
    public void stopPlayingStream(String streamID) {
        int errorCode = ZegoExpressEngineJniAPI.stopPlayingStreamJni(streamID);
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 4, "stopPlayingStream", errorCode, new Object[0]);
    }

    @Override
    public void setPlayStreamDecryptionKey(String streamID, String key) {
        int errorCode = ZegoExpressEngineJniAPI.setPlayStreamDecryptionKeyJni(streamID, key);
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 4, "setPlayStreamDecryptionKey", errorCode, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void takePlayStreamSnapshot(String streamID, IZegoPlayerTakeSnapshotCallback callback) {
        Class<ZegoExpressEngineInternalImpl> clazz = ZegoExpressEngineInternalImpl.class;
        synchronized (ZegoExpressEngineInternalImpl.class) {
            sPlayerTakeSnapshotResultHandler.put(streamID, callback);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            int errorCode = ZegoExpressEngineJniAPI.takePlayStreamSnapshotJni(streamID);
            ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 4, "takePlayStreamSnapshot", errorCode, new Object[0]);
            return;
        }
    }

    @Override
    public void setAllPlayStreamVolume(int volume) {
        int errorCode = ZegoExpressEngineJniAPI.setAllPlayStreamVolume(volume);
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 4, "setAllPlayStreamVolume", errorCode, new Object[0]);
    }

    @Override
    public void setAudioRouteToSpeaker(boolean defaultToSpeaker) {
        int errorCode = ZegoExpressEngineJniAPI.setAudioRouteToSpeakerJni(defaultToSpeaker);
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 6, "setAudioRouteToSpeakerJni", errorCode, new Object[0]);
    }

    @Override
    public void setPlayVolume(String streamID, int volume) {
        int errorCode = ZegoExpressEngineJniAPI.setPlayVolumeJni(streamID, volume);
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 4, "setPlayVolume", errorCode, new Object[0]);
    }

    public void setPlayStreamVideoLayer(String streamID, ZegoPlayerVideoLayer videoLayer) {
        int errorCode = ZegoExpressEngineJniAPI.setPlayStreamVideoLayerJni(streamID, videoLayer.value());
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 4, "setPlayStreamVideoLayer", errorCode, new Object[0]);
    }

    public void setPlayStreamVideoType(String streamID, ZegoVideoStreamType streamType) {
        int errorCode = ZegoExpressEngineJniAPI.setPlayStreamVideoTypeJni(streamID, streamType.value());
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 4, "setPlayStreamVideoType", errorCode, new Object[0]);
    }

    @Override
    public void setPlayStreamBufferIntervalRange(String streamID, int minBufferInterval, int maxBufferInterval) {
        int errorCode = ZegoExpressEngineJniAPI.setPlayStreamBufferIntervalRangeJni(streamID, minBufferInterval, maxBufferInterval);
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 4, "setPlayStreamBufferIntervalRange", errorCode, new Object[0]);
    }

    @Override
    public void setPlayStreamFocusOn(String streamID) {
        int errorCode = ZegoExpressEngineJniAPI.setPlayStreamFocusOnJni(streamID);
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 4, "setPlayStreamFocusOn", errorCode, new Object[0]);
    }

    @Override
    public void mutePlayStreamAudio(String streamID, boolean mute) {
        int errorCode = ZegoExpressEngineJniAPI.mutePlayStreamAudioJni(streamID, mute);
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 4, "mutePlayStreamAudio", errorCode, new Object[0]);
    }

    public void mutePlayStreamVideo(String streamID, boolean mute) {
        int errorCode = ZegoExpressEngineJniAPI.mutePlayStreamVideoJni(streamID, mute);
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 4, "mutePlayStreamVideo", errorCode, new Object[0]);
    }

    @Override
    public void muteAllPlayStreamAudio(boolean mute) {
        int errorCode = ZegoExpressEngineJniAPI.muteAllPlayStreamAudioJni(mute);
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 4, "muteAllPlayStreamAudio", errorCode, new Object[0]);
    }

    public void muteAllPlayStreamVideo(boolean mute) {
        int errorCode = ZegoExpressEngineJniAPI.muteAllPlayStreamVideoJni(mute);
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 4, "muteAllPlayStreamVideo", errorCode, new Object[0]);
    }

    @Override
    public void enableHardwareDecoder(boolean enable) {
        int errorCode = ZegoExpressEngineJniAPI.enableHardwareDecoderJni(enable);
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 4, "enableHardwareDecoder", errorCode, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startMixerTask(ZegoMixerTask task, IZegoMixerStartCallback handler) {
        int seq = ZegoExpressEngineJniAPI.startMixerJni(task);
        Class<ZegoExpressEngineInternalImpl> clazz = ZegoExpressEngineInternalImpl.class;
        synchronized (ZegoExpressEngineInternalImpl.class) {
            sMixerStartResultHandler.put(seq, handler);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            ZegoExpressEngineInternalImpl.printDebugInfo(ZegoDebugLevel.INFO, 5, "startMixerTask", 0, new Object[0]);
            return;
        }
    }

    @Override
    public void enableAudioMixing(boolean enable) {
        int errorCode = ZegoExpressEngineJniAPI.enableAudioMixingJni(enable);
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 1, "enableAudioMixing", errorCode, new Object[0]);
    }

    @Override
    public void setAudioMixingHandler(IZegoAudioMixingHandler handler) {
        iZegoAudioMixingHandler = handler;
    }

    @Override
    public void muteLocalAudioMixing(boolean mute) {
        int errorCode = ZegoExpressEngineJniAPI.muteLocalAudioMixingJni(mute);
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 1, "muteLocalAudioMixing", errorCode, new Object[0]);
    }

    @Override
    public void setAudioMixingVolume(int volume, ZegoVolumeType type) {
        int errorCode = ZegoExpressEngineJniAPI.setAudioMixingVolumeJniWithType(volume, type.value());
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 1, "setAudioMixingVolume", errorCode, new Object[0]);
    }

    public void enableBeautify(int featureBitmask) {
        this.enableBeautify(featureBitmask, ZegoPublishChannel.MAIN);
    }

    @Override
    public void setAudioMixingVolume(int volume) {
        int errorCode = ZegoExpressEngineJniAPI.setAudioMixingVolumeJni(volume);
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 1, "setAudioMixingVolume", errorCode, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopMixerTask(ZegoMixerTask task, IZegoMixerStopCallback handler) {
        int seq = ZegoExpressEngineJniAPI.stopMixerJni(task);
        Class<ZegoExpressEngineInternalImpl> clazz = ZegoExpressEngineInternalImpl.class;
        synchronized (ZegoExpressEngineInternalImpl.class) {
            sMixerStopResultHandler.put(seq, handler);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            ZegoExpressEngineInternalImpl.printDebugInfo(ZegoDebugLevel.INFO, 5, "stopMixerTask", 0, new Object[0]);
            return;
        }
    }

    @Override
    public void muteMicrophone(boolean mute) {
        int errorCode = ZegoExpressEngineJniAPI.muteMicrophoneJni(mute);
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "muteMicrophone", errorCode, new Object[0]);
    }

    @Override
    public void muteSpeaker(boolean enable) {
        int errorCode = ZegoExpressEngineJniAPI.muteSpeakerJni(enable);
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "muteSpeaker", errorCode, new Object[0]);
    }

    public void enableCamera(boolean enable, ZegoPublishChannel channel) {
        int errorCode = ZegoExpressEngineJniAPI.enableCameraJni(enable, channel.value());
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "enableCamera", errorCode, new Object[0]);
    }

    public void useFrontCamera(boolean enable) {
        this.useFrontCamera(enable, ZegoPublishChannel.MAIN);
    }

    public void useFrontCamera(boolean enable, ZegoPublishChannel channel) {
        int errorCode = ZegoExpressEngineJniAPI.useFrontCameraJni(enable, channel.value());
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "useFrontCamera", errorCode, new Object[0]);
    }

    public void setCameraZoomFactor(float factor) {
        this.setCameraZoomFactor(factor, ZegoPublishChannel.MAIN);
    }

    public void setCameraZoomFactor(float factor, ZegoPublishChannel channel) {
        int errorCode = ZegoExpressEngineJniAPI.setCameraZoomFactorJni(factor, channel.value());
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 6, "setCameraZoomFactor", errorCode, new Object[0]);
    }

    public float getCameraMaxZoomFactor() {
        return this.getCameraMaxZoomFactor(ZegoPublishChannel.MAIN);
    }

    public float getCameraMaxZoomFactor(ZegoPublishChannel channel) {
        ZegoExpressEngineInternalImpl.printDebugInfo(ZegoDebugLevel.INFO, 6, "getCameraMaxZoomFactor", 0, new Object[0]);
        return ZegoExpressEngineJniAPI.getCameraMaxZoomFactorJni(channel.value());
    }

    @Override
    public void startSoundLevelMonitor(int timeInMS) {
        int errorCode = ZegoExpressEngineJniAPI.startSoundLevelMonitorJni(timeInMS);
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "startSoundLevelMonitor", errorCode, new Object[0]);
    }

    @Override
    public void startSoundLevelMonitor() {
        int errorCode = ZegoExpressEngineJniAPI.startSoundLevelMonitorJni(100);
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "startSoundLevelMonitor", errorCode, new Object[0]);
    }

    @Override
    public void stopSoundLevelMonitor() {
        int errorCode = ZegoExpressEngineJniAPI.stopSoundLevelMonitorJni();
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "stopSoundLevelMonitor", errorCode, new Object[0]);
    }

    @Override
    public void startAudioSpectrumMonitor() {
        this.startAudioSpectrumMonitor(100);
    }

    @Override
    public void startAudioSpectrumMonitor(int timeInMS) {
        int errorCode = ZegoExpressEngineJniAPI.startFrequencySpectrumMonitorJni(timeInMS);
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "startFrequencySpectrumMonitor", errorCode, new Object[0]);
    }

    @Override
    public void stopAudioSpectrumMonitor() {
        int errorCode = ZegoExpressEngineJniAPI.stopFrequencySpectrumMonitorJni();
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "stopFrequencySpectrumMonitor", errorCode, new Object[0]);
    }

    @Override
    public void startPerformanceMonitor(int millisecond) {
        int errorCode = ZegoExpressEngineJniAPI.startPerformanceMonitorJni(millisecond);
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 6, "startPerformanceMonitor", errorCode, new Object[0]);
    }

    @Override
    public void stopPerformanceMonitor() {
        int errorCode = ZegoExpressEngineJniAPI.stopPerformanceMonitorJni();
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 6, "stopPerformanceMonitor", errorCode, new Object[0]);
    }

    @Override
    public void enableAudioCaptureDevice(boolean enable) {
        int errorCode = ZegoExpressEngineJniAPI.enableAudioCaptureDeviceJni(enable);
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "enableCaptureDevice", errorCode, new Object[0]);
    }

    @Override
    public void enableAEC(boolean enable) {
        int errorCode = ZegoExpressEngineJniAPI.enableAECJni(enable);
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "enableAEC", errorCode, new Object[0]);
    }

    @Override
    public void enableHeadphoneAEC(boolean enable) {
        int errorCode = ZegoExpressEngineJniAPI.enableHeadphoneAECJni(enable);
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 7, "enableAECWhenHeadsetDetected", errorCode, new Object[0]);
    }

    @Override
    public void setAECMode(ZegoAECMode mode) {
        int errorCode = ZegoExpressEngineJniAPI.setAECModeJni(mode.value());
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "setAECMode", errorCode, new Object[0]);
    }

    public void enableCheckPoc(boolean enable) {
        int errorCode = ZegoExpressEngineJniAPI.enableCheckPocJni(enable);
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "enableCheckPoc", errorCode, new Object[0]);
    }

    @Override
    public void enableAGC(boolean enable) {
        int errorCode = ZegoExpressEngineJniAPI.enableAGCJni(enable);
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "enableAGC", errorCode, new Object[0]);
    }

    @Override
    public void enableANS(boolean enable) {
        int errorCode = ZegoExpressEngineJniAPI.enableANSJni(enable);
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "enableANS", errorCode, new Object[0]);
    }

    @Override
    public void enableTransientANS(boolean enable) {
        int errorCode = ZegoExpressEngineJniAPI.enableTransientANSJni(enable);
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "enableTransientANS", errorCode, new Object[0]);
    }

    @Override
    public void setANSMode(ZegoANSMode mode) {
        int errorCode = ZegoExpressEngineJniAPI.setANSModeJni(mode.value());
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 7, "setANSMode", errorCode, new Object[0]);
    }

    public void enableBeautify(int feature, ZegoPublishChannel channel) {
        int errorCode = ZegoExpressEngineJniAPI.enableBeautifyJni(feature, channel.value());
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "enableBeautify", errorCode, new Object[0]);
    }

    public void setBeautifyOption(ZegoBeautifyOption option) {
        this.setBeautifyOption(option, ZegoPublishChannel.MAIN);
    }

    public void setBeautifyOption(ZegoBeautifyOption option, ZegoPublishChannel channel) {
        int errorCode = ZegoExpressEngineJniAPI.setBeautifyOptionJni(option, channel.value());
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "setBeautifyOption", errorCode, new Object[0]);
    }

    @Override
    public void sendSEI(byte[] data, ZegoPublishChannel channel) {
        int errorCode = ZegoExpressEngineJniAPI.sendSEIJni(data, channel.value());
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "sendSEI", errorCode, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendBarrageMessage(String roomID, String message, IZegoIMSendBarrageMessageCallback handler) {
        int seq = ZegoExpressEngineJniAPI.sendBarrageMessageJni(roomID, message);
        Class<ZegoExpressEngineInternalImpl> clazz = ZegoExpressEngineInternalImpl.class;
        synchronized (ZegoExpressEngineInternalImpl.class) {
            sIMSendBarragetMssageHandler.put(seq, handler);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    @Override
    public ZegoMediaPlayer createMediaPlayer() {
        return ZegoMediaPlayerInternalImpl.createMediaPlayer();
    }

    @Override
    public ZegoAudioEffectPlayer createAudioEffectPlayer() {
        return ZegoAudioEffectPlayerInternalImpl.createAudioEffectPlayer();
    }

    @Override
    public void destroyAudioEffectPlayer(ZegoAudioEffectPlayer audioEffectPlayer) {
        ZegoAudioEffectPlayerInternalImpl.destroyAudioEffectPlayer(audioEffectPlayer);
    }

    @Override
    public void destroyMediaPlayer(ZegoMediaPlayer mediaPlayer) {
        ZegoMediaPlayerInternalImpl.destroyMediaPlayer(mediaPlayer);
    }

    public void setCustomVideoRenderHandler(IZegoCustomVideoRenderHandler handler) {
        mCustomVideoRenderHandler = handler;
    }

    public void enableCustomVideoCapture(boolean enable, ZegoCustomVideoCaptureConfig config) {
        this.enableCustomVideoCapture(enable, config, ZegoPublishChannel.MAIN);
    }

    public void setCustomVideoCaptureHandler(IZegoCustomVideoCaptureHandler handler) {
        mCustomVideoCaptureHandler = handler;
    }

    public void sendCustomVideoCaptureRawData(ByteBuffer data, int dataLength, ZegoVideoFrameParam params, long referenceTimeMillisecond) {
        this.sendCustomVideoCaptureRawData(data, dataLength, params, referenceTimeMillisecond, ZegoPublishChannel.MAIN);
    }

    public void enableCustomVideoProcessing(boolean enable, ZegoCustomVideoProcessConfig config) {
        this.enableCustomVideoProcessing(enable, config, ZegoPublishChannel.MAIN);
    }

    public void setCustomVideoProcessHandler(IZegoCustomVideoProcessHandler handler) {
        mCustomVideoProcessHandler = handler;
    }

    public void enableCustomVideoProcessing(boolean enable, ZegoCustomVideoProcessConfig config, ZegoPublishChannel channel) {
        int errorCode = ZegoExpressEngineJniAPI.enableCustomVideoProcessingJni(enable, config, channel.value());
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 1, "enableCustomVideoProcessing", errorCode, new Object[0]);
    }

    public void sendCustomVideoProcessedTextureData(int textureID, int width, int height, long referenceTimeMillisecond) {
        this.sendCustomVideoProcessedTextureData(textureID, width, height, referenceTimeMillisecond, ZegoPublishChannel.MAIN);
    }

    public void sendCustomVideoProcessedTextureData(int textureID, int width, int height, long referenceTimeMillisecond, ZegoPublishChannel channel) {
        int errorCode = ZegoExpressEngineJniAPI.sendCustomVideoProcessedTextureDataJni(textureID, width, height, referenceTimeMillisecond, channel.value());
        if (errorCode != 0) {
            ZegoExpressEngineInternalImpl.printDebugInfoEx(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 11, "sendCustomVideoProcessedTextureData", errorCode, false, new Object[0]);
        }
    }

    public SurfaceTexture getCustomVideoProcessOutputSurfaceTexture(int width, int height) {
        return this.getCustomVideoProcessOutputSurfaceTexture(width, height, ZegoPublishChannel.MAIN);
    }

    public SurfaceTexture getCustomVideoProcessOutputSurfaceTexture(int width, int height, ZegoPublishChannel channel) {
        SurfaceTexture surfaceTexture = ZegoExpressEngineJniAPI.getCustomVideoProcessOutputSurfaceTextureJni(width, height, ZegoPublishChannel.MAIN.value());
        return surfaceTexture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendBroadcastMessage(String roomID, String message, IZegoIMSendBroadcastMessageCallback callback) {
        int seq = ZegoExpressEngineJniAPI.sendBroadcastMessageJni(roomID, message);
        Class<ZegoExpressEngineInternalImpl> clazz = ZegoExpressEngineInternalImpl.class;
        synchronized (ZegoExpressEngineInternalImpl.class) {
            sIMSendBoradcastMssageHandler.put(seq, callback);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            ZegoExpressEngineInternalImpl.printDebugInfo(ZegoDebugLevel.INFO, 9, "sendBroadcastMessage", 0, new Object[0]);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendCustomCommand(String roomID, String command, ArrayList<ZegoUser> toUserList, IZegoIMSendCustomCommandCallback callback) {
        if (toUserList == null) {
            toUserList = new ArrayList();
        }
        int size = toUserList.size();
        ZegoUser[] userList = toUserList.toArray(new ZegoUser[size]);
        int seq = ZegoExpressEngineJniAPI.sendCustomerMessageJni(command, userList, roomID);
        Class<ZegoExpressEngineInternalImpl> clazz = ZegoExpressEngineInternalImpl.class;
        synchronized (ZegoExpressEngineInternalImpl.class) {
            sIMSendCustomCommandHandler.put(seq, callback);
            // ** MonitorExit[var8_8] (shouldn't be in output)
            ZegoExpressEngineInternalImpl.printDebugInfo(ZegoDebugLevel.INFO, 9, "sendCustomCommand", 0, new Object[0]);
            return;
        }
    }

    public void sendCustomVideoCaptureRawData(ByteBuffer data, int dataLength, ZegoVideoFrameParam params, long referenceTimeMillisecond, ZegoPublishChannel channel) {
        int errorCode = ZegoExpressEngineJniAPI.sendCustomVideoCaptureRawDataJni(data, dataLength, params.format.value(), params.strides, params.width, params.height, referenceTimeMillisecond, channel.value(), params.rotation);
        if (errorCode != 0) {
            ZegoExpressEngineInternalImpl.printDebugInfoEx(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 11, "sendCustomVideoCaptureRawData", errorCode, false, new Object[0]);
        }
    }

    public void sendCustomVideoCaptureTextureData(int textureID, int width, int height, double referenceTimeMillisecond) {
        this.sendCustomVideoCaptureTextureData(textureID, width, height, referenceTimeMillisecond, ZegoPublishChannel.MAIN);
    }

    public void sendCustomVideoCaptureEncodedData(ByteBuffer data, int dataLength, ZegoVideoEncodedFrameParam params, long referenceTimeMillisecond, ZegoPublishChannel channel) {
        int errorCode = ZegoExpressEngineJniAPI.sendCustomVideoCaptureEncodedDataJni(data, dataLength, params.format.value(), params.isKeyFrame, params.width, params.height, params.SEIData, params.SEIDataLength, params.rotation, referenceTimeMillisecond, channel.value());
        if (errorCode != 0) {
            ZegoExpressEngineInternalImpl.printDebugInfoEx(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 11, "sendCustomVideoCaptureEncodedData", errorCode, false, new Object[0]);
        }
    }

    public void setCustomVideoCaptureFillMode(ZegoViewMode mode) {
        this.setCustomVideoCaptureFillMode(mode, ZegoPublishChannel.MAIN);
    }

    public void setCustomVideoCaptureFillMode(ZegoViewMode mode, ZegoPublishChannel channel) {
        int errorCode = ZegoExpressEngineJniAPI.setCustomVideoCaptureFillModeJni(mode.value(), channel.value());
        if (errorCode != 0) {
            ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 11, "setCustomVideoCaptureFillMode", errorCode, new Object[0]);
        }
    }

    public void setCustomVideoCaptureFlipMode(ZegoVideoFlipMode mode) {
        this.setCustomVideoCaptureFlipMode(mode, ZegoPublishChannel.MAIN);
    }

    public void setCustomVideoCaptureFlipMode(ZegoVideoFlipMode mode, ZegoPublishChannel channel) {
        ZegoExpressEngineJniAPI.setCustomVideoCaptureFlipModeJni(mode.value(), channel.value());
    }

    public void sendCustomVideoCaptureTextureData(int textureID, int width, int height, double referenceTimeMillisecond, ZegoPublishChannel channel) {
        int errorCode = ZegoExpressEngineJniAPI.sendCustomVideoCaptureTextureDataJni(textureID, width, height, referenceTimeMillisecond, channel.value());
        if (errorCode != 0) {
            ZegoExpressEngineInternalImpl.printDebugInfoEx(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 11, "sendCustomVideoCaptureTextureData", errorCode, false, new Object[0]);
        }
    }

    public SurfaceTexture getCustomVideoCaptureSurfaceTexture() {
        SurfaceTexture surfaceTexture = ZegoExpressEngineJniAPI.getCustomVideoCaptureSurfaceTextureJni(ZegoPublishChannel.MAIN.value());
        return surfaceTexture;
    }

    public SurfaceTexture getCustomVideoCaptureSurfaceTexture(ZegoPublishChannel channel) {
        SurfaceTexture surfaceTexture = ZegoExpressEngineJniAPI.getCustomVideoCaptureSurfaceTextureJni(channel.value());
        return surfaceTexture;
    }

    public void sendCustomVideoCaptureEncodedData(ByteBuffer data, int dataLength, ZegoVideoEncodedFrameParam params, long referenceTimeMillisecond) {
        this.sendCustomVideoCaptureEncodedData(data, dataLength, params, referenceTimeMillisecond, ZegoPublishChannel.MAIN);
    }

    @Override
    public void setBuiltInSpeakerOn(boolean enable) {
        int errorCode = ZegoExpressEngineJniAPI.setBuiltInSpeakerOnJni(enable);
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 6, "setBuiltInSpeakerOn", errorCode, new Object[0]);
    }

    public void enableCamera(boolean enable) {
        this.enableCamera(enable, ZegoPublishChannel.MAIN);
    }

    public static void printDebugInfo(ZegoDebugLevel level, int module, String funcName, int errorCode, Object ... args) {
        ZegoExpressEngineInternalImpl.printDebugInfoEx(level, module, funcName, errorCode, true, args);
    }

    public static void printDebugInfoEx(ZegoDebugLevel level, int module, String funcName, int errorCode, boolean isToast, Object ... args) {
        String msg = ZegoExpressEngineJniAPI.printDebugInfoJni(level.value(), module, funcName, errorCode, args);
        if (!msg.equals("")) {
            ZegoExpressEngineInternalImpl.onApiCalledResult(errorCode, funcName, msg);
            if (errorCode != 0 && mIsTestEnv && enableToastOnTestEnv && isToast) {
                ZegoExpressEngineJniAPI.showDebugMessageBoxJni(language.value(), errorCode, funcName, msg);
            }
            if (errorCode != 0 || enableDebugErrorAlways) {
                if (mUIHandler == null) {
                    return;
                }
                ZegoExpressEngineInternalImpl.onDebugError(errorCode, funcName, msg);
            }
        }
    }

    private static void onApiCalledResult(final int errorCode, final String funcName, final String msg) {
        Handler uiHandler = mUIHandler;
        if (uiHandler == null) {
            uiHandler = new Handler(Looper.getMainLooper());
        }
        uiHandler.post(new Runnable(){

            @Override
            public void run() {
                IZegoApiCalledEventHandler zegoApiCalledEventHandler = apiCalledEventHandler;
                if (zegoApiCalledEventHandler != null) {
                    zegoApiCalledEventHandler.onApiCalledResult(errorCode, funcName, msg);
                }
            }
        });
    }

    @Override
    public void setAudioDataHandler(IZegoAudioDataHandler handler) {
        iZegoAudioDataHandler = handler;
    }

    @Override
    public void enableCustomAudioIO(boolean enable, ZegoCustomAudioConfig config) {
        this.enableCustomAudioIO(enable, config, ZegoPublishChannel.MAIN);
    }

    public static void showToastMsg(final String msg, final Context context) {
        if (context != null) {
            try {
                if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
                    Toast.makeText((Context)context, (CharSequence)msg, (int)1).show();
                } else {
                    Handler uiHandler = mUIHandler;
                    uiHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            Toast.makeText((Context)context, (CharSequence)msg, (int)1).show();
                        }
                    });
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void onDebugError(final int errorCode, final String funcName, final String info) {
        Handler uiHandler = mUIHandler;
        if (uiHandler == null) {
            return;
        }
        uiHandler.post(new Runnable(){

            @Override
            public void run() {
                IZegoEventHandler mEventHandler = eventHandler;
                if (mEventHandler != null) {
                    mEventHandler.onDebugError(errorCode, funcName, info);
                }
            }
        });
    }

    @Override
    public void sendCustomAudioCapturePCMData(ByteBuffer data, int dataLength, ZegoAudioFrameParam param, ZegoPublishChannel channel) {
        int errorCode;
        if (param == null) {
            param = new ZegoAudioFrameParam();
        }
        if ((errorCode = ZegoExpressEngineJniAPI.sendCustomAudioCapturePCMDataJni(data, dataLength, param.sampleRate.value(), param.channel.value(), channel == null ? ZegoPublishChannel.MAIN.value() : channel.value())) != 0) {
            ZegoExpressEngineInternalImpl.printDebugInfoEx(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 12, "sendCustomAudioCapturePCMData", errorCode, false, new Object[0]);
        }
    }

    @Override
    public void sendCustomAudioCaptureAACData(ByteBuffer data, int dataLength, int configLength, long referenceTimeMillisecond, ZegoAudioFrameParam param, ZegoPublishChannel channel) {
        int errorCode;
        if (param == null) {
            param = new ZegoAudioFrameParam();
        }
        if ((errorCode = ZegoExpressEngineJniAPI.sendCustomAudioCaptureAACDataJni(data, dataLength, configLength, referenceTimeMillisecond, param.sampleRate.value(), param.channel.value(), channel == null ? ZegoPublishChannel.MAIN.value() : channel.value())) != 0) {
            ZegoExpressEngineInternalImpl.printDebugInfoEx(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 12, "sendCustomAudioCaptureAACData", errorCode, false, new Object[0]);
        }
    }

    @Override
    public void sendCustomAudioCapturePCMData(ByteBuffer data, int dataLength, ZegoAudioFrameParam param) {
        this.sendCustomAudioCapturePCMData(data, dataLength, param, ZegoPublishChannel.MAIN);
    }

    @Override
    public void fetchCustomAudioRenderPCMData(ByteBuffer data, int dataLength, ZegoAudioFrameParam param) {
        int errorCode;
        if (param == null) {
            param = new ZegoAudioFrameParam();
        }
        if ((errorCode = ZegoExpressEngineJniAPI.fetchCustomAudioRenderPCMDataJni(data, dataLength, param.sampleRate.value(), param.channel.value())) != 0) {
            ZegoExpressEngineInternalImpl.printDebugInfoEx(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 12, "fetchCustomAudioRenderPCMData", errorCode, false, new Object[0]);
        }
    }

    @Override
    public void enableCustomAudioIO(boolean enable, ZegoCustomAudioConfig config, ZegoPublishChannel channel) {
        if (config == null) {
            config = new ZegoCustomAudioConfig();
        }
        int errorCode = ZegoExpressEngineJniAPI.enableCustomAudioIOJni(enable, config.sourceType.value(), channel != null ? channel.value() : ZegoPublishChannel.MAIN.value());
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 12, "enableCustomAudioIO", errorCode, new Object[0]);
    }

    @Override
    public void sendCustomAudioCaptureAACData(ByteBuffer data, int dataLength, int configLength, long referenceTimeMillisecond, ZegoAudioFrameParam param) {
        this.sendCustomAudioCaptureAACData(data, dataLength, configLength, referenceTimeMillisecond, param, ZegoPublishChannel.MAIN);
    }

    @Override
    public void startRecordingCapturedData(ZegoDataRecordConfig config, ZegoPublishChannel channel) {
        if (config == null) {
            config = new ZegoDataRecordConfig();
        }
        if (config.recordType == null) {
            config.recordType = ZegoDataRecordType.DEFAULT;
        }
        int errorCode = ZegoExpressEngineJniAPI.startRecordingCapturedDataJni(config.filePath, config.recordType.value(), channel != null ? channel.value() : ZegoPublishChannel.MAIN.value());
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 10, "startRecordingCapturedData", errorCode, new Object[0]);
    }

    @Override
    public void stopRecordingCapturedData(ZegoPublishChannel channel) {
        int errorCode = ZegoExpressEngineJniAPI.stopRecordingCapturedDataJni(channel != null ? channel.value() : ZegoPublishChannel.MAIN.value());
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 10, "stopRecordingCapturedData", errorCode, new Object[0]);
    }

    @Override
    public void setDataRecordEventHandler(IZegoDataRecordEventHandler handler) {
        iZegoDataRecordEventHandler = handler;
    }

    @Override
    public void enableCustomAudioCaptureProcessing(boolean enable, ZegoCustomAudioProcessConfig config) {
        int samples = 0;
        int channel = 0;
        int sampleRate = 0;
        if (config != null) {
            samples = config.samples;
            channel = config.channel.value();
            sampleRate = config.sampleRate.value();
        }
        ZegoExpressEngineJniAPI.enableCustomAudioCaptureProcessingJni(enable, samples, channel, sampleRate);
    }

    @Override
    public void enableCustomAudioRemoteProcessing(boolean enable, ZegoCustomAudioProcessConfig config) {
        int samples = 0;
        int channel = 0;
        int sampleRate = 0;
        if (config != null) {
            samples = config.samples;
            channel = config.channel.value();
            sampleRate = config.sampleRate.value();
        }
        ZegoExpressEngineJniAPI.enableCustomAudioRemoteProcessingJni(enable, samples, channel, sampleRate);
    }

    private static void setPlatformLanguage(int platform) {
        ZegoExpressEngineJniAPI.setPlatformLanguageJni(platform);
    }

    private static void logNotice(String log, String module) {
        ZegoExpressEngineJniAPI.logNoticeJni(log, module);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNetworkConnectivity(IZegoTestNetworkConnectivityCallback callback) {
        int seq = ZegoExpressEngineJniAPI.testNetworkConnectivityJni();
        Class<ZegoExpressEngineInternalImpl> clazz = ZegoExpressEngineInternalImpl.class;
        synchronized (ZegoExpressEngineInternalImpl.class) {
            sTestNetworkConnectivityHandler.put(seq, callback);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            ZegoExpressEngineInternalImpl.printDebugInfo(ZegoDebugLevel.INFO, 15, "testNetworkConnectivity", 0, new Object[0]);
            return;
        }
    }

    @Override
    public void startNetworkSpeedTest(ZegoNetworkSpeedTestConfig config) {
        int errorCode = ZegoExpressEngineJniAPI.startNetworkSpeedTest(config);
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 15, "startNetworkSpeedTest", errorCode, new Object[0]);
    }

    @Override
    public void stopNetworkSpeedTest() {
        int errorCode = ZegoExpressEngineJniAPI.stopNetworkSpeedTest();
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 15, "stopNetworkSpeedTest", errorCode, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startNetworkProbe(ZegoNetworkProbeConfig config, IZegoNetworkProbeResultCallback callback) {
        int seq = ZegoExpressEngineJniAPI.startNetworkProbeJni(config);
        Class<ZegoExpressEngineInternalImpl> clazz = ZegoExpressEngineInternalImpl.class;
        synchronized (ZegoExpressEngineInternalImpl.class) {
            sNetworkProbeResultHandler.put(seq, callback);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            ZegoExpressEngineInternalImpl.printDebugInfo(ZegoDebugLevel.INFO, 15, "startNetworkProbe", 0, new Object[0]);
            return;
        }
    }

    @Override
    public void stopNetworkProbe() {
        int errorCode = ZegoExpressEngineJniAPI.stopNetworkProbeJni();
        ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 15, "stopNetworkProbe", errorCode, new Object[0]);
    }

    static {
        engine = null;
        mIsTestEnv = true;
        enableToastOnTestEnv = true;
        enableDebugErrorAlways = false;
        language = ZegoLanguage.ENGLISH;
        eventHandler = null;
        apiCalledEventHandler = null;
        iZegoCustomAudioProcessHandler = null;
        sRoomSetExtraInfoHandler = new HashMap();
        sPublisherUpdateCDNURLHandler = new HashMap();
        sPublisherUpdateStreamExtraInfoHandler = new HashMap();
        sIMSendBarragetMssageHandler = new HashMap();
        sMixerStartResultHandler = new HashMap();
        sMixerStopResultHandler = new HashMap();
        sIMSendBoradcastMssageHandler = new HashMap();
        sIMSendCustomCommandHandler = new HashMap();
        sPublisherTakeSnapshotResultHandler = new HashMap();
        sPlayerTakeSnapshotResultHandler = new HashMap();
        sTestNetworkConnectivityHandler = new HashMap();
        sNetworkProbeResultHandler = new HashMap();
        sUploadLogResultHandler = new HashMap();
        try {
            System.loadLibrary("ZegoExpressEngine");
            hasSoLoaded = true;
        }
        catch (UnsatisfiedLinkError e) {
            Log.e((String)"ZEGO", (String)"load ZegoExpressSDK native library failed", (Throwable)e);
            hasSoLoaded = false;
        }
        isCustomVideoCapturing = false;
    }

    public static final class ZegoInnerModule {
        public static final int COMMON = 0;
        public static final int ENGINE = 1;
        public static final int ROOM = 2;
        public static final int PUBLISHER = 3;
        public static final int PLAYER = 4;
        public static final int MIXER = 5;
        public static final int DEVICE = 6;
        public static final int PREPROCESS = 7;
        public static final int MEDIAPLAYER = 8;
        public static final int IM = 9;
        public static final int RECODER = 10;
        public static final int CUSTOM_VIDEO_IO = 11;
        public static final int CUSTOM_AUDIO_IO = 12;
        public static final int AUDIO_EFFECT_PLAYER = 14;
        public static final int UTILITIES = 15;
    }
}

