package im.zego.zegoexpress.internal;

import android.graphics.Bitmap;
import android.graphics.SurfaceTexture;
import android.os.Handler;

import org.json.JSONException;
import org.json.JSONObject;

import im.zego.zegoexpress.callback.IZegoAudioDataHandler;
import im.zego.zegoexpress.callback.IZegoAudioMixingHandler;
import im.zego.zegoexpress.callback.IZegoCustomAudioProcessHandler;
import im.zego.zegoexpress.callback.IZegoDataRecordEventHandler;
import im.zego.zegoexpress.callback.IZegoDestroyCompletionCallback;
import im.zego.zegoexpress.callback.IZegoEventHandler;
import im.zego.zegoexpress.callback.IZegoIMSendBarrageMessageCallback;
import im.zego.zegoexpress.callback.IZegoIMSendBroadcastMessageCallback;
import im.zego.zegoexpress.callback.IZegoIMSendCustomCommandCallback;
import im.zego.zegoexpress.callback.IZegoMixerStartCallback;
import im.zego.zegoexpress.callback.IZegoMixerStopCallback;
import im.zego.zegoexpress.callback.IZegoPlayerTakeSnapshotCallback;
import im.zego.zegoexpress.callback.IZegoPublisherSetStreamExtraInfoCallback;
import im.zego.zegoexpress.callback.IZegoPublisherTakeSnapshotCallback;
import im.zego.zegoexpress.callback.IZegoPublisherUpdateCdnUrlCallback;
import im.zego.zegoexpress.callback.IZegoRoomSetRoomExtraInfoCallback;
import im.zego.zegoexpress.callback.IZegoTestNetworkConnectivityCallback;
import im.zego.zegoexpress.callback.IZegoNetworkProbeResultCallback;
import im.zego.zegoexpress.callback.IZegoUploadLogResultCallback;
import im.zego.zegoexpress.constants.*;
import im.zego.zegoexpress.entity.*;
import im.zego.zegoexpress.utils.ZegoCallbackHelpers;
import im.zego.zegoexpress.utils.ZegoDebugLevel;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

import static im.zego.zegoexpress.internal.ZegoExpressEngineInternalImpl.*;
import static im.zego.zegoexpress.internal.ZegoExpressEngineInternalImpl.isCustomVideoCapturing;

class ZegoExpressEngineJniCallback {

    // opt_content_start: audio_or_video = video
    static void onCustomVideoCaptureWillStart(final int channel) {
        final Handler handler = mUIHandler;
        if (handler == null) {
            return;
        }
        handler.post(new Runnable() {
            @Override
            public void run() {
                final Object customVideoCaptureHandler = mCustomVideoCaptureHandler;
                if (customVideoCaptureHandler != null) {
                    // 经讨论，外部采集的通知不切线程
                    ZegoCallbackHelpers.callCustomVideoCaptureOnStartMethod(customVideoCaptureHandler, ZegoPublishChannel.getZegoPublishChannel(channel));
                    isCustomVideoCapturing = true;

                } else {
                    
                }
            }
        });
    }
    // opt_content_end: audio_or_video = video

    // opt_content_start: audio_or_video = video
    public static void onCustomVideoCaptureWillStop(final int channel) {
        final Handler handler = mUIHandler;
        if (handler == null) {
            return;
        }
        handler.post(new Runnable() {
            @Override
            public void run() {
                final Object customVideoCaptureHandler = mCustomVideoCaptureHandler;
                if (customVideoCaptureHandler != null && isCustomVideoCapturing) {
                    // 经讨论，外部采集的通知不切线程
                    ZegoCallbackHelpers.callCustomVideoCaptureOnStopMethod(customVideoCaptureHandler, ZegoPublishChannel.values()[channel]);
                    isCustomVideoCapturing = false;
                } else {
                    
                }
            }
        });
    }
    // opt_content_end: audio_or_video = video



    //TODO:确认ZegoLiveRoom.java和ZegoLiveRoomJNI.java中的onLoginRoom接口处理的差别
    //TODO:这里数组不指定长度，是否会有问题？
    public static void onRoomStreamUpdate(final String roomID, final int updateType, final ZegoStream[] streamList, final String extendedData) {
        // printDebugInfo(ZegoDebugLevel.INFO, ZegoInnerModule.ROOM, "onRoomStreamUpdate", 0);
        final ArrayList<ZegoStream> streamArrayList = new ArrayList<ZegoStream>();
        for (int i = 0; i < streamList.length; i++) {
            streamArrayList.add(streamList[i]);
        }

        final Handler uiHandler = mUIHandler;
        if (uiHandler == null) {
            
            return;
        }
        uiHandler.post(new Runnable() {
            @Override
            public void run() {
                final IZegoEventHandler mEventHandler = eventHandler;
                if (mEventHandler != null) {
                    mEventHandler.onRoomStreamUpdate(roomID, ZegoUpdateType.values()[updateType], streamArrayList, getJsonObject(extendedData));
                    mEventHandler.onRoomStreamUpdate(roomID, ZegoUpdateType.values()[updateType], streamArrayList); // TODO: Deprecated
                }

            }
        });

    }

    public static ZegoAudioMixingData onAudioMixingCopyData(int dataLength) {
        final IZegoAudioMixingHandler mZegoAudioMixingHandle = iZegoAudioMixingHandler;
        if (mZegoAudioMixingHandle != null) {
            return mZegoAudioMixingHandle.onAudioMixingCopyData(dataLength);
        }
        return null;
    }

    public static void onRoomStateUpdate(final String roomID, final int state, final int errorCode, final String extendedData) {
        if (state == ZegoRoomState.DISCONNECTED.value() && errorCode != 0) {
            printDebugInfo(ZegoDebugLevel.INFO, ZegoInnerModule.ROOM, "onRoomStateUpdate", errorCode);
        }
        final Handler uiHandler = mUIHandler;
        if (uiHandler == null) {
            
            return;
        }
        uiHandler.post(new Runnable() {
            @Override
            public void run() {
                final IZegoEventHandler mEventHandler = eventHandler;
                if (mEventHandler != null) {
                    mEventHandler.onRoomStateUpdate(roomID, ZegoRoomState.values()[state], errorCode, getJsonObject(extendedData));
                }
            }
        });
    }

    public static void onRoomExtraInfoUpdate(final String roomID, final ZegoRoomExtraInfo[] roomExtraInfoList) {
        final ArrayList<ZegoRoomExtraInfo> infoArrayList = new ArrayList<>();
        for (int i = 0; i < roomExtraInfoList.length; i++) {
            infoArrayList.add(roomExtraInfoList[i]);
        }
        final Handler uiHandler = mUIHandler;
        if (uiHandler == null) {
            
            return;
        }
        uiHandler.post(new Runnable() {
            @Override
            public void run() {
                final IZegoEventHandler mEventHandler = eventHandler;
                if (mEventHandler != null) {
                    mEventHandler.onRoomExtraInfoUpdate(roomID, infoArrayList);
                }
            }
        });
    }

    public static void onRoomSetRoomExtraInfoResult(final String roomID, final String key, final int errorCode, final int seq) {
        final Handler uiHandler = mUIHandler;
        if (uiHandler == null) {
            
            return;
        }
        uiHandler.post(new Runnable() {
            @Override
            public void run() {
                synchronized (ZegoExpressEngineInternalImpl.class) {
                    final IZegoRoomSetRoomExtraInfoCallback callback = sRoomSetExtraInfoHandler.get(seq);
                    if (callback != null) {
                        callback.onRoomSetRoomExtraInfoResult(errorCode);
                    }
                    sRoomSetExtraInfoHandler.remove(seq);
                }
            }
        });
    }

    public static void onStreamExtraInfoUpdate(final ZegoStream[] streamList, final int streamInfoCount, final String roomID) {
        //printDebugInfo(ZegoDebugLevel.INFO, ZegoInnerModule.ROOM, "onStreamExtraInfoUpdate", 0);
        final Handler uiHandler = mUIHandler;
        if (uiHandler == null) {
            
            return;
        }
        uiHandler.post(new Runnable() {
            @Override
            public void run() {
                synchronized (ZegoExpressEngineInternalImpl.class) {

                    //eventHandler.onStreamExtraInfoUpdate(streamList, streamInfoCount, roomID);

                }
            }
        });
    }

    public static void onCustomVideoProcessStart(int channel) {
        final Object zegoCustomVideoProcessHandler = mCustomVideoProcessHandler;
        if (zegoCustomVideoProcessHandler != null) {
            // 由于通常开发者会在 onStart 里做 OpenGL 的初始化操作，因此需要保证和处理数据的回调处于同一线程。所以外部滤镜的 start 通知不切线程
            ZegoCallbackHelpers.callCustomVideoProcessOnStartMethod(zegoCustomVideoProcessHandler, ZegoPublishChannel.getZegoPublishChannel(channel));
        }
    }

    public static void onCustomVideoProcessStop(final int channel) {
        final Object zegoCustomVideoProcessHandler = mCustomVideoProcessHandler;
        if (zegoCustomVideoProcessHandler != null) {
            // 由于通常开发者会在 onStart 里做 OpenGL 的销毁操作，因此需要保证和处理数据的回调处于同一线程。所以外部滤镜的 stop 通知不切线程
            ZegoCallbackHelpers.callCustomVideoProcessOnStopMethod(zegoCustomVideoProcessHandler, ZegoPublishChannel.getZegoPublishChannel(channel));
        }
    }

    public static void onCapturedUnprocessedTextureData(int textureID, int width, int height, long referenceTimeMillisecond, int channel){
        final Object zegoCustomVideoProcessHandler = mCustomVideoProcessHandler;
        if(zegoCustomVideoProcessHandler!=null){
            ZegoCallbackHelpers.onCapturedUnprocessedTextureData(mCustomVideoProcessHandler, textureID, width, height, referenceTimeMillisecond, ZegoPublishChannel.values()[channel]);
        }

    }
    public static SurfaceTexture getCustomVideoProcessInputSurfaceTexture(int width, int height,int channel){
        final Object zegoCustomVideoProcessHandler = mCustomVideoProcessHandler;
        SurfaceTexture surfaceTexture=null;
        if(zegoCustomVideoProcessHandler!=null){
            surfaceTexture = ZegoCallbackHelpers.getCustomVideoProcessInputSurfaceTexture(mCustomVideoProcessHandler, width, height, ZegoPublishChannel.values()[channel]);
        }
        return surfaceTexture;
    }
    public static void onProcessRemoteAudioData(ByteBuffer data, int dataLength, ZegoAudioFrameParam param, String streamID) {
        final IZegoCustomAudioProcessHandler zegoCustomAudioProcessHandler = iZegoCustomAudioProcessHandler;
        if (zegoCustomAudioProcessHandler != null) {
            zegoCustomAudioProcessHandler.onProcessRemoteAudioData(data, dataLength, param, streamID);
        }
    }

    public static void onProcessCapturedAudioData(ByteBuffer data, int dataLength, ZegoAudioFrameParam param) {
        final IZegoCustomAudioProcessHandler zegoCustomAudioProcessHandler = iZegoCustomAudioProcessHandler;
        if (zegoCustomAudioProcessHandler != null) {
            zegoCustomAudioProcessHandler.onProcessCapturedAudioData(data, dataLength, param);
        }
    }

    public static void onRoomUserUpdate(final String roomID, final int updateType, final ZegoUser[] userList) {
        // printDebugInfo(ZegoDebugLevel.INFO, ZegoInnerModule.ROOM, "onRoomUserUpdate", 0);
        final ArrayList<ZegoUser> userArrayList = new ArrayList<ZegoUser>();
        for (int i = 0; i < userList.length; i++) {
            userArrayList.add(userList[i]);
        }
        final Handler uiHandler = mUIHandler;
        if (uiHandler == null) {
            
            return;
        }
        uiHandler.post(new Runnable() {
            @Override
            public void run() {
                final IZegoEventHandler mEventHandler = eventHandler;
                if (mEventHandler != null) {
                    mEventHandler.onRoomUserUpdate(roomID, ZegoUpdateType.values()[updateType], userArrayList);

                }
            }
        });

    }

    public static void onPublisherStateUpdate(final String streamID, final int state, final int errorCode, final String extendedData) {
        if (state == ZegoPublisherState.NO_PUBLISH.value() && errorCode != 0) {
            printDebugInfo(ZegoDebugLevel.INFO, ZegoInnerModule.PUBLISHER, "onPublisherStateUpdate", errorCode);
        }
        final Handler uiHandler = mUIHandler;
        if (uiHandler == null) {
            
            return;
        }
        uiHandler.post(new Runnable() {
            @Override
            public void run() {
                final IZegoEventHandler mEventHandler = eventHandler;
                if (mEventHandler != null) {
                    mEventHandler.onPublisherStateUpdate(streamID, ZegoPublisherState.values()[state], errorCode, getJsonObject(extendedData));
                }

            }
        });

    }

    private static JSONObject getJsonObject(String extendedData) {
        try {
            return new JSONObject(extendedData);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return new JSONObject();
    }

    public static void onPublisherUpdateCdnUrlResult(final String streamID, final int errorCode, final int seq) {
        final Handler uiHandler = mUIHandler;
        if (uiHandler == null) {
            
            return;
        }
        uiHandler.post(new Runnable() {
            @Override
            public void run() {
                final IZegoPublisherUpdateCdnUrlCallback handler = sPublisherUpdateCDNURLHandler.get(seq);
                if (handler != null) {
                    handler.onPublisherUpdateCdnUrlResult(errorCode);
                    sPublisherUpdateCDNURLHandler.remove(seq);
                }
            }
        });

    }

    // opt_content_start: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_SIDE_INFO
    public static void onPlayerRecvSEI(final String streamID, final byte[] data, final int dataLength) {
        final Handler uiHandler = mUIHandler;
        if (uiHandler == null) {
            
            return;
        }
        uiHandler.post(new Runnable() {
            @Override
            public void run() {
                final IZegoEventHandler mEventHandler = eventHandler;
                if (mEventHandler != null) {
                    mEventHandler.onPlayerRecvSEI(streamID, data);
                }
            }
        });

    }
    // opt_content_end: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_SIDE_INFO

    public static void onPublisherUpdateStreamExtraInfoResult(final int errorCode, final int seq) {
        final Handler uiHandler = mUIHandler;
        if (uiHandler == null) {
            
            return;
        }
        uiHandler.post(new Runnable() {
            @Override
            public void run() {
                final IZegoPublisherSetStreamExtraInfoCallback handler = sPublisherUpdateStreamExtraInfoHandler.get(seq);
                if (handler != null) {
                    handler.onPublisherSetStreamExtraInfoResult(errorCode);
                    sPublisherUpdateStreamExtraInfoHandler.remove(seq);
                }
            }
        });
    }


    public static void onPublisherQualityUpdate(final String streamID, final ZegoPublishStreamQuality quality) {
        //printDebugInfo(ZegoDebugLevel.INFO, ZegoInnerModule.PUBLISHER, "onPublisherQualityUpdate", 0);
        final Handler uiHandler = mUIHandler;
        if (uiHandler == null) {
            
            return;
        }
        uiHandler.post(new Runnable() {
            @Override
            public void run() {
                final IZegoEventHandler mEventHandler = eventHandler;
                if (mEventHandler != null) {
                    mEventHandler.onPublisherQualityUpdate(streamID, quality);
                }
            }
        });
    }

    public static void onPublisherMediaEvent(final int media_event, final int reason, final String streamID) {
        // printDebugInfo(ZegoDebugLevel.INFO, ZegoInnerModule.PUBLISHER, "onPublisherMediaEvent", 0);
        final Handler uiHandler = mUIHandler;
        if (uiHandler == null) {
            
            return;
        }
        uiHandler.post(new Runnable() {
            @Override
            public void run() {
                final IZegoEventHandler mEventHandler = eventHandler;
                if (mEventHandler != null) {
                    //eventHandler.onPublisherMediaEvent(media_event, reason, streamID);

                }
            }
        });

    }

    public static void onPublisherRecvAudioFirstFrame() {
        // printDebugInfo(ZegoDebugLevel.INFO, ZegoInnerModule.PUBLISHER, "onPublisherCapturedAudioFirstFrame", 0);
        final Handler uiHandler = mUIHandler;
        if (uiHandler == null) {
            
            return;
        }
        uiHandler.post(new Runnable() {
            @Override
            public void run() {
                final IZegoEventHandler mEventHandler = eventHandler;
                if (mEventHandler != null) {
                    mEventHandler.onPublisherCapturedAudioFirstFrame();
                }
            }
        });

    }

    // opt_content_start: audio_or_video = video
    public static void onPublisherRecvVideoFirstFrame(final int zegoPublishChannel) {
        // printDebugInfo(ZegoDebugLevel.INFO, ZegoInnerModule.PUBLISHER, "onPublisherCapturedAudioFirstFrame", 0);
        final Handler uiHandler = mUIHandler;
        if (uiHandler == null) {
            
            return;
        }
        uiHandler.post(new Runnable() {
            @Override
            public void run() {
                final IZegoEventHandler mEventHandler = eventHandler;
                if (mEventHandler != null) {
                    ZegoCallbackHelpers.callOnPublisherCapturedVideoFirstFrameMethod(mEventHandler, ZegoPublishChannel.values()[zegoPublishChannel]);
                }
            }
        });

    }
    // opt_content_end: audio_or_video = video

    // opt_content_start: audio_or_video = video
    public static void onPublisherRenderVideoFirstFrame(final int zegoPublishChannel) {
        final Handler uiHandler = mUIHandler;
        if (uiHandler == null) {
            
            return;
        }
        uiHandler.post(new Runnable() {
            @Override
            public void run() {
                final IZegoEventHandler mEventHandler = eventHandler;
                if (mEventHandler != null) {
                    ZegoCallbackHelpers.callOnPublisherRenderVideoFirstFrameMethod(mEventHandler, ZegoPublishChannel.values()[zegoPublishChannel]);
                }
            }
        });

    }
    // opt_content_end: audio_or_video = video

    // opt_content_start: audio_or_video = video
    public static void onPublisherVideoSizeChanged(final int width, final int height, final int channel) {
        // printDebugInfo(ZegoDebugLevel.INFO, ZegoInnerModule.PUBLISHER, "onPublisherVideoSizeChanged", 0, channel);
        final Handler uiHandler = mUIHandler;
        if (uiHandler == null) {
            
            return;
        }
        uiHandler.post(new Runnable() {
            @Override
            public void run() {
                final IZegoEventHandler mEventHandler = eventHandler;
                if (mEventHandler != null) {
                    ZegoCallbackHelpers.callOnPublisherVideoSizeChangedMethod(mEventHandler, width, height, ZegoPublishChannel.values()[channel]);
                }
            }
        });
    }
    // opt_content_end: audio_or_video = video

    public static void onPublisherRelayCDNStateUpdate(final String streamID, ZegoStreamRelayCDNInfo[] infoList) {
        final ArrayList<ZegoStreamRelayCDNInfo> infoArrayList = new ArrayList<ZegoStreamRelayCDNInfo>();
        for (int i = 0; i < infoList.length; i++) {
            infoArrayList.add(infoList[i]);
        }
        final Handler uiHandler = mUIHandler;

        if (uiHandler == null) {
            
            return;
        }
        uiHandler.post(new Runnable() {
            @Override
            public void run() {
                final IZegoEventHandler mEventHandler = eventHandler;
                if (mEventHandler != null) {
                    mEventHandler.onPublisherRelayCDNStateUpdate(streamID, infoArrayList);
                }
            }
        });
    }


    public static void onPlayerStateUpdate(final String streamID, final int state, final int errorCode, final String extendedData) {
        if (state == ZegoPlayerState.NO_PLAY.value() && errorCode != 0) {
            printDebugInfo(ZegoDebugLevel.INFO, ZegoInnerModule.PLAYER, "onPlayerStateUpdate", errorCode);
        }
        final Handler uiHandler = mUIHandler;
        if (uiHandler == null) {
            
            return;
        }
        uiHandler.post(new Runnable() {
            @Override
            public void run() {
                final IZegoEventHandler mEventHandler = eventHandler;
                if (mEventHandler != null) {
                    eventHandler.onPlayerStateUpdate(streamID, ZegoPlayerState.values()[state], errorCode, getJsonObject(extendedData));
                }
            }
        });
    }

    public static void onPlayerQualityUpdate(final String streamID, final ZegoPlayStreamQuality quality) {
        //printDebugInfo(ZegoDebugLevel.INFO, ZegoInnerModule.PLAYER, "onPlayerQualityUpdate", 0);
        final Handler uiHandler = mUIHandler;
        if (uiHandler == null) {
            
            return;
        }
        uiHandler.post(new Runnable() {
            @Override
            public void run() {
                final IZegoEventHandler mEventHandler = eventHandler;
                if (mEventHandler != null) {
                    mEventHandler.onPlayerQualityUpdate(streamID, quality);
                }
            }
        });
    }

    public static void onPlayerMediaEvent(final String streamID, final int mediaEvent) {
        // printDebugInfo(ZegoDebugLevel.INFO, ZegoInnerModule.PLAYER, "onPlayerMediaEvent", 0);
        final Handler uiHandler = mUIHandler;
        if (uiHandler == null) {
            
            return;
        }
        uiHandler.post(new Runnable() {
            @Override
            public void run() {
                final IZegoEventHandler mEventHandler = eventHandler;
                if (mEventHandler != null) {
                    mEventHandler.onPlayerMediaEvent(streamID, ZegoPlayerMediaEvent.values()[mediaEvent]);
                }
            }
        });
    }

    public static void onPlayerRecvAudioFirstFrame(final String streamID) {
        // printDebugInfo(ZegoDebugLevel.INFO, ZegoInnerModule.PLAYER, "onPlayerRecvAudioFirstFrame", 0);
        final Handler uiHandler = mUIHandler;
        if (uiHandler == null) {
            
            return;
        }
        uiHandler.post(new Runnable() {
            @Override
            public void run() {
                final IZegoEventHandler mEventHandler = eventHandler;
                if (mEventHandler != null) {
                    mEventHandler.onPlayerRecvAudioFirstFrame(streamID);
                }
            }
        });
    }


    // opt_content_start: audio_or_video = video
    public static void onPlayerRecvVideoFirstFrame(final String streamID) {
        // printDebugInfo(ZegoDebugLevel.INFO, ZegoInnerModule.PLAYER, "onPlayerRecvVideoFirstFrame", 0);
        final Handler uiHandler = mUIHandler;
        if (uiHandler == null) {
            
            return;
        }
        uiHandler.post(new Runnable() {
            @Override
            public void run() {
                final IZegoEventHandler mEventHandler = eventHandler;
                if (mEventHandler != null) {
                    ZegoCallbackHelpers.callOnPlayerRecvVideoFirstFrameMethod(mEventHandler, streamID);
                }
            }
        });
    }
    // opt_content_end: audio_or_video = video

    // opt_content_start: audio_or_video = video
    public static void onPlayerRenderVideoFirstFrame(final String streamID) {
        // printDebugInfo(ZegoDebugLevel.INFO, ZegoInnerModule.PLAYER, "onPlayerRecvVideoFirstFrame", 0);
        final Handler uiHandler = mUIHandler;
        if (uiHandler == null) {
            
            return;
        }
        uiHandler.post(new Runnable() {
            @Override
            public void run() {
                final IZegoEventHandler mEventHandler = eventHandler;
                if (mEventHandler != null) {
                    ZegoCallbackHelpers.callOnPlayerRenderVideoFirstFrameMethod(mEventHandler, streamID);
                }
            }
        });
    }
    // opt_content_end: audio_or_video = video

    // opt_content_start: audio_or_video = video
    public static void onPlayerVideoSizeChanged(final String streamID, final int width, final int height) {
        // printDebugInfo(ZegoDebugLevel.INFO, ZegoInnerModule.PLAYER, "onPlayerVideoSizeChanged", 0);
        final Handler uiHandler = mUIHandler;
        if (uiHandler == null) {
            
            return;
        }
        uiHandler.post(new Runnable() {
            @Override
            public void run() {
                final IZegoEventHandler mEventHandler = eventHandler;
                if (mEventHandler != null) {
                    ZegoCallbackHelpers.callOnPlayerVideoSizeChangedMethod(mEventHandler, streamID, width, height);
                }
            }
        });
    }
    // opt_content_end: audio_or_video = video

    public static void onRoomStreamExtraInfoUpdate(final String roomID, ZegoStream[] streamList) {
        // printDebugInfo(ZegoDebugLevel.INFO, ZegoInnerModule.ROOM, "onRoomStreamExtraInfoUpdate", 0);
        final ArrayList<ZegoStream> streamArrayList = new ArrayList<>();
        for (int i = 0; i < streamList.length; i++) {
            streamArrayList.add(streamList[i]);
        }
        final Handler uiHandler = mUIHandler;
        if (uiHandler == null) {
            
            return;
        }
        uiHandler.post(new Runnable() {
            @Override
            public void run() {
                final IZegoEventHandler mEventHandler = eventHandler;
                if (mEventHandler != null) {
                    mEventHandler.onRoomStreamExtraInfoUpdate(roomID, streamArrayList);
                }
            }
        });

    }

    public static void onIMRecvBroadcastMessage(final String roomID, ZegoBroadcastMessageInfo[] messageList) {
        // printDebugInfo(ZegoDebugLevel.INFO, ZegoInnerModule.IM, "onIMRecvBroadcastMessage", 0);
        final ArrayList<ZegoBroadcastMessageInfo> messageArrayList = new ArrayList<>();
        for (int i = 0; i < messageList.length; i++) {
            messageArrayList.add(messageList[i]);
        }
        final Handler uiHandler = mUIHandler;
        if (uiHandler == null) {
            
            return;
        }
        uiHandler.post(new Runnable() {
            @Override
            public void run() {
                final IZegoEventHandler mEventHandler = eventHandler;
                if (mEventHandler != null) {
                    mEventHandler.onIMRecvBroadcastMessage(roomID, messageArrayList);
                }
            }
        });
    }

    public static void onIMRecvCustomCommand(final String roomID, final ZegoUser fromUser, final String command) {
        // printDebugInfo(ZegoDebugLevel.INFO, ZegoInnerModule.IM, "onIMRecvCustomCommand", 0);
        final Handler uiHandler = mUIHandler;
        if (uiHandler == null) {
            
            return;
        }
        uiHandler.post(new Runnable() {
            @Override
            public void run() {
                final IZegoEventHandler mEventHandler = eventHandler;
                if (mEventHandler != null) {
                    mEventHandler.onIMRecvCustomCommand(roomID, fromUser, command);
                }
            }
        });

    }

    public static void onIMSendBroadcastMessageResult(final String roomID, final int errorCode, final int seq, final long messageID) {
        final Handler uiHandler = mUIHandler;
        if (uiHandler == null) {
            
            return;
        }
        uiHandler.post(new Runnable() {
            @Override
            public void run() {
                synchronized (ZegoExpressEngineInternalImpl.class) {
                    final IZegoIMSendBroadcastMessageCallback callback = sIMSendBoradcastMssageHandler.get(seq);
                    if (callback != null) {
                        callback.onIMSendBroadcastMessageResult(errorCode, messageID);
                    }
                    sIMSendBoradcastMssageHandler.remove(seq);
                }
            }
        });
    }


    public static void onIMRecvBarrageMessage(final String roomID, ZegoBarrageMessageInfo[] messageList) {
        // printDebugInfo(ZegoDebugLevel.INFO, ZegoInnerModule.IM, "onIMRecvBarrageMessage", 0);
        final ArrayList<ZegoBarrageMessageInfo> messageArrayList = new ArrayList<>();
        messageArrayList.addAll(Arrays.asList(messageList));
        final Handler uiHandler = mUIHandler;
        if (uiHandler == null) {
            
            return;
        }
        uiHandler.post(new Runnable() {
            @Override
            public void run() {
                final IZegoEventHandler mEventHandler = eventHandler;
                if (mEventHandler != null) {
                    mEventHandler.onIMRecvBarrageMessage(roomID, messageArrayList);
                }
            }
        });
    }

    public static void onIMSendBarrageMessageResult(final int seq, final int errorCode, final String messageID) {
        final Handler uiHandler = mUIHandler;
        if (uiHandler == null) {
            
            return;
        }
        uiHandler.post(new Runnable() {
            @Override
            public void run() {

                final IZegoIMSendBarrageMessageCallback callback = sIMSendBarragetMssageHandler.get(seq);
                if (callback != null) {
                    callback.onIMSendBarrageMessageResult(errorCode, messageID);
                }
                sIMSendBarragetMssageHandler.remove(seq);

            }
        });
    }

    public static void onIMSendCustomCommandResult(final String roomID, final int errorCode, final int seq) {
        final Handler uiHandler = mUIHandler;
        if (uiHandler == null) {
            
            return;
        }
        uiHandler.post(new Runnable() {
            @Override
            public void run() {
                final IZegoIMSendCustomCommandCallback callback = sIMSendCustomCommandHandler.get(seq);
                if (callback != null) {
                    callback.onIMSendCustomCommandResult(errorCode);
                }
                sIMSendCustomCommandHandler.remove(seq);
            }
        });
    }

    public static void onRemoteCameraStateUpdate(final String streamID, final int state) {
        final Handler uiHandler = mUIHandler;
        if (uiHandler == null) {
            
            return;
        }
        uiHandler.post(new Runnable() {
            @Override
            public void run() {
                final IZegoEventHandler mEventHandler = eventHandler;
                if (mEventHandler != null) {
                    ZegoCallbackHelpers.callOnRemoteCameraStateUpdateMethod(mEventHandler, streamID, ZegoRemoteDeviceState.values()[state]);

                }
            }
        });
    }

    public static void onRemoteMICStateUpdate(final String streamID, final int state) {
        final Handler uiHandler = mUIHandler;
        if (uiHandler == null) {
            
            return;
        }
        uiHandler.post(new Runnable() {
            @Override
            public void run() {
                final IZegoEventHandler mEventHandler = eventHandler;
                if (mEventHandler != null) {
                    eventHandler.onRemoteMicStateUpdate(streamID, ZegoRemoteDeviceState.values()[state]);
                }
            }
        });
    }


    public static void onEngineStateUpdate(final int zegoEngineState) {
        final Handler uiHandler = mUIHandler;
        if (uiHandler == null) {
            
            return;
        }
        uiHandler.post(new Runnable() {
            @Override
            public void run() {
                final IZegoEventHandler mEventHandler = eventHandler;
                if (mEventHandler != null) {
                    eventHandler.onEngineStateUpdate(ZegoEngineState.getZegoEngineState(zegoEngineState));
                }
            }
        });
    }


    public static void onEngineUninitUpdate() {
        final IZegoDestroyCompletionCallback mIZegoDestroyCompletionCallback = iZegoDestroyCompletionCallback;
        if (mIZegoDestroyCompletionCallback != null) {
            mIZegoDestroyCompletionCallback.onDestroyCompletion();
            iZegoDestroyCompletionCallback = null;
        }
    }

    public static void onDeviceError(final int errorCode, final String deviceName) {
        // printDebugInfo(ZegoDebugLevel.INFO, ZegoInnerModule.DEVICE, "onDeviceError", 0);
        final Handler uiHandler = mUIHandler;
        if (uiHandler == null) {
            
            return;
        }
        uiHandler.post(new Runnable() {
            @Override
            public void run() {
                final IZegoEventHandler mEventHandler = eventHandler;
                if (mEventHandler != null) {
                    mEventHandler.onDeviceError(errorCode, deviceName);
                }
            }
        });
    }

    public static void onAudioRouteChange(final int audioRoute) {
        final Handler uiHandler = mUIHandler;
        if (uiHandler == null) {
            
            return;
        }
        uiHandler.post(new Runnable() {
            @Override
            public void run() {
                final IZegoEventHandler mEventHandler = eventHandler;
                if (mEventHandler != null) {
                    mEventHandler.onAudioRouteChange(ZegoAudioRoute.values()[audioRoute]);
                }
            }
        });
    }

    public static void onMixerSoundLevelUpdate(final HashMap<Integer, Float> soundLevelHashMap) {
        final Handler uiHandler = mUIHandler;
        if (uiHandler == null) {
            
            return;
        }
        uiHandler.post(new Runnable() {
            @Override
            public void run() {
                final IZegoEventHandler mEventHandler = eventHandler;
                if (mEventHandler != null) {
                    mEventHandler.onMixerSoundLevelUpdate(soundLevelHashMap);
                }
            }
        });
    }

    public static void onPlayerSoundLevelUpdate(final HashMap<String, Float> soundLevelHashMap) {

        final Handler uiHandler = mUIHandler;
        if (uiHandler == null) {
            
            return;
        }
        uiHandler.post(new Runnable() {
            @Override
            public void run() {
                final IZegoEventHandler mEventHandler = eventHandler;
                if (mEventHandler != null) {
                    mEventHandler.onRemoteSoundLevelUpdate(soundLevelHashMap);
                }
            }
        });
    }

    public static void onCapturedSoundLevelUpdate(final float soundLevel) {

        final Handler uiHandler = mUIHandler;
        if (uiHandler == null) {
            
            return;
        }
        uiHandler.post(new Runnable() {
            @Override
            public void run() {
                final IZegoEventHandler mEventHandler = eventHandler;
                if (mEventHandler != null) {
                    mEventHandler.onCapturedSoundLevelUpdate(soundLevel);
                }
            }
        });
    }

    public static void onCapturedFrequencySpectrumUpdate(final float[] frequencySpectrum) {
        // printDebugInfo(ZegoDebugLevel.INFO, ZegoInnerModule.DEVICE, "onCapturedFrequencySpectrumUpdate", 0);
        final Handler uiHandler = mUIHandler;
        if (uiHandler == null) {
            
            return;
        }
        uiHandler.post(new Runnable() {
            @Override
            public void run() {
                final IZegoEventHandler mEventHandler = eventHandler;
                if (mEventHandler != null) {
                    mEventHandler.onCapturedAudioSpectrumUpdate(frequencySpectrum);
                }
            }
        });

    }

    public static void onPlayerFrequencySpectrumUpdate(final HashMap<String, float[]> frequencySpectrums) {
        // printDebugInfo(ZegoDebugLevel.INFO, ZegoInnerModule.DEVICE, "onPlayerFrequencySpectrumUpdate", 0);
        final Handler uiHandler = mUIHandler;
        if (uiHandler == null) {
            
            return;
        }
        uiHandler.post(new Runnable() {
            @Override
            public void run() {
                final IZegoEventHandler mEventHandler = eventHandler;
                if (mEventHandler != null) {
                    mEventHandler.onRemoteAudioSpectrumUpdate(frequencySpectrums);
                }
            }
        });

    }

    public static void onMixerStartResult(final int seq, final int errorCode, final String extendedData) {
        //todo 混流不走通用事件通知
        final Handler uiHandler = mUIHandler;
        if (uiHandler == null) {
            
            return;
        }
        uiHandler.post(new Runnable() {
            @Override
            public void run() {
                final IZegoMixerStartCallback callback = sMixerStartResultHandler.get(seq);
                if (callback != null) {
                    callback.onMixerStartResult(errorCode, getJsonObject(extendedData));
                }
                sMixerStartResultHandler.remove(seq);
            }
        });
    }

    public static void onMixerStopResult(final int seq, final int errorCode) {
        //todo 混流不走通用事件通知
        final Handler uiHandler = mUIHandler;
        if (uiHandler == null) {
            
            return;
        }
        uiHandler.post(new Runnable() {
            @Override
            public void run() {
                final IZegoMixerStopCallback callback = sMixerStopResultHandler.get(seq);
                if (callback != null) {
                    callback.onMixerStopResult(errorCode);
                }
                sMixerStartResultHandler.remove(seq);

            }
        });

    }

    public static void onRoomOnlineUserCountUpdate(final String roomID, final int count) {
        final Handler uiHandler = mUIHandler;
        if (uiHandler == null) {
            
            return;
        }
        uiHandler.post(new Runnable() {
            @Override
            public void run() {
                final IZegoEventHandler mEventHandler = eventHandler;
                if (mEventHandler != null) {
                    mEventHandler.onRoomOnlineUserCountUpdate(roomID, count);
                }
            }
        });
    }


    public static void onMixerRelayCDNStateUpdate(final ZegoStreamRelayCDNInfo[] infoList, final String taskID) {
        final ArrayList<ZegoStreamRelayCDNInfo> infoArrayList = new ArrayList<ZegoStreamRelayCDNInfo>();
        for (int i = 0; i < infoList.length; i++) {
            infoArrayList.add(infoList[i]);
        }

        final Handler uiHandler = mUIHandler;
        if (uiHandler == null) {
            
            return;
        }
        uiHandler.post(new Runnable() {
            @Override
            public void run() {
                final IZegoEventHandler mEventHandler = eventHandler;
                if (mEventHandler != null) {
                    mEventHandler.onMixerRelayCDNStateUpdate(taskID, infoArrayList);
                }
            }
        });
    }

    public static void onCapturedAudioData(ByteBuffer data, int dataLength, int sampleRate, int channel) {

        final IZegoAudioDataHandler handler = iZegoAudioDataHandler;
        if (handler != null) {
            ZegoAudioFrameParam zegoCaptureAudioFrameParam = new ZegoAudioFrameParam();
            zegoCaptureAudioFrameParam.sampleRate = ZegoAudioSampleRate.getZegoAudioSampleRate(sampleRate);
            zegoCaptureAudioFrameParam.channel = ZegoAudioChannel.getZegoAudioChannel(channel);
            handler.onCapturedAudioData(data, dataLength, zegoCaptureAudioFrameParam);
        }
    }
    public static void onPlayerAudioData(ByteBuffer data, int dataLength,String streamID,int sampleRate, int channel) {
        final IZegoAudioDataHandler handler = iZegoAudioDataHandler;
        if (handler != null) {
            ZegoAudioFrameParam zegoCaptureAudioFrameParam = new ZegoAudioFrameParam();
            zegoCaptureAudioFrameParam.sampleRate = ZegoAudioSampleRate.getZegoAudioSampleRate(sampleRate);
            zegoCaptureAudioFrameParam.channel = ZegoAudioChannel.getZegoAudioChannel(channel);
            handler.onPlayerAudioData(data, dataLength,zegoCaptureAudioFrameParam,streamID);
        }
    }

  

    public static void onPlaybackAudioData(ByteBuffer data, int dataLength, int sampleRate, int channel) {
        final IZegoAudioDataHandler handler = iZegoAudioDataHandler;
        if (handler != null) {
            ZegoAudioFrameParam zegoPlaybackAudioFrameParam = new ZegoAudioFrameParam();
            zegoPlaybackAudioFrameParam.sampleRate = ZegoAudioSampleRate.getZegoAudioSampleRate(sampleRate);
            zegoPlaybackAudioFrameParam.channel = ZegoAudioChannel.getZegoAudioChannel(channel);
            handler.onPlaybackAudioData(data, dataLength, zegoPlaybackAudioFrameParam);
        }
    }


    public static void onMixedAudioData(ByteBuffer data, int dataLength, int sampleRate, int channel) {
        final IZegoAudioDataHandler handler = iZegoAudioDataHandler;
        if (handler != null) {
            ZegoAudioFrameParam zegoMixedAudioFrameParam = new ZegoAudioFrameParam();
            zegoMixedAudioFrameParam.sampleRate = ZegoAudioSampleRate.getZegoAudioSampleRate(sampleRate);
            zegoMixedAudioFrameParam.channel = ZegoAudioChannel.getZegoAudioChannel(channel);
            handler.onMixedAudioData(data, dataLength, zegoMixedAudioFrameParam);
        }
    }


    public static void onRemoteVideoFrameEncodedData(ByteBuffer buffers, int dataLen, int format, boolean isKeyFrame, int width, int height, ByteBuffer SEIData, int SEIDataLength, long referenceTimeMillisecond, String streamID) {
        final Object iZegoCustomVideoRenderHandler = mCustomVideoRenderHandler;
        if (iZegoCustomVideoRenderHandler != null) {
            ZegoVideoEncodedFrameParam param = new ZegoVideoEncodedFrameParam();
            param.isKeyFrame = isKeyFrame;
            param.format = ZegoVideoEncodedFrameFormat.getZegoVideoEncodedFrameFormat(format);
            param.width = width;
            param.height = height;
            param.SEIData = SEIData;
            param.SEIDataLength = SEIDataLength;
            ZegoCallbackHelpers.callCustomVideoRenderOnRemoteVideoFrameEncodedDataMethod(iZegoCustomVideoRenderHandler, buffers, dataLen, param, referenceTimeMillisecond, streamID);
        }
    }

    public static void onCapturedDataRecordStateUpdate(final int state, final int errorCode, final String filePath, final int recordType, final int channel) {
        final Handler uiHandler = mUIHandler;
        if (uiHandler == null) {
            
            return;
        }

        uiHandler.post(new Runnable() {
            @Override
            public void run() {
                final IZegoDataRecordEventHandler handler = iZegoDataRecordEventHandler;
                if (handler != null) {
                    ZegoDataRecordConfig zegoDataRecordConfig = new ZegoDataRecordConfig();
                    zegoDataRecordConfig.filePath = filePath;
                    zegoDataRecordConfig.recordType = ZegoDataRecordType.getZegoDataRecordType(recordType);
                    handler.onCapturedDataRecordStateUpdate(ZegoDataRecordState.getZegoDataRecordState(state), errorCode, zegoDataRecordConfig, ZegoPublishChannel.getZegoPublishChannel(channel));
                }
            }
        });
    }

    public static void onCapturedDataRecordProgressUpdate(final long duration, final long currentFileSize, final String filePath, final int recordType, final int channel) {
        final Handler uiHandler = mUIHandler;
        if (uiHandler == null) {
            
            return;
        }

        uiHandler.post(new Runnable() {
            @Override
            public void run() {
                final IZegoDataRecordEventHandler handler = iZegoDataRecordEventHandler;
                if (handler != null) {
                    ZegoDataRecordProgress zegoDataRecordProgress = new ZegoDataRecordProgress();
                    zegoDataRecordProgress.currentFileSize = currentFileSize;
                    zegoDataRecordProgress.duration = duration;
                    ZegoDataRecordConfig zegoDataRecordConfig = new ZegoDataRecordConfig();
                    zegoDataRecordConfig.filePath = filePath;
                    zegoDataRecordConfig.recordType = ZegoDataRecordType.getZegoDataRecordType(recordType);
                    handler.onCapturedDataRecordProgressUpdate(zegoDataRecordProgress, zegoDataRecordConfig, ZegoPublishChannel.getZegoPublishChannel(channel));
                }
            }
        });
    }

    // opt_content_start: audio_or_video = video ; sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_EXTERNAL_VIDEO_RENDER
    public static void onCustomVideoRenderCapturedFrameData(ByteBuffer[] buffers, int[] dataLen, int[] strides, int width, int height, int videoPixelFormat, int videoFlipMode, int channel) {
        final Object iZegoCustomVideoRenderHandler = mCustomVideoRenderHandler;
        if (iZegoCustomVideoRenderHandler != null) {
            ZegoVideoFrameParam zegoVideoFrameParam = new ZegoVideoFrameParam();
            for (int i = 0; i < strides.length; i++) {
                zegoVideoFrameParam.strides[i] = strides[i];
            }
            zegoVideoFrameParam.format = ZegoVideoFrameFormat.values()[videoPixelFormat];
            zegoVideoFrameParam.width = width;
            zegoVideoFrameParam.height = height;

            ZegoCallbackHelpers.callCustomVideoRenderOnCapturedVideoFrameRawDataMethod(iZegoCustomVideoRenderHandler, buffers, dataLen, zegoVideoFrameParam, ZegoVideoFlipMode.values()[videoFlipMode], ZegoPublishChannel.values()[channel]);
        }
    }
    // opt_content_end: audio_or_video = video ; sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_EXTERNAL_VIDEO_RENDER

    // opt_content_start: audio_or_video = video ; sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_EXTERNAL_VIDEO_RENDER
    public static void onCustomVideoRenderRemoteFrameData(ByteBuffer[] buffers, int[] dataLen, int[] strides, int width, int height, int videoPixelFormat, String streamID) {
        final Object iZegoCustomVideoRenderHandler = mCustomVideoRenderHandler;
        if (iZegoCustomVideoRenderHandler != null) {
            ZegoVideoFrameParam zegoVideoFrameParam = new ZegoVideoFrameParam();
            for (int i = 0; i < strides.length; i++) {
                zegoVideoFrameParam.strides[i] = strides[i];
            }
            zegoVideoFrameParam.format = ZegoVideoFrameFormat.values()[videoPixelFormat];
            zegoVideoFrameParam.width = width;
            zegoVideoFrameParam.height = height;
            ZegoCallbackHelpers.callCustomVideoRenderOnCustomVideoRenderRemoteFrameDataMethod(iZegoCustomVideoRenderHandler, buffers, dataLen, zegoVideoFrameParam, streamID);
        }
    }
    // opt_content_end: audio_or_video = video ; sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_EXTERNAL_VIDEO_RENDER


    public static void onEncodedDataTrafficControl(final int width, final int height, final int fps, final int bitrate, final int channel){
        final Handler handler = mUIHandler;
        if (handler == null) {
            return;
        }
        handler.post(new Runnable() {
            @Override
            public void run() {
                final Object customVideoCaptureHandler = mCustomVideoCaptureHandler;
                if (customVideoCaptureHandler != null) {
                    // 经讨论，外部采集的通知不切线程
                    ZegoCallbackHelpers.callCustomVideoCaptureOnEncodedDataTrafficControlMethod(customVideoCaptureHandler, width, height, fps, bitrate, ZegoPublishChannel.getZegoPublishChannel(channel));
                    isCustomVideoCapturing = true;

                } else {
                    
                }
            }
        });

    }
    public static void onPublisherTakeSnapshotResult(final int channel, final int errorCode, final Bitmap bitmap) {
        final Handler uiHandler = mUIHandler;
        if (uiHandler == null) {
            
            return;
        }
        uiHandler.post(new Runnable() {
            @Override
            public void run() {
                final IZegoPublisherTakeSnapshotCallback handler = sPublisherTakeSnapshotResultHandler.get(channel);
                if (handler != null) {
                    handler.onPublisherTakeSnapshotResult(errorCode,bitmap);
                    sPublisherTakeSnapshotResultHandler.remove(channel);
                }
            }
        });

    }
    public static void onPlayerTakeSnapshotResult(final String streamId,final int errorCode,final Bitmap bitmap){
        final Handler uiHandler = mUIHandler;
        if (uiHandler == null) {
            
            return;
        }
        uiHandler.post(new Runnable() {
            @Override
            public void run() {
                final IZegoPlayerTakeSnapshotCallback handler = sPlayerTakeSnapshotResultHandler.get(streamId);
                if (handler != null) {
                    handler.onPlayerTakeSnapshotResult(errorCode,bitmap);
                    sPlayerTakeSnapshotResultHandler.remove(streamId);
                }
            }
        });
    }

    public static void onPerformanceStatusUpdate(final ZegoPerformanceStatus status){
        final Handler uiHandler = mUIHandler;
        if (uiHandler == null) {
            
            return;
        }
        uiHandler.post(new Runnable() {
            @Override
            public void run() {
                final IZegoEventHandler mEventHandler = eventHandler;
                if (mEventHandler != null) {
                    mEventHandler.onPerformanceStatusUpdate(status);
                }
            }
        });
    }

    public static void onNetworkModeChanged(final int mode){
        final Handler uiHandler = mUIHandler;
        if (uiHandler == null) {
            
            return;
        }
        uiHandler.post(new Runnable() {
            @Override
            public void run() {
                final IZegoEventHandler mEventHandler = eventHandler;
                if (mEventHandler != null) {
                    mEventHandler.onNetworkModeChanged(ZegoNetworkMode.values()[mode]);
                }
            }
        });
    }

    public static void onTestNetworkConnectivityCallback(final int seq, final int errorCode, final ZegoTestNetworkConnectivityResult result){
        final Handler uiHandler = mUIHandler;
        if (uiHandler == null) {
            
            return;
        }
        uiHandler.post(new Runnable() {
            @Override
            public void run() {
                final IZegoTestNetworkConnectivityCallback handler = sTestNetworkConnectivityHandler.get(seq);
                if (handler != null) {
                    handler.onTestNetworkConnectivityCallback(errorCode,result);
                    sTestNetworkConnectivityHandler.remove(seq);
                }
            }
        });
    }

    public static void onNetworkSpeedTestError(final int error_code, final int type){
        final Handler uiHandler = mUIHandler;
        if (uiHandler == null) {
            
            return;
        }
        uiHandler.post(new Runnable() {
            @Override
            public void run() {
                final IZegoEventHandler mEventHandler = eventHandler;
                if (mEventHandler != null) {
                    mEventHandler.onNetworkSpeedTestError(error_code,ZegoNetworkSpeedTestType.values()[type]);
                }
            }
        });
    }
    
    public static void onNetworkSpeedTestQualityUpdate(final ZegoNetworkSpeedTestQuality quality, final int type){
        final Handler uiHandler = mUIHandler;
        if (uiHandler == null) {
            
            return;
        }
        uiHandler.post(new Runnable() {
            @Override
            public void run() {
                final IZegoEventHandler mEventHandler = eventHandler;
                if (mEventHandler != null) {
                    mEventHandler.onNetworkSpeedTestQualityUpdate(quality,ZegoNetworkSpeedTestType.values()[type]);
                }
            }
        });
    }

    public static void onNetworkProbeResultCallback(final int seq, final int errorCode, final ZegoNetworkProbeResult result){
        final Handler uiHandler = mUIHandler;
        if (uiHandler == null) {
            
            return;
        }
        uiHandler.post(new Runnable() {
            @Override
            public void run() {
                final IZegoNetworkProbeResultCallback handler = sNetworkProbeResultHandler.get(seq);
                if (handler != null) {
                    handler.onNetworkProbeResult(errorCode,result);
                    sNetworkProbeResultHandler.remove(seq);
                }
            }
        });
    }

    public static void onUploadLogResultCallback(final int seq, final int errorCode){
        final Handler uiHandler = mUIHandler;
        if (uiHandler == null) {
            
            return;
        }
        uiHandler.post(new Runnable() {
            @Override
            public void run() {
                final IZegoUploadLogResultCallback handler = sUploadLogResultHandler.get(seq);
                if (handler != null) {
                    handler.onUploadLogResult(errorCode);
                    sUploadLogResultHandler.remove(seq);
                }
            }
        });
    }
}
