package im.zego.zegoexpress.entity;

import im.zego.zegoexpress.constants.*;
import im.zego.zegoexpress.callback.*;
import im.zego.zegoexpress.entity.*;
import java.nio.*;
import java.util.*;
import org.json.*;
import im.zego.zegoexpress.*;
import im.zego.zegoexpress.internal.*;
import android.app.Application;
import android.graphics.*;

/**
 * Mix stream task object.
 *
 * This class is the configuration class of the stream mixing task. When a stream mixing task is requested to the ZEGO RTC server, the configuration of the stream mixing task is required.
 * This class describes the detailed configuration information of this stream mixing task.
 */
public class ZegoMixerTask {

    /** Mix stream task ID */
    private String taskID;

    /** Mix stream audio config */
    private ZegoMixerAudioConfig audioConfig;

    /** Mix stream audio config */
    private ZegoMixerVideoConfig videoConfig;

    /** Mix stream task input list */
    private ArrayList<ZegoMixerInput> inputList;

    /** Mix stream task output list */
    private ArrayList<ZegoMixerOutput> outputList;

    /** Mix stream wate rmark */
    private ZegoWatermark watermark;

    /** Mix stream background image URL */
    private String backgroundImageURL;

    /** Enable or disable sound level callback for the task. If enabled, then the remote player can get the soundLevel of every stream in the inputlist by [onMixerSoundLevelUpdate] callback. */
    private boolean soundLevel;

    /** Set advanced configuration, such as specifying video encoding and others. If you need to use it, contact ZEGO technical support. */
    private HashMap<String, String> advancedConfig;

    /**
     * Create a mix stream task object with TaskID
     */
    public ZegoMixerTask(String taskID){
        this.taskID = taskID;
        inputList = new ArrayList<>();
        outputList = new ArrayList<>();
        audioConfig = new ZegoMixerAudioConfig();
        videoConfig = new ZegoMixerVideoConfig();
        backgroundImageURL = "";
        advancedConfig = new HashMap<>();
    }

    /**
     * Get current TaskID
     */
    public String getTaskID(){
        return taskID;
    }

    /**
     * Set the input stream list for the mix stream task object
     */
    public void setInputList(ArrayList<ZegoMixerInput> inputList){
        this.inputList = inputList;
    }

    /**
     * Set the output list of the mix stream task object
     */
    public void setOutputList(ArrayList<ZegoMixerOutput> outputList){
        this.outputList = outputList;
    }

    /**
     * Set the audio configuration of the mix stream task object
     */
    public void setAudioConfig(ZegoMixerAudioConfig config){
        this.audioConfig = config;
    }

    /**
     * Set the video configuration of the mix stream task object
     */
    public void setVideoConfig(ZegoMixerVideoConfig config){
        this.videoConfig = config;
    }

    /**
     * Set the background image of the mix stream task object
     */
    public void setBackgroundImageURL(String backgroundImageURL){
        this.backgroundImageURL = backgroundImageURL;
    }

    /**
     * Set the watermark of the mix stream task object
     */
    public void setWatermark(ZegoWatermark watermark){
        this.watermark = watermark;
    }

    /**
     * Enable or disable sound level callback for the task. If enabled, then the remote player can get the soundLevel of every stream in the inputlist by [onMixerSoundLevelUpdate] callback.
     */
    public void enableSoundLevel(boolean enable){
        this.soundLevel = enable;
    }

    /**
     * Set advanced configuration, such as specifying video encoding and others. If you need to use it, contact ZEGO technical support.
     */
    public void setAdvancedConfig(HashMap<String, String> advancedConfig){
        this.advancedConfig = advancedConfig;
    }

}
