package im.zego.zegoexpress.internal;

import android.os.Handler;
import android.os.Looper;

import im.zego.zegoexpress.ZegoMediaPlayer;
import im.zego.zegoexpress.callback.IZegoMediaPlayerTakeSnapshotCallback;
import im.zego.zegoexpress.callback.IZegoMediaPlayerVideoHandler;
import im.zego.zegoexpress.constants.ZegoMediaPlayerAudioChannel;
import im.zego.zegoexpress.constants.ZegoMediaPlayerState;
import im.zego.zegoexpress.constants.ZegoVideoFrameFormat;
import im.zego.zegoexpress.entity.ZegoAccurateSeekConfig;
import im.zego.zegoexpress.entity.ZegoCanvas;
import im.zego.zegoexpress.callback.IZegoMediaPlayerAudioHandler;
import im.zego.zegoexpress.callback.IZegoMediaPlayerEventHandler;
import im.zego.zegoexpress.callback.IZegoMediaPlayerLoadResourceCallback;
import im.zego.zegoexpress.callback.IZegoMediaPlayerSeekToCallback;
import im.zego.zegoexpress.entity.ZegoVoiceChangerParam;
import im.zego.zegoexpress.utils.ZegoDebugLevel;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class ZegoMediaPlayerInternalImpl extends ZegoMediaPlayer{

    public static Handler mUIHandler = new Handler(Looper.getMainLooper());




    /* 在 ZegoMediaplayerJni 里同时管理对于JNI的调用回调与 Mediaplayer 多实例的管理*/

    static class IdxAndHandler {
        int kMediaPlayerIdx;
        ConcurrentHashMap<Integer, IZegoMediaPlayerSeekToCallback> seekToTimeCallbackHashMap;
        Object mediaPlayerTakeSnapshotCallback;
        IZegoMediaPlayerLoadResourceCallback loadResourceCallback;
        IZegoMediaPlayerEventHandler eventHandler;
        IZegoMediaPlayerAudioHandler audioHandler;
        Object videoHandler;

        IdxAndHandler(int idx) {
            this.kMediaPlayerIdx = idx;
        }
    }

    public static ConcurrentHashMap<ZegoMediaPlayer, IdxAndHandler> mediaplayerToIdxAndEventhandler = new ConcurrentHashMap<ZegoMediaPlayer, IdxAndHandler>();

    // opt_content_start: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER
    public void setEventHandler(IZegoMediaPlayerEventHandler handler) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            idxAndHandler.eventHandler = handler;
        }
    }


    // opt_content_end: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER


    // opt_content_start: audio_or_video = video; sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER
    public void setVideoHandler(IZegoMediaPlayerVideoHandler handler, ZegoVideoFrameFormat frameFormat) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            idxAndHandler.videoHandler = handler;
            if (handler == null) {
                ZegoMediaPlayerJniAPI.enableVideoDataJni(frameFormat.value(), false, idxAndHandler.kMediaPlayerIdx);
            } else {
                ZegoMediaPlayerJniAPI.enableVideoDataJni(frameFormat.value(), true, idxAndHandler.kMediaPlayerIdx);
            }
        }
    }
    // opt_content_end: audio_or_video = video; sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER


    // opt_content_start: audio_or_video = audio; sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER
    public void setAudioHandler(IZegoMediaPlayerAudioHandler handler) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            idxAndHandler.audioHandler = handler;
            if (handler == null) {
                ZegoMediaPlayerJniAPI.enableAudioDataJni(false, idxAndHandler.kMediaPlayerIdx);
            } else {
                ZegoMediaPlayerJniAPI.enableAudioDataJni(true, idxAndHandler.kMediaPlayerIdx);
            }
        }
    }
    // opt_content_end: audio_or_video = audio; sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER

    // opt_content_start: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER
    public void loadResource(String path, IZegoMediaPlayerLoadResourceCallback callback) {
        final IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            int errorCode = ZegoMediaPlayerJniAPI.loadResourceJni(idxAndHandler.kMediaPlayerIdx, path);
            idxAndHandler.loadResourceCallback = callback;
            ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                    ZegoExpressEngineInternalImpl.ZegoInnerModule.MEDIAPLAYER, "MediaPlayer loadResource", errorCode);
        }
    }
    // opt_content_end: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER

    // opt_content_start: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER
    public int getIndex() {
        final IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            ZegoExpressEngineInternalImpl.printDebugInfo( ZegoDebugLevel.INFO,
                    ZegoExpressEngineInternalImpl.ZegoInnerModule.MEDIAPLAYER, "MediaPlayer getIndex", 0);
            return idxAndHandler.kMediaPlayerIdx;
        }
        return 0;
    }
    // opt_content_end: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER


    // opt_content_start: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER
    public void start() {
        final IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            int errorCode = ZegoMediaPlayerJniAPI.startJni(idxAndHandler.kMediaPlayerIdx);
            ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                    ZegoExpressEngineInternalImpl.ZegoInnerModule.MEDIAPLAYER, "MediaPlayer start", errorCode);
        }
    }
    // opt_content_end: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER

    // opt_content_start: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER
    public void stop() {
        final IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            int errorCode = ZegoMediaPlayerJniAPI.stopJni(idxAndHandler.kMediaPlayerIdx);
            ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                    ZegoExpressEngineInternalImpl.ZegoInnerModule.MEDIAPLAYER, "MediaPlayer stop", errorCode);

        }
    }
    // opt_content_end: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER

    // opt_content_start: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER
    public void pause() {
        final IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            int errorCode = ZegoMediaPlayerJniAPI.pauseJni(idxAndHandler.kMediaPlayerIdx);
            ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                    ZegoExpressEngineInternalImpl.ZegoInnerModule.MEDIAPLAYER, "MediaPlayer pause", errorCode);

        }
    }
    // opt_content_end: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER

    // opt_content_start: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER
    public void resume() {
        final IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            int errorCode = ZegoMediaPlayerJniAPI.resumeJni(idxAndHandler.kMediaPlayerIdx);
            ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                    ZegoExpressEngineInternalImpl.ZegoInnerModule.MEDIAPLAYER, "MediaPlayer resume", errorCode);

        }
    }
    // opt_content_end: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER

    // opt_content_start: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER
    public void seekTo(long millisecond, IZegoMediaPlayerSeekToCallback callback) {
        final IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            int seq = ZegoMediaPlayerJniAPI.seekToJni(idxAndHandler.kMediaPlayerIdx, millisecond);
            idxAndHandler.seekToTimeCallbackHashMap.put(seq, callback);
            ZegoExpressEngineInternalImpl.printDebugInfo(ZegoDebugLevel.INFO,
                    ZegoExpressEngineInternalImpl.ZegoInnerModule.MEDIAPLAYER, "MediaPlayer seekTo", 0);

        }
    }
    // opt_content_end: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER


    // opt_content_start: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER
    public void enableRepeat(boolean enable) {
        final IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
           int errorCode = ZegoMediaPlayerJniAPI.enableRepeatJni(idxAndHandler.kMediaPlayerIdx, enable);
            ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                    ZegoExpressEngineInternalImpl.ZegoInnerModule.MEDIAPLAYER, "MediaPlayer enableRepeat", errorCode);
        }
    }
    // opt_content_end: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER

    // opt_content_start: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER
    public void enableAux(boolean enable) {
        final IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            int errorCode = ZegoMediaPlayerJniAPI.enableAuxJni(idxAndHandler.kMediaPlayerIdx, enable);
            ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                    ZegoExpressEngineInternalImpl.ZegoInnerModule.MEDIAPLAYER, "MediaPlayer enableAux", errorCode);
        }
    }
    // opt_content_end: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER

    // opt_content_start: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER
    public void muteLocal(boolean mute) {
        final IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            int errorCode = ZegoMediaPlayerJniAPI.muteLocalJni(idxAndHandler.kMediaPlayerIdx, mute);
            ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                    ZegoExpressEngineInternalImpl.ZegoInnerModule.MEDIAPLAYER, "MediaPlayer muteLocal", errorCode);

        }
    }
    // opt_content_end: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER

    // opt_content_start: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER
    public void setPlayerCanvas(ZegoCanvas canvas) {
        final IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            int errorCode =0;
            if (canvas != null) {
                errorCode = ZegoMediaPlayerJniAPI.setPlayerCanvasJni(idxAndHandler.kMediaPlayerIdx, canvas.view, canvas.viewMode.value(), canvas.backgroundColor);
            } else {
                errorCode = ZegoMediaPlayerJniAPI.setPlayerCanvasJni(idxAndHandler.kMediaPlayerIdx, null, 0, 0);

            }
            ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                    ZegoExpressEngineInternalImpl.ZegoInnerModule.MEDIAPLAYER, "MediaPlayer setPlayerCanvas", errorCode);
        }
    }
    // opt_content_end: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER

    // opt_content_start: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER
    public void setVolume(int volume) {
        final IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            int errorCode = ZegoMediaPlayerJniAPI.setVolumeJni(idxAndHandler.kMediaPlayerIdx, volume);
            ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                    ZegoExpressEngineInternalImpl.ZegoInnerModule.MEDIAPLAYER, "MediaPlayer setVolume", errorCode);

        }
    }
    // opt_content_end: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER

    // opt_content_start: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER
    public void setProgressInterval(long millisecond) {
        final IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            int errorCode = ZegoMediaPlayerJniAPI.setProgressIntervalJni(idxAndHandler.kMediaPlayerIdx, millisecond);
            ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                    ZegoExpressEngineInternalImpl.ZegoInnerModule.MEDIAPLAYER, "MediaPlayer setProgressInterval", errorCode);
        }
    }

    @Override
    public void setPlayVolume(int volume) {
        final IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            int errorCode = ZegoMediaPlayerJniAPI.setPlayVolumeJni(idxAndHandler.kMediaPlayerIdx, volume);
            ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                    ZegoExpressEngineInternalImpl.ZegoInnerModule.MEDIAPLAYER, "MediaPlayer setPlayVolume", errorCode);
        }
    }

    @Override
    public void setPublishVolume(int volume) {
        final IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            int errorCode = ZegoMediaPlayerJniAPI.setPublishVolumeJni(idxAndHandler.kMediaPlayerIdx, volume);
            ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                    ZegoExpressEngineInternalImpl.ZegoInnerModule.MEDIAPLAYER, "MediaPlayer setPublishVolume", errorCode);
        }
    }

    @Override
    public int getPlayVolume() {
        final IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            ZegoExpressEngineInternalImpl.printDebugInfo(ZegoDebugLevel.INFO,
                    ZegoExpressEngineInternalImpl.ZegoInnerModule.MEDIAPLAYER, "MediaPlayer getPlayVolume", 0);
            return ZegoMediaPlayerJniAPI.getPlayVolumeJni(idxAndHandler.kMediaPlayerIdx);
        }
        return 0;
    }

    @Override
    public int getPublishVolume() {
        final IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            ZegoExpressEngineInternalImpl.printDebugInfo(ZegoDebugLevel.INFO,
                    ZegoExpressEngineInternalImpl.ZegoInnerModule.MEDIAPLAYER, "MediaPlayer getPublishVolume", 0);
            return ZegoMediaPlayerJniAPI.getPublishVolumeJni(idxAndHandler.kMediaPlayerIdx);
        }
        return 0;
    }
    // opt_content_end: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER

    // opt_content_start: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER
    public long getTotalDuration() {
        final IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            ZegoExpressEngineInternalImpl.printDebugInfo(ZegoDebugLevel.INFO,
                    ZegoExpressEngineInternalImpl.ZegoInnerModule.MEDIAPLAYER, "MediaPlayer getTotalDuration", 0);
            return ZegoMediaPlayerJniAPI.getTotalDurationJni(idxAndHandler.kMediaPlayerIdx);
        }
        return -1;
    }
    // opt_content_end: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER

    // opt_content_start: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER
    public long getCurrentProgress() {
        final IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            ZegoExpressEngineInternalImpl.printDebugInfo(ZegoDebugLevel.INFO,
                    ZegoExpressEngineInternalImpl.ZegoInnerModule.MEDIAPLAYER, "MediaPlayer getCurrentProgress", 0);
            return ZegoMediaPlayerJniAPI.getCurrentProgressJni(idxAndHandler.kMediaPlayerIdx);
        }
        return -1;
    }

    @Override
    public int getAudioTrackCount() {
        final IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            ZegoExpressEngineInternalImpl.printDebugInfo(ZegoDebugLevel.INFO,
                    ZegoExpressEngineInternalImpl.ZegoInnerModule.MEDIAPLAYER, "MediaPlayer getAudioTrackCount", 0);
            return ZegoMediaPlayerJniAPI.getAudioTrackCount(idxAndHandler.kMediaPlayerIdx);
        }
        return -1;
    }

    @Override
    public void setAudioTrackIndex(int index) {
        final IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            int errorCode = ZegoMediaPlayerJniAPI.setAudioTrackIndex(index,idxAndHandler.kMediaPlayerIdx);
            ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                    ZegoExpressEngineInternalImpl.ZegoInnerModule.MEDIAPLAYER, "MediaPlayer setAudioTrackIndex", errorCode);

        }
    }

    @Override
    public void setVoiceChangerParam(ZegoMediaPlayerAudioChannel audioChannel, ZegoVoiceChangerParam param) {
        final IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            int errorCode = ZegoMediaPlayerJniAPI.setVoiceChangerParam(audioChannel.value(), param.pitch,idxAndHandler.kMediaPlayerIdx);
            ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                    ZegoExpressEngineInternalImpl.ZegoInnerModule.MEDIAPLAYER, "MediaPlayer setVoiceChangerParam", errorCode);

        }
    }

    // opt_content_end: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER


    // opt_content_start: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER
    public static ZegoMediaPlayer createMediaPlayer() {
        int index = ZegoMediaPlayerJniAPI.createMediaPlayerJni();
        if (index >= 0) {
            ZegoExpressEngineInternalImpl.printDebugInfo(ZegoDebugLevel.INFO,
                    ZegoExpressEngineInternalImpl.ZegoInnerModule.MEDIAPLAYER, "MediaPlayer createMediaPlayer", 0);
            ZegoMediaPlayer zegoMediaPlayer = new ZegoMediaPlayerInternalImpl();
            IdxAndHandler idxAndHandler = new IdxAndHandler(index);
            idxAndHandler.seekToTimeCallbackHashMap = new ConcurrentHashMap();
            mediaplayerToIdxAndEventhandler.put(zegoMediaPlayer, idxAndHandler);
            return zegoMediaPlayer;
        } else {
            ZegoExpressEngineInternalImpl.printDebugInfo(ZegoDebugLevel.ERROR,
                    ZegoExpressEngineInternalImpl.ZegoInnerModule.MEDIAPLAYER, "MediaPlayer createMediaPlayer", 1008030);
            return null;
        }
    }



    // opt_content_end: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER

    // opt_content_start: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER
    public static void destroyMediaPlayer(ZegoMediaPlayer mediaplayer) {

            for (Iterator<Map.Entry<ZegoMediaPlayer, IdxAndHandler>> it = mediaplayerToIdxAndEventhandler.entrySet().iterator(); it.hasNext(); ) {
                Map.Entry<ZegoMediaPlayer, IdxAndHandler> item = it.next();
                if (item.getKey() == mediaplayer) {
                    item.getValue().videoHandler = null;
                    item.getValue().audioHandler = null;
                    item.getValue().eventHandler = null;
                    item.getValue().loadResourceCallback = null;
                    item.getValue().mediaPlayerTakeSnapshotCallback = null;
                    Iterator<Map.Entry<Integer, IZegoMediaPlayerSeekToCallback>> itSeekToTimeCallbackHashMap = item.getValue().seekToTimeCallbackHashMap.entrySet().iterator();
                    for (; itSeekToTimeCallbackHashMap.hasNext(); ) {
                        itSeekToTimeCallbackHashMap.next();
                        itSeekToTimeCallbackHashMap.remove();
                    }
                    item.getValue().seekToTimeCallbackHashMap = null;
                    int idx = item.getValue().kMediaPlayerIdx;
                    int errorCode = ZegoMediaPlayerJniAPI.destroyMediaPlayerJni(idx);
                    ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                            ZegoExpressEngineInternalImpl.ZegoInnerModule.MEDIAPLAYER, "MediaPlayer destroyMediaPlayer", errorCode);
                    it.remove();
                    break;
                }
            }

    }
    // opt_content_end: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER

    // opt_content_start: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER
    public static void destroyAllMediaPlayer() {
            ZegoExpressEngineInternalImpl.printDebugInfo(ZegoDebugLevel.INFO,
                    ZegoExpressEngineInternalImpl.ZegoInnerModule.MEDIAPLAYER, "MediaPlayer destroyAllMediaPlayer", 0);
            for (Iterator<Map.Entry<ZegoMediaPlayer, IdxAndHandler>> it = mediaplayerToIdxAndEventhandler.entrySet().iterator(); it.hasNext(); ) {
                Map.Entry<ZegoMediaPlayer, IdxAndHandler> item = it.next();
                item.getValue().videoHandler = null;
                item.getValue().audioHandler = null;
                item.getValue().eventHandler = null;
                item.getValue().loadResourceCallback = null;
                item.getValue().mediaPlayerTakeSnapshotCallback = null;
                Iterator<Map.Entry<Integer, IZegoMediaPlayerSeekToCallback>> itSeekToTimeCallbackHashMap = item.getValue().seekToTimeCallbackHashMap.entrySet().iterator();
                for (; itSeekToTimeCallbackHashMap.hasNext(); ) {
                    itSeekToTimeCallbackHashMap.next();
                    itSeekToTimeCallbackHashMap.remove();
                }
                item.getValue().seekToTimeCallbackHashMap = null;
                int idx = item.getValue().kMediaPlayerIdx;
                ZegoMediaPlayerJniAPI.destroyMediaPlayerJni(idx);
                it.remove();
            }
    }
    // opt_content_end: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER

    // opt_content_start: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER
    public ZegoMediaPlayerState getCurrentState() {

        final IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            ZegoExpressEngineInternalImpl.printDebugInfo(ZegoDebugLevel.INFO,
                    ZegoExpressEngineInternalImpl.ZegoInnerModule.MEDIAPLAYER, "MediaPlayer getCurrentState", 0);
            int state = ZegoMediaPlayerJniAPI.getCurrentStateJni(idxAndHandler.kMediaPlayerIdx);
            final ZegoMediaPlayerState zegoMediaPlayerState;
            if (state == ZegoMediaPlayerState.NO_PLAY.value()) {
                zegoMediaPlayerState = ZegoMediaPlayerState.NO_PLAY;
            } else if (state == ZegoMediaPlayerState.PLAYING.value()) {
                zegoMediaPlayerState = ZegoMediaPlayerState.PLAYING;
            } else if (state == ZegoMediaPlayerState.PAUSING.value()) {
                zegoMediaPlayerState = ZegoMediaPlayerState.PAUSING;
            } else if (state == ZegoMediaPlayerState.PLAY_ENDED.value()) {
                zegoMediaPlayerState = ZegoMediaPlayerState.PLAY_ENDED;
            } else {
                zegoMediaPlayerState = ZegoMediaPlayerState.NO_PLAY;
            }
            return zegoMediaPlayerState;
        }
        return ZegoMediaPlayerState.NO_PLAY;
    }
    // opt_content_end: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER
// opt_content_start: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER
    public void takeSnapshot(IZegoMediaPlayerTakeSnapshotCallback callback) {
        final IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null){
            int errorCode = ZegoMediaPlayerJniAPI.takeSnapshotJni(idxAndHandler.kMediaPlayerIdx);
            idxAndHandler.mediaPlayerTakeSnapshotCallback = callback;
            ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                    ZegoExpressEngineInternalImpl.ZegoInnerModule.MEDIAPLAYER, "MediaPlayer takeSnapshot", errorCode);
        }
    }
    // opt_content_end: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER

    public void enableAccurateSeek(boolean enable, ZegoAccurateSeekConfig config){
        final IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            int errorCode = ZegoMediaPlayerJniAPI.enableAccurateSeek(idxAndHandler.kMediaPlayerIdx,enable, config);
            ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                    ZegoExpressEngineInternalImpl.ZegoInnerModule.MEDIAPLAYER, "MediaPlayer enableAccurateSeek", errorCode);

        }
    }

}
