package im.zego.zegoexpress.constants;

/** Video encoded frame format. */
public enum ZegoVideoEncodedFrameFormat {
    /** AVC AVCC format */
    AVCC(0),
    /** AVC Annex-B format */
    AnnexB(1);

    private int value;

    private ZegoVideoEncodedFrameFormat(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public static ZegoVideoEncodedFrameFormat getZegoVideoEncodedFrameFormat(int value) {
        try {

            if (AVCC.value == value) {
                return AVCC;
            }

            if (AnnexB.value == value) {
                return AnnexB;
            }

        } catch (Exception e) {
            throw new RuntimeException("The enumeration cannot be found");
        }
        return null;
    }
}