/*
 * Decompiled with CFR 0.152.
 */
package im.zego.zegoexpress.entity;

import im.zego.zegoexpress.constants.ZegoResolution;
import im.zego.zegoexpress.constants.ZegoVideoCodecID;
import im.zego.zegoexpress.constants.ZegoVideoConfigPreset;

public class ZegoVideoConfig {
    public int captureWidth;
    public int captureHeight;
    public int encodeWidth;
    public int encodeHeight;
    public int fps;
    public int bitrate;
    public ZegoVideoCodecID codecID = ZegoVideoCodecID.DEFAULT;

    public ZegoVideoConfig(ZegoVideoConfigPreset preset) {
        switch (preset) {
            case PRESET_180P: {
                this.captureWidth = 180;
                this.captureHeight = 320;
                this.encodeWidth = 180;
                this.encodeHeight = 320;
                this.bitrate = 300;
                this.fps = 15;
                break;
            }
            case PRESET_270P: {
                this.captureWidth = 270;
                this.captureHeight = 480;
                this.encodeWidth = 270;
                this.encodeHeight = 480;
                this.bitrate = 400;
                this.fps = 15;
                break;
            }
            case PRESET_360P: {
                this.captureWidth = 360;
                this.captureHeight = 640;
                this.encodeWidth = 360;
                this.encodeHeight = 640;
                this.bitrate = 600;
                this.fps = 15;
                break;
            }
            case PRESET_540P: {
                this.captureWidth = 540;
                this.captureHeight = 960;
                this.encodeWidth = 540;
                this.encodeHeight = 960;
                this.bitrate = 1200;
                this.fps = 15;
                break;
            }
            case PRESET_720P: {
                this.captureWidth = 720;
                this.captureHeight = 1280;
                this.encodeWidth = 720;
                this.encodeHeight = 1280;
                this.bitrate = 1500;
                this.fps = 15;
                break;
            }
            case PRESET_1080P: {
                this.captureWidth = 1080;
                this.captureHeight = 1920;
                this.encodeWidth = 1080;
                this.encodeHeight = 1920;
                this.bitrate = 3000;
                this.fps = 15;
            }
        }
    }

    public ZegoVideoConfig() {
        this(ZegoVideoConfigPreset.PRESET_360P);
    }

    public void setVideoFPS(int fps) {
        this.fps = fps;
    }

    public void setVideoBitrate(int bitrate) {
        this.bitrate = bitrate;
    }

    public void setCodecID(ZegoVideoCodecID codecID) {
        this.codecID = codecID;
    }

    @Deprecated
    public ZegoVideoConfig(ZegoResolution resolution) {
        switch (resolution) {
            case RESOLUTION_180x320: {
                this.captureWidth = 180;
                this.captureHeight = 320;
                this.encodeWidth = 180;
                this.encodeHeight = 320;
                this.bitrate = 300;
                this.fps = 15;
                break;
            }
            case RESOLUTION_270x480: {
                this.captureWidth = 270;
                this.captureHeight = 480;
                this.encodeWidth = 270;
                this.encodeHeight = 480;
                this.bitrate = 400;
                this.fps = 15;
                break;
            }
            case RESOLUTION_360x640: {
                this.captureWidth = 360;
                this.captureHeight = 640;
                this.encodeWidth = 360;
                this.encodeHeight = 640;
                this.bitrate = 600;
                this.fps = 15;
                break;
            }
            case RESOLUTION_540x960: {
                this.captureWidth = 540;
                this.captureHeight = 960;
                this.encodeWidth = 540;
                this.encodeHeight = 960;
                this.bitrate = 1200;
                this.fps = 15;
                break;
            }
            case RESOLUTION_720x1280: {
                this.captureWidth = 720;
                this.captureHeight = 1280;
                this.encodeWidth = 720;
                this.encodeHeight = 1280;
                this.bitrate = 1500;
                this.fps = 15;
                break;
            }
            case RESOLUTION_1080x1920: {
                this.captureWidth = 1080;
                this.captureHeight = 1920;
                this.encodeWidth = 1080;
                this.encodeHeight = 1920;
                this.bitrate = 3000;
                this.fps = 15;
            }
        }
    }

    public void setCaptureResolution(int width, int height) {
        this.captureWidth = width;
        this.captureHeight = height;
    }

    public void setEncodeResolution(int width, int height) {
        this.encodeWidth = width;
        this.encodeHeight = height;
    }
}

