/*
 * Decompiled with CFR 0.152.
 */
package com.zego.ve;

import android.annotation.TargetApi;
import android.graphics.SurfaceTexture;
import android.media.Image;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.os.Build;
import android.util.Log;
import android.view.Surface;
import com.zego.ve.MediaCodecVideoEncoder;
import com.zego.ve.ThreadUtils;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

@TargetApi(value=16)
public class MediaCodecVideoDecoder {
    private static final String TAG = "MediaCodecVideoDecoder";
    private static final String FORMAT_KEY_STRIDE = "stride";
    private static final String FORMAT_KEY_SLICE_HEIGHT = "slice-height";
    private static final String FORMAT_KEY_CROP_LEFT = "crop-left";
    private static final String FORMAT_KEY_CROP_RIGHT = "crop-right";
    private static final String FORMAT_KEY_CROP_TOP = "crop-top";
    private static final String FORMAT_KEY_CROP_BOTTOM = "crop-bottom";
    private static final int VIDEO_CODEC_VP8 = 0;
    private static final int VIDEO_CODEC_VP9 = 1;
    private static final int VIDEO_CODEC_H264 = 2;
    private static final int VIDEO_CODEC_HEVC = 3;
    private static final int DEQUEUE_INPUT_TIMEOUT = 500000;
    private static final int MEDIA_CODEC_RELEASE_TIMEOUT_MS = 5000;
    private static final int MAX_QUEUED_OUTPUTBUFFERS = 3;
    private static MediaCodecVideoDecoder runningInstance = null;
    private static MediaCodecVideoDecoderErrorCallback errorCallback = null;
    private static int codecErrors = 0;
    private static Set<String> hwDecoderDisabledTypes = new HashSet<String>();
    private Thread mediaCodecThread;
    private MediaCodec mediaCodec;
    private ByteBuffer[] inputBuffers;
    private ByteBuffer[] outputBuffers;
    private static final String VP8_MIME_TYPE = "video/x-vnd.on2.vp8";
    private static final String VP9_MIME_TYPE = "video/x-vnd.on2.vp9";
    private static final String H264_MIME_TYPE = "video/avc";
    private static final String HEVC_MIME_TYPE = "video/hevc";
    private static final String[] supportedVp8HwCodecPrefixes = new String[]{"OMX.qcom.", "OMX.hisi.", "OMX.IMG.", "OMX.Nvidia.", "OMX.Exynos.", "OMX.Intel."};
    private static final String[] supportedVp9HwCodecPrefixes = new String[]{"OMX.qcom.", "OMX.Exynos."};
    private static final String[] supportedH264HwCodecPrefixes = new String[]{"OMX.qcom.", "OMX.Exynos.", "OMX.MTK.", "OMX.hisi.", "OMX.IMG.", "OMX.k3.", "OMX.TI.", "OMX.rk.", "OMX.amlogic.", "OMX.Intel.", "OMX.Nvidia.", "OMX.allwinner.", "OMX.MS.", "OMX.realtek.", "OMX.Freescale.", "OMX.sprd."};
    private static final String[] supportedHEVCHwCodecPrefixes = new String[]{"OMX.qcom.", "OMX.hisi.", "OMX.IMG.", "OMX.Intel.", "OMX.MTK", "OMX.Exynos."};
    private static final int COLOR_QCOM_FORMATYUV420PackedSemiPlanar32m = 2141391876;
    private static final int COLOR_QCOM_FormatYUV420PackedSemiPlanar64x32Tile2m8ka = 2141391875;
    private static final int COLOR_FormatYUV420Flexible = 2135033992;
    private static final int[] supportedColorList = new int[]{19, 2135033992, 21, 2141391872, 2141391876, 2141391875, 2130706688, 2130708361};
    private static final int[] supportedSurfaceColorList = new int[]{2130708361, 2135033992};
    private static boolean enableWhitelist = true;
    private static final String[] HW_BLACKLISTS = new String[]{"omx.google.", "omx.ffmpeg.", "omx.pv", "omx.k3.ffmpeg.", "omx.avcodec.", "omx.ittiam.", "omx.sec.avc.sw.", "omx.marvell.video.h264decoder"};
    private static final String[] HW_SURFACE_BLACKLISTS = new String[]{"OMX.MS.", "OMX.MTK"};
    private String codecName = null;
    private int colorFormat;
    private Surface surface = null;
    private int width;
    private int height;
    private int stride;
    private int sliceHeight;
    private int cropTop;
    private int cropLeft;
    private boolean hasDecodedFirstFrame;

    public static void setErrorCallback(MediaCodecVideoDecoderErrorCallback mediaCodecVideoDecoderErrorCallback) {
        Log.d((String)TAG, (String)"Set error callback");
        errorCallback = mediaCodecVideoDecoderErrorCallback;
    }

    public static void disableVp8HwCodec() {
        Log.w((String)TAG, (String)"VP8 decoding is disabled by application.");
        hwDecoderDisabledTypes.add(VP8_MIME_TYPE);
    }

    public static void disableVp9HwCodec() {
        Log.w((String)TAG, (String)"VP9 decoding is disabled by application.");
        hwDecoderDisabledTypes.add(VP9_MIME_TYPE);
    }

    public static void disableH264HwCodec() {
        Log.w((String)TAG, (String)"H.264 decoding is disabled by application.");
        hwDecoderDisabledTypes.add(H264_MIME_TYPE);
    }

    public static void disableHEVCHwCodec() {
        Log.w((String)TAG, (String)"HEVC decoding is disabled by application.");
        hwDecoderDisabledTypes.add(HEVC_MIME_TYPE);
    }

    public static boolean isVp8HwSupported(boolean bl) {
        return !hwDecoderDisabledTypes.contains(VP8_MIME_TYPE) && MediaCodecVideoDecoder.findDecoder(VP8_MIME_TYPE, supportedVp8HwCodecPrefixes, supportedColorList) != null;
    }

    public static boolean isVp9HwSupported(boolean bl) {
        return !hwDecoderDisabledTypes.contains(VP9_MIME_TYPE) && MediaCodecVideoDecoder.findDecoder(VP9_MIME_TYPE, supportedVp9HwCodecPrefixes, supportedColorList) != null;
    }

    public static boolean isH264HwSupported(boolean bl) {
        enableWhitelist = bl;
        return !hwDecoderDisabledTypes.contains(H264_MIME_TYPE) && MediaCodecVideoDecoder.findDecoder(H264_MIME_TYPE, supportedH264HwCodecPrefixes, supportedColorList) != null;
    }

    public static boolean isH264HwSupportedUsingTextures() {
        DecoderProperties decoderProperties = MediaCodecVideoDecoder.findDecoder(H264_MIME_TYPE, supportedH264HwCodecPrefixes, supportedSurfaceColorList);
        boolean bl = true;
        if (decoderProperties != null) {
            for (String string : HW_SURFACE_BLACKLISTS) {
                if (!decoderProperties.codecName.startsWith(string)) continue;
                bl = false;
                break;
            }
        } else {
            bl = false;
        }
        return !hwDecoderDisabledTypes.contains(H264_MIME_TYPE) && decoderProperties != null && bl;
    }

    public static boolean isHEVCHwSupported(boolean bl) {
        enableWhitelist = bl;
        return !hwDecoderDisabledTypes.contains(HEVC_MIME_TYPE) && MediaCodecVideoDecoder.findDecoder(HEVC_MIME_TYPE, supportedHEVCHwCodecPrefixes, supportedColorList) != null;
    }

    public static String getCodecName() {
        DecoderProperties decoderProperties = MediaCodecVideoDecoder.findDecoder(H264_MIME_TYPE, supportedH264HwCodecPrefixes, supportedColorList);
        return decoderProperties.codecName;
    }

    public static void printStackTrace() {
        StackTraceElement[] stackTraceElementArray;
        if (runningInstance != null && MediaCodecVideoDecoder.runningInstance.mediaCodecThread != null && (stackTraceElementArray = MediaCodecVideoDecoder.runningInstance.mediaCodecThread.getStackTrace()).length > 0) {
            Log.d((String)TAG, (String)"MediaCodecVideoDecoder stacks trace:");
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                Log.d((String)TAG, (String)stackTraceElement.toString());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static DecoderProperties findDecoder(String string, String[] stringArray, int[] nArray) {
        if (Build.VERSION.SDK_INT < 16) {
            return null;
        }
        Log.d((String)TAG, (String)("Trying to find HW decoder for mime " + string));
        try {
            for (int i = 0; i < MediaCodecList.getCodecCount(); ++i) {
                MediaCodecInfo mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)i);
                if (mediaCodecInfo.isEncoder()) continue;
                String string2 = null;
                for (String stringArray2 : mediaCodecInfo.getSupportedTypes()) {
                    if (!stringArray2.equals(string)) continue;
                    string2 = mediaCodecInfo.getName();
                    break;
                }
                if (string2 == null) continue;
                Log.d((String)TAG, (String)("Found candidate decoder " + string2));
                boolean bl = false;
                if (enableWhitelist) {
                    void var9_17;
                    String[] stringArray2 = stringArray;
                    int n = stringArray2.length;
                    boolean bl2 = false;
                    while (var9_17 < n) {
                        String string3 = stringArray2[var9_17];
                        if (string2.startsWith(string3)) {
                            bl = true;
                            break;
                        }
                        ++var9_17;
                    }
                } else {
                    int n = 0;
                    String string4 = string2.toLowerCase();
                    for (Object object : HW_BLACKLISTS) {
                        if (!string4.startsWith((String)object)) continue;
                        n = 1;
                        break;
                    }
                    boolean bl3 = bl = n == 0;
                }
                if (!bl) continue;
                MediaCodecInfo.CodecCapabilities codecCapabilities = mediaCodecInfo.getCapabilitiesForType(string);
                for (int n : codecCapabilities.colorFormats) {
                    Log.d((String)TAG, (String)("Color: 0x" + Integer.toHexString(n)));
                }
                for (int n : nArray) {
                    Object object;
                    object = codecCapabilities.colorFormats;
                    int n2 = ((Object)object).length;
                    for (int j = 0; j < n2; ++j) {
                        Object object2 = object[j];
                        if (object2 != n) continue;
                        Log.d((String)TAG, (String)("Found target decoder " + string2 + ". Color: 0x" + Integer.toHexString((int)object2)));
                        return new DecoderProperties(string2, (int)object2);
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Log.d((String)TAG, (String)("No HW decoder found for mime " + string));
        return null;
    }

    private void checkOnMediaCodecThread() throws IllegalStateException {
        if (this.mediaCodecThread.getId() != Thread.currentThread().getId()) {
            throw new IllegalStateException("MediaCodecVideoDecoder previously operated on " + this.mediaCodecThread + " but is now called on " + Thread.currentThread());
        }
    }

    private boolean initDecode(int n, int n2, int n3, ByteBuffer byteBuffer, SurfaceTexture surfaceTexture) {
        if (this.mediaCodecThread != null) {
            return false;
        }
        String string = "";
        DecoderProperties decoderProperties = null;
        String string2 = "h264";
        switch (n) {
            case 2: {
                string = H264_MIME_TYPE;
                decoderProperties = MediaCodecVideoDecoder.findDecoder(string, supportedH264HwCodecPrefixes, supportedColorList);
                break;
            }
            case 0: {
                string2 = "vp8";
                string = VP8_MIME_TYPE;
                decoderProperties = MediaCodecVideoDecoder.findDecoder(string, supportedVp8HwCodecPrefixes, supportedColorList);
                break;
            }
            case 3: {
                string2 = "hevc";
                string = HEVC_MIME_TYPE;
                decoderProperties = MediaCodecVideoDecoder.findDecoder(string, supportedHEVCHwCodecPrefixes, supportedColorList);
                break;
            }
        }
        if (decoderProperties == null) {
            return false;
        }
        Log.d((String)TAG, (String)("Java initDecode, codec: " + string2 + " Color: 0x" + Integer.toHexString(decoderProperties.colorFormat)));
        runningInstance = this;
        this.mediaCodecThread = Thread.currentThread();
        try {
            MediaFormat mediaFormat = MediaFormat.createVideoFormat((String)string, (int)n2, (int)n3);
            if (surfaceTexture == null) {
                mediaFormat.setInteger("color-format", decoderProperties.colorFormat);
            } else {
                surfaceTexture.setDefaultBufferSize(n2, n3);
                this.surface = new Surface(surfaceTexture);
            }
            if (byteBuffer != null) {
                mediaFormat.setByteBuffer("csd-0", byteBuffer);
            }
            Log.d((String)TAG, (String)("  Format: " + mediaFormat));
            this.mediaCodec = MediaCodecVideoEncoder.createByCodecName(decoderProperties.codecName);
            if (this.mediaCodec == null) {
                Log.e((String)TAG, (String)("Can not create media decoder: " + string2));
                return false;
            }
            this.mediaCodec.configure(mediaFormat, this.surface, null, 0);
            this.mediaCodec.start();
            this.codecName = decoderProperties.codecName;
            this.colorFormat = decoderProperties.colorFormat;
            this.hasDecodedFirstFrame = false;
            if (Build.VERSION.SDK_INT < 21) {
                this.outputBuffers = this.mediaCodec.getOutputBuffers();
                this.inputBuffers = this.mediaCodec.getInputBuffers();
                Log.d((String)TAG, (String)("Input buffers: " + this.inputBuffers.length + ". Output buffers: " + this.outputBuffers.length));
            }
            this.width = n2;
            this.height = n3;
            return true;
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)"initDecode failed", (Throwable)exception);
            return false;
        }
    }

    private void release() {
        Log.d((String)TAG, (String)"Java releaseDecoder");
        if (this.mediaCodecThread == null || this.mediaCodec == null) {
            Log.d((String)TAG, (String)"Java decoder already release");
            return;
        }
        this.checkOnMediaCodecThread();
        if (this.mediaCodec != null) {
            final CountDownLatch countDownLatch = new CountDownLatch(1);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        Log.d((String)MediaCodecVideoDecoder.TAG, (String)"Java releaseDecoder on release thread");
                        MediaCodecVideoDecoder.this.mediaCodec.stop();
                        MediaCodecVideoDecoder.this.mediaCodec.release();
                        MediaCodecVideoDecoder.this.mediaCodec = null;
                        if (MediaCodecVideoDecoder.this.surface != null) {
                            MediaCodecVideoDecoder.this.surface.release();
                            MediaCodecVideoDecoder.this.surface = null;
                        }
                        Log.d((String)MediaCodecVideoDecoder.TAG, (String)"Java releaseDecoder on release thread done");
                    }
                    catch (Exception exception) {
                        Log.e((String)MediaCodecVideoDecoder.TAG, (String)"Media decoder release failed", (Throwable)exception);
                    }
                    countDownLatch.countDown();
                }
            };
            new Thread(runnable).start();
            if (!ThreadUtils.awaitUninterruptibly(countDownLatch, 5000L)) {
                Log.e((String)TAG, (String)"Media decoder release timeout");
                ++codecErrors;
                if (errorCallback != null) {
                    Log.e((String)TAG, (String)("Invoke codec error callback. Errors: " + codecErrors));
                    errorCallback.onMediaCodecVideoDecoderCriticalError(codecErrors);
                }
            }
        }
        this.mediaCodecThread = null;
        runningInstance = null;
        Log.d((String)TAG, (String)"Java releaseDecoder done");
    }

    private int dequeueInputBuffer() {
        this.checkOnMediaCodecThread();
        try {
            return this.mediaCodec.dequeueInputBuffer(500000L);
        }
        catch (IllegalStateException illegalStateException) {
            Log.e((String)TAG, (String)"dequeueIntputBuffer failed", (Throwable)illegalStateException);
            return -2;
        }
    }

    private boolean queueInputBuffer(int n, int n2, long l) {
        this.checkOnMediaCodecThread();
        try {
            ByteBuffer byteBuffer = this.getByteBuffer(true, n);
            byteBuffer.position(0);
            byteBuffer.limit(n2);
            this.mediaCodec.queueInputBuffer(n, 0, n2, l, 0);
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            Log.e((String)TAG, (String)"decode failed", (Throwable)illegalStateException);
            return false;
        }
    }

    private boolean queueConfig(int n, int n2) {
        this.checkOnMediaCodecThread();
        try {
            ByteBuffer byteBuffer = this.getByteBuffer(true, n);
            byteBuffer.position(0);
            byteBuffer.limit(n2);
            this.mediaCodec.queueInputBuffer(n, 0, n2, 0L, 2);
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            Log.e((String)TAG, (String)"decode failed", (Throwable)illegalStateException);
            return false;
        }
    }

    private DecodedOutputBuffer dequeueOutputBuffer(int n) {
        int n2;
        this.checkOnMediaCodecThread();
        MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
        block5: while (true) {
            n2 = this.mediaCodec.dequeueOutputBuffer(bufferInfo, TimeUnit.MILLISECONDS.toMicros(n));
            switch (n2) {
                case -3: {
                    if (Build.VERSION.SDK_INT >= 21) continue block5;
                    this.outputBuffers = this.mediaCodec.getOutputBuffers();
                    Log.d((String)TAG, (String)("Decoder output buffers changed: " + this.outputBuffers.length));
                    if (!this.hasDecodedFirstFrame) continue block5;
                    throw new RuntimeException("Unexpected output buffer change event.");
                }
                case -2: {
                    int n3;
                    int n4;
                    MediaFormat mediaFormat = this.mediaCodec.getOutputFormat();
                    Log.d((String)TAG, (String)("Decoder format changed: " + mediaFormat.toString()));
                    if (mediaFormat.containsKey(FORMAT_KEY_CROP_LEFT) && mediaFormat.containsKey(FORMAT_KEY_CROP_RIGHT) && mediaFormat.containsKey(FORMAT_KEY_CROP_BOTTOM) && mediaFormat.containsKey(FORMAT_KEY_CROP_TOP)) {
                        this.cropTop = mediaFormat.getInteger(FORMAT_KEY_CROP_TOP);
                        this.cropLeft = mediaFormat.getInteger(FORMAT_KEY_CROP_LEFT);
                    } else {
                        this.cropTop = 0;
                        this.cropLeft = 0;
                    }
                    if (mediaFormat.containsKey("width") && mediaFormat.containsKey("height")) {
                        n4 = mediaFormat.getInteger("width");
                        n3 = mediaFormat.getInteger("height");
                    } else {
                        n4 = 0;
                        n3 = 0;
                    }
                    if (this.hasDecodedFirstFrame && (n4 != this.width || n3 != this.height)) {
                        throw new RuntimeException("Unexpected size change. Configured " + this.width + "*" + this.height + ". New " + n4 + "*" + n3);
                    }
                    if (n3 != 0) {
                        this.sliceHeight = n3;
                    }
                    if (this.codecName.startsWith("OMX.rk") && this.colorFormat == 21) {
                        this.colorFormat = 21;
                    } else if (mediaFormat.containsKey("color-format")) {
                        this.colorFormat = mediaFormat.getInteger("color-format");
                        Log.d((String)TAG, (String)("Color: 0x" + Integer.toHexString(this.colorFormat)));
                    }
                    this.stride = mediaFormat.containsKey(FORMAT_KEY_STRIDE) ? mediaFormat.getInteger(FORMAT_KEY_STRIDE) : n4;
                    if (mediaFormat.containsKey(FORMAT_KEY_SLICE_HEIGHT)) {
                        this.sliceHeight = mediaFormat.getInteger(FORMAT_KEY_SLICE_HEIGHT);
                    }
                    Log.d((String)TAG, (String)("Output frame stride and slice height: " + this.stride + " x " + this.sliceHeight));
                    this.stride = Math.max(this.width, this.stride);
                    this.sliceHeight = (19 == this.colorFormat || 21 == this.colorFormat) && n3 != this.sliceHeight ? this.height : Math.max(this.height, this.sliceHeight);
                    this.hasDecodedFirstFrame = false;
                    continue block5;
                }
                case -1: {
                    return null;
                }
            }
            break;
        }
        boolean bl = !this.hasDecodedFirstFrame;
        this.hasDecodedFirstFrame = true;
        if (this.colorFormat != 2135033992) {
            ByteBuffer byteBuffer = this.getByteBuffer(false, n2);
            byteBuffer.position(bufferInfo.offset);
            byteBuffer.limit(bufferInfo.offset + bufferInfo.size);
            return new DecodedOutputBuffer(n2, byteBuffer, bufferInfo.presentationTimeUs, bl);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            Image image = this.mediaCodec.getOutputImage(n2);
            Image.Plane[] planeArray = image.getPlanes();
            boolean bl2 = false;
            bl2 = planeArray[1].getPixelStride() == 1 && planeArray[2].getPixelStride() == 1;
            return new DecodedOutputBuffer(n2, planeArray[0].getBuffer(), planeArray[1].getBuffer(), planeArray[2].getBuffer(), planeArray[0].getRowStride(), planeArray[1].getRowStride(), planeArray[2].getRowStride(), bl2, bufferInfo.presentationTimeUs, bl);
        }
        return null;
    }

    public boolean returnDecodedOutputBuffer(int n) {
        this.checkOnMediaCodecThread();
        try {
            this.mediaCodec.releaseOutputBuffer(n, this.surface != null);
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            Log.e((String)TAG, (String)"releaseOutputBuffer failed", (Throwable)illegalStateException);
            return false;
        }
    }

    @TargetApi(value=21)
    ByteBuffer getByteBuffer(boolean bl, int n) {
        int n2 = Build.VERSION.SDK_INT;
        ByteBuffer byteBuffer = n2 >= 21 ? (bl ? this.mediaCodec.getInputBuffer(n) : this.mediaCodec.getOutputBuffer(n)) : (bl ? this.inputBuffers[n] : this.outputBuffers[n]);
        return byteBuffer;
    }

    private static class DecodedOutputBuffer {
        private final int index;
        private ByteBuffer buffer;
        private final long presentationTimeStampUs;
        public final boolean formatChanged;
        private boolean isI420;
        private ByteBuffer yBuffer;
        private ByteBuffer uBuffer;
        private ByteBuffer vBuffer;
        private int yStride;
        private int uStride;
        private int vStride;

        public DecodedOutputBuffer(int n, ByteBuffer byteBuffer, long l, boolean bl) {
            this.index = n;
            this.buffer = byteBuffer;
            this.presentationTimeStampUs = l;
            this.formatChanged = bl;
        }

        public DecodedOutputBuffer(int n, ByteBuffer byteBuffer, ByteBuffer byteBuffer2, ByteBuffer byteBuffer3, int n2, int n3, int n4, boolean bl, long l, boolean bl2) {
            this.index = n;
            this.yBuffer = byteBuffer;
            this.uBuffer = byteBuffer2;
            this.vBuffer = byteBuffer3;
            this.yStride = n2;
            this.uStride = n3;
            this.vStride = n4;
            this.presentationTimeStampUs = l;
            this.formatChanged = bl2;
        }
    }

    private static class DecoderProperties {
        public final String codecName;
        public final int colorFormat;

        public DecoderProperties(String string, int n) {
            this.codecName = string;
            this.colorFormat = n;
        }
    }

    public static interface MediaCodecVideoDecoderErrorCallback {
        public void onMediaCodecVideoDecoderCriticalError(int var1);
    }
}

