package im.zego.zegoexpress.entity;

import im.zego.zegoexpress.constants.*;
import im.zego.zegoexpress.callback.*;
import im.zego.zegoexpress.entity.*;
import java.nio.*;
import java.util.*;
import org.json.*;
import im.zego.zegoexpress.*;
import im.zego.zegoexpress.internal.*;
import android.app.Application;
import android.graphics.*;

/**
 * Advanced player configuration
 *
 * Configure playing stream CDN configuration, video layer
 *
 */
public class ZegoPlayerConfig {

    /**
     * Stream resource mode
     */
    public ZegoStreamResourceMode resourceMode;

    /**
     * The CDN configuration for playing stream. If set, the stream is play according to the URL instead of the streamID. After that, the streamID is only used as the ID of SDK internal callback.
     */
    public ZegoCDNConfig cdnConfig;

    /**
     * @deprecated This property has been deprecated since version 1.19.0, please use the [setPlayStreamVideoLayer] function instead.
     *
     * This function only works when the remote publisher set the video codecID as SVC
     */
    public ZegoPlayerVideoLayer videoLayer;

}

