package im.zego.zegoexpress.entity;

import im.zego.zegoexpress.constants.*;
import im.zego.zegoexpress.callback.*;
import im.zego.zegoexpress.entity.*;
import java.nio.*;
import java.util.*;
import org.json.*;
import im.zego.zegoexpress.*;
import im.zego.zegoexpress.internal.*;
import android.app.Application;
import android.graphics.*;

/**
 * Mix stream audio configuration
 *
 * Configure video frame rate, bitrate, and resolution for mixer task
 *
 */
public class ZegoMixerAudioConfig {

    /**
     * Audio bitrate in kbps, default is 48 kbps, cannot be modified after starting a mixer task
     */
    public int bitrate;

    /**
     * Audio channel, default is Mono
     */
    public ZegoAudioChannel channel;

    /**
     * codec ID, default is ZegoAudioCodecIDDefault
     */
    public ZegoAudioCodecID codecID;

    public ZegoMixerAudioConfig(){
        bitrate = 48;
        channel = ZegoAudioChannel.MONO;
        codecID = ZegoAudioCodecID.DEFAULT;
    }

}

