package im.zego.zegoexpress.entity;

import im.zego.zegoexpress.constants.*;
import im.zego.zegoexpress.callback.*;
import im.zego.zegoexpress.entity.*;
import java.nio.*;
import java.util.*;
import org.json.*;
import im.zego.zegoexpress.*;
import im.zego.zegoexpress.internal.*;
import android.app.Application;
import android.graphics.*;

/**
 * Log config
 *
 * Configure the log file save path and the maximum log file size
 *
 */
public class ZegoLogConfig {

    /**
     * The log file save path. The default path is /sdcard/Android/data/[packageName]/files/
     */
    public String logPath;

    /**
     * The maximum log file size (Bytes). The default maximum size is 5MB (5 * 1024 * 1024 Bytes)
     */
    public long logSize;

    public ZegoLogConfig(){
        logPath = "";
        logSize = 5 * 1024 * 1024;
    }

}

