package im.zego.zegoexpress.constants;

import im.zego.zegoexpress.constants.*;
import im.zego.zegoexpress.callback.*;
import im.zego.zegoexpress.entity.*;
import java.nio.*;
import java.util.*;
import org.json.*;
import im.zego.zegoexpress.*;
import im.zego.zegoexpress.internal.*;
import android.app.Application;
import android.graphics.*;

/**
 * Reverberation preset value.
 *
 */
public enum ZegoReverbPreset {

    /**
     * No Reverberation
     */
    NONE(0),

    /**
     * Soft room reverb effect
     */
    SOFT_ROOM(1),

    /**
     * Large room reverb effect
     */
    LARGE_ROOM(2),

    /**
     * Concer hall reverb effect
     */
    CONCER_HALL(3),

    /**
     * Valley reverb effect
     */
    VALLEY(4),

    /**
     * Recording studio reverb effect
     */
    RECORDING_STUDIO(5),

    /**
     * Basement reverb effect
     */
    BASEMENT(6),

    /**
     * KTV reverb effect
     */
    KTV(7),

    /**
     * Popular reverb effect
     */
    POPULAR(8),

    /**
     * Rock reverb effect
     */
    ROCK(9),

    /**
     * Vocal concert reverb effect
     */
    VOCAL_CONCERT(10);

    private int value;

    private ZegoReverbPreset(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public static ZegoReverbPreset getZegoReverbPreset(int value) {
        try {

            if (NONE.value == value) {
                return NONE;
            }

            if (SOFT_ROOM.value == value) {
                return SOFT_ROOM;
            }

            if (LARGE_ROOM.value == value) {
                return LARGE_ROOM;
            }

            if (CONCER_HALL.value == value) {
                return CONCER_HALL;
            }

            if (VALLEY.value == value) {
                return VALLEY;
            }

            if (RECORDING_STUDIO.value == value) {
                return RECORDING_STUDIO;
            }

            if (BASEMENT.value == value) {
                return BASEMENT;
            }

            if (KTV.value == value) {
                return KTV;
            }

            if (POPULAR.value == value) {
                return POPULAR;
            }

            if (ROCK.value == value) {
                return ROCK;
            }

            if (VOCAL_CONCERT.value == value) {
                return VOCAL_CONCERT;
            }

        } catch (Exception e) {
            throw new RuntimeException("The enumeration cannot be found");
        }
        return null;
    }

}

