package im.zego.zegoexpress.constants;

import im.zego.zegoexpress.constants.*;
import im.zego.zegoexpress.callback.*;
import im.zego.zegoexpress.entity.*;
import java.nio.*;
import java.util.*;
import org.json.*;
import im.zego.zegoexpress.*;
import im.zego.zegoexpress.internal.*;
import android.app.Application;
import android.graphics.*;

/**
 * Publish channel
 *
 */
public enum ZegoPublishChannel {

    /**
     * Main publish channel
     */
    MAIN(0),

    /**
     * Auxiliary publish channel
     */
    AUX(1);

    private int value;

    private ZegoPublishChannel(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public static ZegoPublishChannel getZegoPublishChannel(int value) {
        try {

            if (MAIN.value == value) {
                return MAIN;
            }

            if (AUX.value == value) {
                return AUX;
            }

        } catch (Exception e) {
            throw new RuntimeException("The enumeration cannot be found");
        }
        return null;
    }

}

