package im.zego.zegoexpress.constants;

import im.zego.zegoexpress.constants.*;
import im.zego.zegoexpress.callback.*;
import im.zego.zegoexpress.entity.*;
import java.nio.*;
import java.util.*;
import org.json.*;
import im.zego.zegoexpress.*;
import im.zego.zegoexpress.internal.*;
import android.app.Application;
import android.graphics.*;

/**
 * Audio capture stereo mode
 *
 */
public enum ZegoAudioCaptureStereoMode {

    /**
     * Disable capture stereo, i.e. capture mono
     */
    NONE(0),

    /**
     * Always enable capture stereo
     */
    ALWAYS(1),

    /**
     * Adaptive mode, capture stereo when publishing stream only, capture mono when publishing and playing stream (e.g. talk/intercom scenes)
     */
    ADAPTIVE(2);

    private int value;

    private ZegoAudioCaptureStereoMode(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public static ZegoAudioCaptureStereoMode getZegoAudioCaptureStereoMode(int value) {
        try {

            if (NONE.value == value) {
                return NONE;
            }

            if (ALWAYS.value == value) {
                return ALWAYS;
            }

            if (ADAPTIVE.value == value) {
                return ADAPTIVE;
            }

        } catch (Exception e) {
            throw new RuntimeException("The enumeration cannot be found");
        }
        return null;
    }

}

