package im.zego.zegoexpress.callback;

import im.zego.zegoexpress.constants.*;
import im.zego.zegoexpress.callback.*;
import im.zego.zegoexpress.entity.*;
import java.nio.*;
import java.util.*;
import org.json.*;
import im.zego.zegoexpress.*;
import im.zego.zegoexpress.internal.*;
import android.app.Application;
import android.graphics.*;

public abstract class IZegoCustomVideoProcessHandler {

    /**
     * The SDK informs the developer that it is about to start custom video processing
     *
     * It is recommended to initialize other resources in this callback
     *
     * @param channel Publishing stream channel
     */
    public void onStart(ZegoPublishChannel channel){

    }

    /**
     * The SDK informs the developer to stop custom video processing
     *
     * It is recommended to destroy other resources in this callback
     *
     * @param channel Publishing stream channel
     */
    public void onStop(ZegoPublishChannel channel){

    }

    /**
     * Call back when the original video data of type [Texture] is obtained
     *
     * This callback takes effect when [enableCustomVideoProcessing] is called to enable custom video processing and the bufferType of config is passed in [ZEGO_VIDEO_BUFFER_TYPE_GL_TEXTURE_2D]
     * After the developer has processed the original image, he must call [sendCustomVideoProcessedTextureData] to send the processed data back to the SDK, otherwise it will cause frame loss
     * Precondition： call [setCustomVideoProcessHandler] to set callback
     * Supported version： 2.2.0
     *
     * @param textureID Texture ID
     * @param width Texture width
     * @param height Texture height
     * @param referenceTimeMillisecond video frame reference time, UNIX timestamp, in milliseconds.
     * @param channel Publishing stream channel
     */
    public void onCapturedUnprocessedTextureData(int textureID, int width, int height, long referenceTimeMillisecond, ZegoPublishChannel channel){

    }

    /**
     * When the developer chooses the SurfaceTexture type, the SDK needs to obtain the SurfaceTexture from the developer for inputting original video data
     *
     * This callback takes effect when [enableCustomVideoProcessing] is called to enable custom video processing and the bufferType of config is passed in [ZEGO_VIDEO_BUFFER_TYPE_SURFACETEXTURE]
     * Developers need to create a SurfaceTexture object and listen to its member method [setOnFrameAvailableListener], and then return the corresponding SurfaceTexture. When the SDK original video data input is complete, the developer will receive [onFrameAvailable]
     * After the developer passes the SurfaceTexture(input) object to the SDK, he can call [getCustomVideoProcessOutputSurfaceTexture] to get the SurfaceTexture used by the SDK to encode and publish the stream, and then the developer can pass the video processed data into this SurfaceTexture(output) object
     *
     * @param width The capture width of the original video
     * @param height The capture height of the original video
     * @param channel Publishing stream channel
     *
     * @return SurfaceTexture instance
     */
    public SurfaceTexture getCustomVideoProcessInputSurfaceTexture(int width, int height, ZegoPublishChannel channel){
        return null;
    }

}

