package im.zego.zegoexpress.constants;

/** Active Noise Suppression mode. */
public enum ZegoANSMode {
    /** Soft ANS */
    SOFT(0),
    /** Medium ANS */
    MEDIUM(1),
    /** Aggressive ANS */
    AGGRESSIVE(2);

    private int value;

    private ZegoANSMode(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public static ZegoANSMode getZegoANSMode(int value) {
        try {

            if (SOFT.value == value) {
                return SOFT;
            }

            if (MEDIUM.value == value) {
                return MEDIUM;
            }

            if (AGGRESSIVE.value == value) {
                return AGGRESSIVE;
            }

        } catch (Exception e) {
            throw new RuntimeException("The enumeration cannot be found");
        }
        return null;
    }
}