/*
 * Decompiled with CFR 0.152.
 */
package com.zego.zegoavkit2.receiver;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

class Background
implements Application.ActivityLifecycleCallbacks {
    public static final String TAG = "BackgroundMonitor";
    public static final long CHECK_DELAY = 2000L;
    private static Callback becameForeground = new Callback(){

        @Override
        public void invoke(Listener listener) {
            listener.onBecameForeground();
        }
    };
    private static Callback becameBackground = new Callback(){

        @Override
        public void invoke(Listener listener) {
            listener.onBecameBackground();
        }
    };
    private static Background instance = new Background();
    private boolean background;
    private WeakReference<Activity> currentActivity;
    private Listeners listeners = new Listeners();
    private Handler handler = new Handler(Looper.getMainLooper());
    private Runnable check;
    private Application application;

    Background() {
    }

    public Background init(Application app) {
        this.uninit();
        this.application = app;
        this.application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        return this;
    }

    public Background uninit() {
        if (this.application != null) {
            this.application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
            this.application = null;
        }
        return this;
    }

    public static Background get() {
        return instance;
    }

    public boolean isBackground() {
        return this.background;
    }

    public boolean isForeground() {
        return !this.background;
    }

    public Binding addListener(Listener listener) {
        return this.listeners.add(listener);
    }

    public void onActivityResumed(Activity activity) {
    }

    public void onActivityPaused(Activity activity) {
        if (!activity.isChangingConfigurations()) {
            final WeakReference<Activity> ref = new WeakReference<Activity>(activity);
            this.check = new Runnable(){

                @Override
                public void run() {
                    Background.this.onActivityCeased((Activity)ref.get());
                }
            };
            this.handler.postDelayed(this.check, 2000L);
        }
    }

    public void onActivityStarted(Activity activity) {
        this.currentActivity = new WeakReference<Activity>(activity);
        if (this.check != null) {
            this.handler.removeCallbacks(this.check);
        }
        if (this.background && activity != null && !activity.isChangingConfigurations()) {
            this.background = false;
            Log.i((String)TAG, (String)"became foreground");
            this.listeners.each(becameForeground);
        }
    }

    public void onActivityStopped(Activity activity) {
        if (this.check != null) {
            this.handler.removeCallbacks(this.check);
        }
        this.onActivityCeased(activity);
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
    }

    private void onActivityCeased(Activity activity) {
        if (!(this.background || this.currentActivity != null && activity != this.currentActivity.get() || activity == null || activity.isChangingConfigurations())) {
            this.background = true;
            Log.i((String)TAG, (String)"became background");
            this.listeners.each(becameBackground);
        }
    }

    private static class Listeners {
        private List<WeakReference<Listener>> listeners = new CopyOnWriteArrayList<WeakReference<Listener>>();

        private Listeners() {
        }

        public Binding add(Listener listener) {
            final WeakReference<Listener> wr = new WeakReference<Listener>(listener);
            this.listeners.add(wr);
            return new Binding(){

                @Override
                public void unbind() {
                    Listeners.this.listeners.remove(wr);
                }
            };
        }

        public void each(Callback callback) {
            ArrayList<WeakReference<Listener>> toRemove = new ArrayList<WeakReference<Listener>>();
            Iterator<WeakReference<Listener>> it = this.listeners.iterator();
            while (it.hasNext()) {
                try {
                    WeakReference<Listener> wr = it.next();
                    Listener l = (Listener)wr.get();
                    if (l != null) {
                        callback.invoke(l);
                        continue;
                    }
                    toRemove.add(wr);
                }
                catch (Exception exc) {
                    Log.e((String)Background.TAG, (String)"Listener threw exception!", (Throwable)exc);
                }
            }
            if (!toRemove.isEmpty()) {
                this.listeners.removeAll(toRemove);
            }
        }
    }

    private static interface Callback {
        public void invoke(Listener var1);
    }

    public static interface Binding {
        public void unbind();
    }

    public static interface Listener {
        public void onBecameForeground();

        public void onBecameBackground();
    }
}

