/*
 * Decompiled with CFR 0.152.
 */
package com.zego.ve;

import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import com.zego.ve.FeatureKitManager;
import com.zego.ve.HwAudioKaraokeFeatureKit;
import com.zego.ve.IAudioKitCallback;
import com.zego.ve.IHwAudioEngine;
import com.zego.ve.Log;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class HwAudioKit {
    private static final String TAG = "HwAudioKit.HwAudioKit";
    private static final String ENGINE_CLASS_NAME = "com.huawei.multimedia.audioengine.HwAudioEngineService";
    private Context mContext = null;
    private IHwAudioEngine mIHwAudioEngine = null;
    private boolean mIsServiceConnected = false;
    private FeatureKitManager mFeatureKitManager = FeatureKitManager.getInstance();
    private IBinder mService = null;
    private ServiceConnection mConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            HwAudioKit.this.mIHwAudioEngine = IHwAudioEngine.Stub.asInterface(iBinder);
            if (HwAudioKit.this.mIHwAudioEngine != null) {
                HwAudioKit.this.mIsServiceConnected = true;
                HwAudioKit.this.mFeatureKitManager.onCallBack(0);
                HwAudioKit.this.serviceInit(HwAudioKit.this.mContext.getPackageName(), "1.0.1");
                HwAudioKit.this.serviceLinkToDeath(iBinder);
            }
        }

        public void onServiceDisconnected(ComponentName componentName) {
            HwAudioKit.this.mIHwAudioEngine = null;
            HwAudioKit.this.mIsServiceConnected = false;
            HwAudioKit.this.mFeatureKitManager.onCallBack(4);
        }
    };
    private IBinder.DeathRecipient mDeathRecipient = new IBinder.DeathRecipient(){

        public void binderDied() {
            HwAudioKit.this.mService.unlinkToDeath(HwAudioKit.this.mDeathRecipient, 0);
            HwAudioKit.this.mFeatureKitManager.onCallBack(6);
            HwAudioKit.this.mService = null;
        }
    };
    public static final int AUDIO_KIT_SUCCESS = 0;
    public static final int GET_LATENCY_FAIL = -1;
    public static final int SERVICE_BIND_ERROR = -2;
    public static final int VENDOR_NOT_SUPPORTED = 2;
    public static final int AUDIO_KIT_SERVICE_DISCONNECTED = 4;
    public static final int AUDIO_KIT_SERVICE_LINKFAILED = 5;
    public static final int AUDIO_KIT_SERVICE_DIED = 6;
    public static final int APP_CONTEXT_NULL = 7;
    public static final int KARAOKE_SUCCESS = 1000;
    public static final int KARAOKE_SERVICE_DISCONNECTED = 1001;
    public static final int KARAOKE_SERVICE_LINKFAIL = 1002;
    public static final int KARAOKE_SERVICE_DIED = 1003;
    public static final int KARAOKE_WIRED_HEADSET_NOT_PLUG_IN = 1805;
    public static final int PLATEFORM_NOT_SUPPORT = 1806;
    public static final int PARAME_VALUE_ERROR = 1807;
    protected HwAudioKaraokeFeatureKit _hwAudioKaraokeFeatureKit = null;
    protected state _state = state.state_none;
    protected CountDownLatch barrier = null;
    protected IAudioKitCallback _callBack = new IAudioKitCallback(){

        @Override
        public void onResult(int n) {
            Log.i(HwAudioKit.TAG, "audiokit callback " + n);
            if (HwAudioKit.this.barrier != null) {
                HwAudioKit.this.barrier.countDown();
            }
            switch (n) {
                case 0: {
                    HwAudioKit.this._state = state.state_audiokit_success;
                    break;
                }
                case 1000: {
                    HwAudioKit.this._state = state.state_karaoke_success;
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: {
                    HwAudioKit.this._state = state.state_audiokit_failed;
                    break;
                }
                case 1001: 
                case 1002: 
                case 1003: {
                    HwAudioKit.this._state = state.state_karaoke_failed;
                    break;
                }
            }
        }
    };

    public HwAudioKit(Context context) {
        this.mFeatureKitManager.setCallBack(this._callBack);
        this.mContext = context;
    }

    private void serviceLinkToDeath(IBinder iBinder) {
        this.mService = iBinder;
        try {
            if (this.mService != null) {
                this.mService.linkToDeath(this.mDeathRecipient, 0);
            }
        }
        catch (RemoteException remoteException) {
            this.mFeatureKitManager.onCallBack(5);
        }
    }

    public boolean initialize() {
        this.barrier = new CountDownLatch(1);
        if (this.mContext == null) {
            this.mFeatureKitManager.onCallBack(7);
        } else if (!this.mFeatureKitManager.isMediaKitSupport(this.mContext)) {
            this.mFeatureKitManager.onCallBack(2);
        } else {
            this.bindService(this.mContext);
        }
        try {
            if (!this.barrier.await(100L, TimeUnit.MILLISECONDS)) {
                Log.e(TAG, "initialize timeout");
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        this.barrier = null;
        return this._state == state.state_audiokit_success;
    }

    private void bindService(Context context) {
        if (this.mFeatureKitManager != null && !this.mIsServiceConnected) {
            this.mFeatureKitManager.bindService(context, this.mConnection, ENGINE_CLASS_NAME);
        }
    }

    public void destroy() {
        if (this.mIsServiceConnected) {
            this.mIsServiceConnected = false;
            this.mFeatureKitManager.unbindService(this.mContext, this.mConnection);
        }
        if (this._hwAudioKaraokeFeatureKit != null) {
            this._hwAudioKaraokeFeatureKit.destroy();
        }
    }

    public void createFeatureKaraoke() {
        this.barrier = new CountDownLatch(1);
        this._hwAudioKaraokeFeatureKit = this.mFeatureKitManager.createFeatureKit(1, this.mContext);
        try {
            if (!this.barrier.await(100L, TimeUnit.MILLISECONDS)) {
                Log.e(TAG, "createFeatureKaraoke timeout");
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        this.barrier = null;
    }

    public boolean isFeatureKaraokeOn() {
        return this._state == state.state_karaoke_success;
    }

    public int enableKaraokeFeature(boolean bl) {
        return this._hwAudioKaraokeFeatureKit.enableKaraokeFeature(bl);
    }

    public void setKaraokeVolume(int n) {
        this._hwAudioKaraokeFeatureKit.setParameter("Karaoke_volume=", n);
    }

    private void serviceInit(String string, String string2) {
        try {
            if (this.mIHwAudioEngine != null && this.mIsServiceConnected) {
                this.mIHwAudioEngine.init(string, string2);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    static enum state {
        state_none,
        state_audiokit_success,
        state_audiokit_failed,
        state_karaoke_success,
        state_karaoke_failed;

    }
}

