package im.zego.zegoexpress.constants;

/** SEI type */
public enum ZegoSEIType {
    /** Using H.264 SEI (nalu type = 6, payload type = 243) type packaging, this type is not specified by the SEI standard, there is no conflict with the video encoder or the SEI in the video file, users do not need to follow the SEI content Do filtering, SDK uses this type by default. */
    ZEGO_DEFINED(0),
    /** SEI (nalu type = 6, payload type = 5) of H.264 is used for packaging. The H.264 standard has a prescribed format for this type: startcode + nalu type (6) + payload type (5) + len + payload (uuid + content) + trailing bits. Because the video encoder itself generates an SEI with a payload type of 5, or when a video file is used for streaming, such SEI may also exist in the video file, so when using this type, the user needs to use uuid + context as a buffer sending SEI. At this time, in order to distinguish the SEI generated by the video encoder itself, when the App sends this type of SEI, it can fill in the service-specific uuid (uuid length is 16 bytes). When the receiver uses the SDK to parse the SEI of the payload type 5, it will set filter string filters out the SEI matching the uuid and throws it to the business. If the filter string is not set, the SDK will throw all received SEI to the developer. uuid filter string setting function, [ZegoEngineConfig.advancedConfig("unregister_sei_filter","XXXXXX")], where unregister_sei_filter is the key, and XXXXX is the uuid filter string to be set. */
    USER_UNREGISTER(1);

    private int value;

    private ZegoSEIType(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public static ZegoSEIType getZegoSEIType(int value) {
        try {

            if (ZEGO_DEFINED.value == value) {
                return ZEGO_DEFINED;
            }

            if (USER_UNREGISTER.value == value) {
                return USER_UNREGISTER;
            }

        } catch (Exception e) {
            throw new RuntimeException("The enumeration cannot be found");
        }
        return null;
    }
}