package com.zego.zegoavkit2.hardwaremonitor;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;

public class ZegoCPUUtils {

    private static double mLastProcessCpu = 0.0;
    private static double mLastAllCpu = 0.0;
    private static double mLastAllCpuForSystem = 0.0;
    private static double mLastIdleCpu = 0.0;

    /**
     * 获取CPU使用率
     * @param pid 指定要采集的进程号
     * @return 进程的CPU使用率
     */
    public static double getProcessCPUUsage(int pid) {
        double result = 0.0;
        double[] resultP = null;
        double[] resultA = null;
        double currentProcessCpu = 0.0;
        double currentAllCpu = 0.0;

        if (pid <= 0) return result;

        resultP = getProcessCpuAction(pid);
        if (null != resultP) {
            currentProcessCpu = resultP[1] + resultP[2];
        }
        resultA = getCpuAction();
        if (null != resultA) {
            for (int i = 0; i < resultA.length; i++) {
                currentAllCpu += resultA[i];
            }
        }

        if(mLastAllCpu == 0 && mLastProcessCpu == 0) {
            mLastAllCpu = currentAllCpu;
            mLastProcessCpu = currentProcessCpu;

            return result;
        }

        if ((currentAllCpu - mLastAllCpu) > 0) {
            result = div(((currentProcessCpu - mLastProcessCpu) * 100.00), (currentAllCpu - mLastAllCpu), 2);
            if (result < 0) {
                result = 0;
            }
        }

        mLastAllCpu = currentAllCpu;
        mLastProcessCpu = currentProcessCpu;

        return result;
    }

    /**
     * 获取系统CPU使用率
     * @return 系统CPU使用率
     */
    public static double getSystemCPUUsage() {
        double result = 0.0;
        double[] resultA = null;
        double currentAllCpu = 0.0;
        double currentIdleCpu = 0.0;

        resultA = getCpuAction();
        if (null != resultA) {
            for (int i = 0; i < resultA.length; i++) {
                currentAllCpu += resultA[i];
            }

            if (resultA.length > 3) {
                currentIdleCpu = resultA[3];
            }
        }

        if(mLastAllCpuForSystem == 0 && mLastIdleCpu == 0) {
            mLastAllCpuForSystem = currentAllCpu;
            mLastIdleCpu = currentIdleCpu;

            return result;
        }

        double allCpuDelta = currentAllCpu - mLastAllCpuForSystem;
        double idleCpuDelta = currentIdleCpu - mLastIdleCpu;
        if (allCpuDelta > 0 && idleCpuDelta > 0) {
            result = div(((allCpuDelta - idleCpuDelta) * 100.00), allCpuDelta, 2);
            if (result < 0) {
                result = 0;
            }
        }

        mLastAllCpuForSystem = currentAllCpu;
        mLastIdleCpu = currentIdleCpu;

        return result;
    }

    private static double[] getCpuAction() {
        String cpuPath = "/proc/stat";
        String cpu = "";
        double[] result = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        
        File f = new File(cpuPath);
        if (!f.exists() || !f.canRead())
        {
            return result;
        }

        FileReader fr = null;
        BufferedReader localBufferedReader = null;

        try {
            fr = new FileReader(f);
            localBufferedReader = new BufferedReader(fr, 8192);
            cpu = localBufferedReader.readLine();
            if (null != cpu) {
                String[] cpuInfo = cpu.split(" ");
                for (int i=2; i<cpuInfo.length && i-2<result.length; i++) {
                    try {
                        result[i-2] = Double.parseDouble(cpuInfo[i]);
                    } catch(NullPointerException e) {
                        // e.printStackTrace();
                    } catch (NumberFormatException e) {
                        // e.printStackTrace();
                    }
                }
            }
        } catch (FileNotFoundException e) {
            // e.printStackTrace();
        } catch (IOException e) {
            // e.printStackTrace();
        }
        closeReader(localBufferedReader);
        return result;
    }

    private static double[]  getProcessCpuAction(int pid) {
        String cpuPath = "/proc/" + pid + "/stat";
        String cpu = "";
        double[] result = {0.0, 0.0, 0.0};

        File f = new File(cpuPath);
        if (!f.exists() || !f.canRead())
        {
            /*
             * 进程信息可能无法读取，
             * 同时发现此类进程的PSS信息也是无法获取的，用PS命令会发现此类进程的PPid是1，
             * 即/init，而其他进程的PPid是zygote,
             * 说明此类进程是直接new出来的，不是Android系统维护的
             */
            return result;
        }

        FileReader fr = null;
        BufferedReader localBufferedReader = null;

        try {
            fr = new FileReader(f);
            localBufferedReader = new BufferedReader(fr, 8192);
            cpu = localBufferedReader.readLine();
            if (null != cpu) {
                String[] cpuSplit = cpu.split(" ");
                if (cpuSplit.length > 2) {
                    try {
                        result[0] = Double.parseDouble(cpuSplit[1]);
                    } catch(NullPointerException e) {
                        // e.printStackTrace();
                    } catch (NumberFormatException e) {
                        // e.printStackTrace();
                    }
                }

                if (cpuSplit.length > 13) {
                    try {
                        result[1] = Double.parseDouble(cpuSplit[13]);
                    } catch(NullPointerException e) {
                        // e.printStackTrace();
                    } catch (NumberFormatException e) {
                        // e.printStackTrace();
                    }
                }

                if (cpuSplit.length > 14) {
                    try {
                        result[2] = Double.parseDouble(cpuSplit[14]);
                    } catch(NullPointerException e) {
                        // e.printStackTrace();
                    } catch (NumberFormatException e) {
                        // e.printStackTrace();
                    }
                }
            }
        }catch (IOException e) {
            e.printStackTrace();
        }
        closeReader(localBufferedReader);
        return result;
    }

    /**
     * double 除法
     * 
     * @param d1 被除数
     * @param d2 除数
     * @param scale
     *            四舍五入 小数点位数
     * @return 除法结果
     */
    public static double div(double d1, double d2, int scale) {
        // 当然在此之前，你要判断分母是否为0，
        // 为0你可以根据实际需求做相应的处理

        BigDecimal bd1 = new BigDecimal(Double.toString(d1));
        BigDecimal bd2 = new BigDecimal(Double.toString(d2));
        // 直接向下取整，保持和UI展示一致
        try
        {
            return bd1.divide(bd2, scale, BigDecimal.ROUND_DOWN).doubleValue();
        } catch (Exception e)
        {
            // 根据bugly观测，在进入GTOpMulPerfActivity页时有极小概率crash，故加上异常保护
            // @see http://bugly.qq.com/detail?app=900010910&pid=1&ii=46#stack
            e.printStackTrace();
            return 0;
        }
        
    }

    /**
	 * 关闭bufferReader
	 * 
	 * @param br
	 */
	private static void closeReader(Reader br) {
		if (br != null) {
			try {
				br.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
	}
}