/*
 * Decompiled with CFR 0.152.
 */
package com.zego.zegoavkit2.hardwaremonitor;

import android.content.Context;
import android.os.Process;
import com.zego.zegoavkit2.hardwaremonitor.ZegoCPUUtils;
import com.zego.zegoavkit2.hardwaremonitor.ZegoMEMUtils;

public final class ZegoHardwareMonitor {
    public static double getProcessCPUUsage() {
        int pid = Process.myPid();
        return ZegoCPUUtils.getProcessCPUUsage(pid);
    }

    public static double getSystemCPUUsage() {
        return ZegoCPUUtils.getSystemCPUUsage();
    }

    public static double getMEMUsage(Context context) {
        int pid = Process.myPid();
        long[] value = ZegoMEMUtils.getPSS(context, pid);
        return (double)value[2] / 1024.0;
    }

    public static double getSystemMEMUsage(Context context) {
        long[] value = ZegoMEMUtils.getMemInfo();
        double totalFree = 0.0;
        double total = value[0];
        for (int i = 1; i < value.length; ++i) {
            totalFree += (double)value[i];
        }
        return total - totalFree;
    }

    public static double getMEMTotal(Context context) {
        long[] value = ZegoMEMUtils.getMemInfo();
        return value[0];
    }
}

