/*
 * Decompiled with CFR 0.152.
 */
package com.zego.ve;

import android.annotation.TargetApi;
import android.media.AudioDeviceInfo;
import android.media.AudioRouting;
import com.zego.ve.Log;

@TargetApi(value=24)
public class RoutingChangedListener
implements AudioRouting.OnRoutingChangedListener {
    private static final String TAG = "device";

    private String getDeviceTypeStr(int n) {
        String string = "";
        switch (n) {
            case 1: {
                string = "BUILTIN_EARPIECE";
                break;
            }
            case 2: {
                string = "BUILTIN_SPEAKER";
                break;
            }
            case 3: {
                string = "WIRED_HEADSET";
                break;
            }
            case 4: {
                string = "WIRED_HEADPHONES";
                break;
            }
            case 5: {
                string = "LINE_ANALOG";
                break;
            }
            case 6: {
                string = "LINE_DIGITAL";
                break;
            }
            case 7: {
                string = "BLUETOOTH_SCO";
                break;
            }
            case 8: {
                string = "BLUETOOTH_A2DP";
                break;
            }
            case 9: {
                string = "HDMI";
                break;
            }
            case 10: {
                string = "HDMI_ARC";
                break;
            }
            case 11: {
                string = "USB_DEVICE";
                break;
            }
            case 12: {
                string = "USB_ACCESSORY";
                break;
            }
            case 13: {
                string = "DOCK";
                break;
            }
            case 14: {
                string = "FM";
                break;
            }
            case 15: {
                string = "BUILTIN_MIC";
                break;
            }
            case 16: {
                string = "FM_TUNER";
                break;
            }
            case 17: {
                string = "TV_TUNER";
                break;
            }
            case 18: {
                string = "TELEPHONY";
                break;
            }
            case 19: {
                string = "AUX_LINE";
                break;
            }
            case 20: {
                string = "IP";
                break;
            }
            case 21: {
                string = "BUS";
                break;
            }
            case 22: {
                string = "USB_HEADSET";
                break;
            }
            default: {
                string = "UNKNOWN";
            }
        }
        return string;
    }

    public void onRoutingChanged(AudioRouting audioRouting) {
        AudioDeviceInfo audioDeviceInfo;
        if (audioRouting != null && (audioDeviceInfo = audioRouting.getRoutedDevice()) != null) {
            Log.i(TAG, audioRouting + " on routing changed, routed device type: " + audioDeviceInfo.getType() + "(" + this.getDeviceTypeStr(audioDeviceInfo.getType()) + ")");
        }
    }
}

