/*
 * Decompiled with CFR 0.152.
 */
package im.crisp.client.external.data.message.content;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.gson.annotations.SerializedName;
import im.crisp.client.external.data.message.Message;
import im.crisp.client.external.data.message.content.Content;
import java.util.List;

public final class PickerContent
extends Content {
    @SerializedName(value="id")
    @NonNull
    private final String id;
    @SerializedName(value="text")
    @NonNull
    private final String text;
    @SerializedName(value="choices")
    @NonNull
    private final List<Choice> choices;
    @SerializedName(value="required")
    private final boolean required;

    private PickerContent(@NonNull Builder builder) {
        this.id = builder.id;
        this.text = builder.text;
        this.choices = builder.choices;
        this.required = builder.required;
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    @NonNull
    public String getText() {
        return this.text;
    }

    @NonNull
    public List<Choice> getChoices() {
        return this.choices;
    }

    public boolean isRequired() {
        return this.required;
    }

    @NonNull
    public String toString() {
        return "[" + (Object)((Object)Message.Type.PICKER) + ", {id: \"" + this.id + "\", text: \"" + this.text + "\", choices: " + this.choices + ", required: " + this.required + "}]";
    }

    public static final class Builder {
        @NonNull
        private final String id;
        @NonNull
        private final String text;
        @NonNull
        private final List<Choice> choices;
        private boolean required;

        public Builder(@NonNull String string2, @NonNull String string3, @NonNull List<Choice> list) {
            this.id = string2;
            this.text = string3;
            this.choices = list;
        }

        public Builder setRequired(boolean bl) {
            this.required = bl;
            return this;
        }

        public PickerContent build() {
            return new PickerContent(this);
        }
    }

    public static final class Choice {
        @SerializedName(value="value")
        @NonNull
        private final String value;
        @SerializedName(value="label")
        @NonNull
        private final String label;
        @SerializedName(value="selected")
        private boolean selected;
        @SerializedName(value="icon")
        @Nullable
        private final String icon;
        @SerializedName(value="action")
        @Nullable
        private final Action action;

        private Choice(@NonNull Builder builder) {
            this.value = builder.value;
            this.label = builder.label;
            this.selected = builder.selected;
            this.icon = builder.icon;
            this.action = builder.action;
        }

        @NonNull
        public String getValue() {
            return this.value;
        }

        @NonNull
        public String getLabel() {
            return this.label;
        }

        public boolean isSelected() {
            return this.selected;
        }

        @Nullable
        public String getIcon() {
            String string2 = this.icon;
            return string2 != null && !string2.isEmpty() ? this.icon : null;
        }

        @Nullable
        public Action getAction() {
            return this.action;
        }

        @NonNull
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder().append("{value: \"").append(((Choice)((Object)string3)).value).append("\", label: \"").append(((Choice)((Object)string3)).label).append("\", selected: ").append(((Choice)((Object)string3)).selected);
            String string2 = ((Choice)((Object)string3)).icon != null ? ", icon: \"" + ((Choice)((Object)string3)).icon + '\"' : "";
            stringBuilder = stringBuilder.append(string2);
            String string3 = ((Choice)((Object)string3)).action != null ? ", action: " + ((Choice)((Object)string3)).action : "";
            return stringBuilder.append(string3).append('}').toString();
        }

        public static final class Builder {
            @NonNull
            private final String value;
            @NonNull
            private final String label;
            private boolean selected;
            @Nullable
            private String icon;
            @Nullable
            private Action action;

            public Builder(@NonNull String string2, @NonNull String string3) {
                this.value = string2;
                this.label = string3;
            }

            public Builder setSelected(boolean bl) {
                this.selected = bl;
                return this;
            }

            public Builder setIcon(@Nullable String string2) {
                this.icon = string2;
                return this;
            }

            public Builder setAction(@Nullable Action action) {
                this.action = action;
                return this;
            }

            public Choice build() {
                return new Choice(this);
            }
        }

        public static final class Action {
            @SerializedName(value="type")
            @NonNull
            private final Type type;
            @SerializedName(value="target")
            @NonNull
            private final String target;

            public Action(@NonNull Type type, @NonNull String string2) {
                this.type = type;
                this.target = string2;
            }

            @NonNull
            public Type getType() {
                return this.type;
            }

            @NonNull
            public String getTarget() {
                return this.target;
            }

            @NonNull
            public String toString() {
                return "{type: \"" + (Object)((Object)this.type) + "\", target: \"" + this.target + "\"}";
            }

            public static enum Type {
                FRAME,
                LINK;

            }
        }
    }
}

