/*
 * Decompiled with CFR 0.152.
 */
package im.amomo.loading.indicator;

import android.animation.Animator;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.view.View;
import java.lang.ref.WeakReference;
import java.util.List;

public abstract class BaseIndicatorController {
    private WeakReference<View> mTarget;
    private List<Animator> mAnimators;

    public void setTarget(View target) {
        this.mTarget = new WeakReference<View>(target);
    }

    public View getTarget() {
        return this.mTarget != null ? (View)this.mTarget.get() : null;
    }

    public int getWidth() {
        return this.getTarget() != null ? this.getTarget().getWidth() : 0;
    }

    public int getHeight() {
        return this.getTarget() != null ? this.getTarget().getHeight() : 0;
    }

    public void postInvalidate() {
        if (this.getTarget() != null) {
            this.getTarget().postInvalidate();
        }
    }

    public abstract void draw(Canvas var1, Paint var2);

    public abstract List<Animator> createAnimation();

    public void initAnimation() {
        this.mAnimators = this.createAnimation();
    }

    public void setAnimationStatus(AnimStatus animStatus) {
        if (this.mAnimators == null) {
            return;
        }
        int count = this.mAnimators.size();
        block5: for (int i = 0; i < count; ++i) {
            Animator animator = this.mAnimators.get(i);
            boolean isRunning = animator.isRunning();
            switch (animStatus) {
                case START: {
                    if (isRunning) continue block5;
                    animator.start();
                    continue block5;
                }
                case END: {
                    if (!isRunning) continue block5;
                    animator.end();
                    continue block5;
                }
                case CANCEL: {
                    if (!isRunning) continue block5;
                    animator.cancel();
                }
            }
        }
    }

    public static enum AnimStatus {
        START,
        END,
        CANCEL;

    }
}

