/*
 * Decompiled with CFR 0.152.
 */
package im.amomo.loading.indicator;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import im.amomo.loading.indicator.BaseIndicatorController;
import java.util.ArrayList;
import java.util.List;

public class BallClipRotatePulseIndicator
extends BaseIndicatorController {
    float scaleFloat1;
    float scaleFloat2;
    float degrees;

    @Override
    public void draw(Canvas canvas, Paint paint) {
        float circleSpacing = 12.0f;
        float x = this.getWidth() / 2;
        float y = this.getHeight() / 2;
        canvas.save();
        canvas.translate(x, y);
        canvas.scale(this.scaleFloat1, this.scaleFloat1);
        paint.setStyle(Paint.Style.FILL);
        canvas.drawCircle(0.0f, 0.0f, x / 2.5f, paint);
        canvas.restore();
        canvas.translate(x, y);
        canvas.scale(this.scaleFloat2, this.scaleFloat2);
        canvas.rotate(this.degrees);
        paint.setStrokeWidth(3.0f);
        paint.setStyle(Paint.Style.STROKE);
        float[] startAngles = new float[]{225.0f, 45.0f};
        for (int i = 0; i < 2; ++i) {
            RectF rectF = new RectF(-x + circleSpacing, -y + circleSpacing, x - circleSpacing, y - circleSpacing);
            canvas.drawArc(rectF, startAngles[i], 90.0f, false, paint);
        }
    }

    @Override
    public List<Animator> createAnimation() {
        ValueAnimator scaleAnim = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.3f, 1.0f});
        scaleAnim.setDuration(1000L);
        scaleAnim.setRepeatCount(-1);
        scaleAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                BallClipRotatePulseIndicator.this.scaleFloat1 = ((Float)animation.getAnimatedValue()).floatValue();
                BallClipRotatePulseIndicator.this.postInvalidate();
            }
        });
        scaleAnim.start();
        ValueAnimator scaleAnim2 = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.6f, 1.0f});
        scaleAnim2.setDuration(1000L);
        scaleAnim2.setRepeatCount(-1);
        scaleAnim2.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                BallClipRotatePulseIndicator.this.scaleFloat2 = ((Float)animation.getAnimatedValue()).floatValue();
                BallClipRotatePulseIndicator.this.postInvalidate();
            }
        });
        scaleAnim2.start();
        ValueAnimator rotateAnim = ValueAnimator.ofFloat((float[])new float[]{0.0f, 180.0f, 360.0f});
        rotateAnim.setDuration(1000L);
        rotateAnim.setRepeatCount(-1);
        rotateAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                BallClipRotatePulseIndicator.this.degrees = ((Float)animation.getAnimatedValue()).floatValue();
                BallClipRotatePulseIndicator.this.postInvalidate();
            }
        });
        rotateAnim.start();
        ArrayList<Animator> animators = new ArrayList<Animator>();
        animators.add((Animator)scaleAnim);
        animators.add((Animator)scaleAnim2);
        animators.add((Animator)rotateAnim);
        return animators;
    }
}

