/*
 * Decompiled with CFR 0.152.
 */
package id.vouched.android.mlkit;

import android.content.Context;
import android.graphics.PointF;
import android.util.Log;
import androidx.annotation.NonNull;
import com.google.android.gms.tasks.Task;
import com.google.mlkit.vision.common.InputImage;
import com.google.mlkit.vision.face.Face;
import com.google.mlkit.vision.face.FaceDetection;
import com.google.mlkit.vision.face.FaceDetector;
import com.google.mlkit.vision.face.FaceDetectorOptions;
import com.google.mlkit.vision.face.FaceLandmark;
import id.vouched.android.mlkit.FacesFound;
import id.vouched.android.mlkit.GraphicOverlay;
import id.vouched.android.mlkit.VisionProcessorBase;
import java.util.List;
import java.util.Locale;
import java9.util.function.Consumer;

public class FaceDetectorProcessor
extends VisionProcessorBase<List<Face>> {
    private static final String TAG = "FaceDetectorProcessor";
    private final FaceDetector detector;
    private final Consumer<FacesFound> facesFoundFn;

    public FaceDetectorProcessor(Context context) {
        this(context, new FaceDetectorOptions.Builder().setClassificationMode(2).enableTracking().build(), null);
    }

    public FaceDetectorProcessor(Context context, FaceDetectorOptions options, Consumer<FacesFound> facesFoundFn) {
        super(context);
        Log.v((String)"LogTagForTest", (String)("Face detector options: " + options));
        this.detector = FaceDetection.getClient((FaceDetectorOptions)options);
        this.facesFoundFn = facesFoundFn;
    }

    @Override
    public void stop() {
        super.stop();
        this.detector.close();
    }

    @Override
    protected Task<List<Face>> detectInImage(InputImage image) {
        Task task = this.detector.process(image);
        return task;
    }

    @Override
    protected void onSuccess(@NonNull InputImage image, @NonNull List<Face> faces, @NonNull GraphicOverlay graphicOverlay, int fps) {
        this.facesFoundFn.accept((Object)new FacesFound(image, faces, graphicOverlay, fps));
    }

    private static void logExtrasForTesting(Face face) {
        if (face != null) {
            Log.v((String)"LogTagForTest", (String)("face bounding box: " + face.getBoundingBox().flattenToString()));
            Log.v((String)"LogTagForTest", (String)("face Euler Angle X: " + face.getHeadEulerAngleX()));
            Log.v((String)"LogTagForTest", (String)("face Euler Angle Y: " + face.getHeadEulerAngleY()));
            Log.v((String)"LogTagForTest", (String)("face Euler Angle Z: " + face.getHeadEulerAngleZ()));
            int[] landMarkTypes = new int[]{0, 11, 5, 10, 4, 9, 3, 7, 1, 6};
            String[] landMarkTypesStrings = new String[]{"MOUTH_BOTTOM", "MOUTH_RIGHT", "MOUTH_LEFT", "RIGHT_EYE", "LEFT_EYE", "RIGHT_EAR", "LEFT_EAR", "RIGHT_CHEEK", "LEFT_CHEEK", "NOSE_BASE"};
            for (int i = 0; i < landMarkTypes.length; ++i) {
                FaceLandmark landmark = face.getLandmark(landMarkTypes[i]);
                if (landmark == null) {
                    Log.v((String)"LogTagForTest", (String)("No landmark of type: " + landMarkTypesStrings[i] + " has been detected"));
                    continue;
                }
                PointF landmarkPosition = landmark.getPosition();
                String landmarkPositionStr = String.format(Locale.US, "x: %f , y: %f", Float.valueOf(landmarkPosition.x), Float.valueOf(landmarkPosition.y));
                Log.v((String)"LogTagForTest", (String)("Position for face landmark: " + landMarkTypesStrings[i] + " is :" + landmarkPositionStr));
            }
            Log.v((String)"LogTagForTest", (String)("face left eye open probability: " + face.getLeftEyeOpenProbability()));
            Log.v((String)"LogTagForTest", (String)("face right eye open probability: " + face.getRightEyeOpenProbability()));
            Log.v((String)"LogTagForTest", (String)("face smiling probability: " + face.getSmilingProbability()));
            Log.v((String)"LogTagForTest", (String)("face tracking id: " + face.getTrackingId()));
        }
    }

    @Override
    protected void onFailure(@NonNull Exception e) {
        Log.e((String)TAG, (String)("Face detection failed " + e));
    }
}

