/*
 * Decompiled with CFR 0.152.
 */
package id.vouched.android.liveness.impl;

import com.google.mlkit.vision.face.Face;
import id.vouched.android.box.DetectedBox;
import id.vouched.android.liveness.Liveness;
import id.vouched.android.liveness.LivenessStep;
import id.vouched.android.liveness.impl.LivenessUtility;
import java.util.Stack;

public class MouthMovement
implements Liveness {
    private Stack<MouthState> mouthStates = new Stack();
    private MouthState[] previousMouthStates;

    public MouthMovement() {
        this.mouthStates.push(MouthState.CLOSED);
        this.mouthStates.push(MouthState.OPEN);
        this.previousMouthStates = new MouthState[]{MouthState.CLOSED, MouthState.OPEN, MouthState.CLOSED};
    }

    @Override
    public void resetValues() {
        this.mouthStates = new Stack();
        this.mouthStates.push(MouthState.CLOSED);
        this.mouthStates.push(MouthState.OPEN);
        this.previousMouthStates[0] = MouthState.CLOSED;
        this.previousMouthStates[1] = MouthState.OPEN;
        this.previousMouthStates[2] = MouthState.CLOSED;
    }

    @Override
    public LivenessStep execute(DetectedBox box, Face face, float fps) {
        if (this.mouthStates.isEmpty()) {
            return LivenessStep.COMPLETE;
        }
        MouthState currentState = LivenessUtility.isMouthOpened(face, 1.2f) ? MouthState.OPEN : MouthState.CLOSED;
        this.updatePreviousMouthState(currentState);
        MouthState needed = this.mouthStates.peek();
        if (currentState == needed) {
            if (this.consecutiveMouthStates()) {
                this.mouthStates.pop();
            }
            if (this.mouthStates.isEmpty()) {
                return LivenessStep.COMPLETE;
            }
            return this.mouthStates.peek() == MouthState.OPEN ? LivenessStep.OPEN_MOUTH : LivenessStep.CLOSE_MOUTH;
        }
        return this.mouthStates.peek() == MouthState.OPEN ? LivenessStep.OPEN_MOUTH : LivenessStep.CLOSE_MOUTH;
    }

    private void updatePreviousMouthState(MouthState mouthState) {
        this.previousMouthStates[0] = this.previousMouthStates[1];
        this.previousMouthStates[1] = this.previousMouthStates[2];
        this.previousMouthStates[2] = mouthState;
    }

    private boolean consecutiveMouthStates() {
        return this.previousMouthStates[0] == this.previousMouthStates[1] && this.previousMouthStates[1] == this.previousMouthStates[2];
    }

    private static enum MouthState {
        CLOSED,
        OPEN;

    }
}

