/*
 * Decompiled with CFR 0.152.
 */
package id.vouched.android.event;

import android.util.Log;
import id.vouched.android.event.AmplitudeAPI;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONArray;
import org.json.JSONObject;

public class AmplitudeAPIImpl
implements AmplitudeAPI {
    private static final String AMPLITUDE_API_KEY = "7e5cf6cfe9500d67d170deca9d5369a0";
    private final transient ExecutorService executorService = Executors.newSingleThreadExecutor();
    private static AmplitudeAPIImpl instance;

    public static AmplitudeAPIImpl getInstance() {
        return AmplitudeAPIImpl.getInstance(false);
    }

    public static AmplitudeAPIImpl getInstance(boolean forceNew) {
        if (instance == null || forceNew) {
            instance = new AmplitudeAPIImpl();
        }
        return instance;
    }

    AmplitudeAPIImpl() {
    }

    private void postException(Exception e) {
        Log.e((String)AmplitudeAPIImpl.class.getName(), (String)e.getLocalizedMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean postAmplitude(JSONArray events) {
        if (events.length() == 0) {
            return false;
        }
        boolean result = false;
        InputStream is = null;
        try {
            JSONObject requestData = new JSONObject();
            requestData.put("api_key", (Object)AMPLITUDE_API_KEY);
            requestData.put("events", (Object)events);
            String requestBody = requestData.toString();
            URL url = new URL("https://api2.amplitude.com/2/httpapi");
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("Content-Length", Integer.toString(requestBody.getBytes().length));
            con.setRequestProperty("Content-Type", "application/json");
            con.setDoOutput(true);
            DataOutputStream wr = new DataOutputStream(con.getOutputStream());
            wr.writeBytes(requestBody);
            wr.close();
            try {
                is = con.getInputStream();
            }
            catch (IOException ioe) {
                this.postException(ioe);
                int statusCode = con.getResponseCode();
                if (statusCode != 200) {
                    is = con.getErrorStream();
                }
            }
            finally {
                if (con.getResponseCode() == 200) {
                    result = true;
                }
            }
        }
        catch (Exception e) {
            this.postException(e);
            e.printStackTrace();
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                this.postException(e);
            }
        }
        return result;
    }
}

