/*
 * Decompiled with CFR 0.152.
 */
package id.vouched.android.env;

import android.graphics.Bitmap;
import android.text.TextUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Size
implements Comparable<Size>,
Serializable {
    public static final long serialVersionUID = 7689808733290872361L;
    public final int width;
    public final int height;

    public Size(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public Size(Bitmap bmp) {
        this.width = bmp.getWidth();
        this.height = bmp.getHeight();
    }

    public static Size getRotatedSize(Size size, int rotation) {
        if (rotation % 180 != 0) {
            return new Size(size.height, size.width);
        }
        return size;
    }

    public static Size parseFromString(String sizeString) {
        if (TextUtils.isEmpty((CharSequence)sizeString)) {
            return null;
        }
        String[] components = (sizeString = sizeString.trim()).split("x");
        if (components.length == 2) {
            try {
                int width = Integer.parseInt(components[0]);
                int height = Integer.parseInt(components[1]);
                return new Size(width, height);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    public static List<Size> sizeStringToList(String sizes) {
        ArrayList<Size> sizeList = new ArrayList<Size>();
        if (sizes != null) {
            String[] pairs;
            for (String pair : pairs = sizes.split(",")) {
                Size size = Size.parseFromString(pair);
                if (size == null) continue;
                sizeList.add(size);
            }
        }
        return sizeList;
    }

    public static String sizeListToString(List<Size> sizes) {
        String sizesString = "";
        if (sizes != null && sizes.size() > 0) {
            sizesString = sizes.get(0).toString();
            for (int i = 1; i < sizes.size(); ++i) {
                sizesString = sizesString + "," + sizes.get(i).toString();
            }
        }
        return sizesString;
    }

    public static final String dimensionsAsString(int width, int height) {
        return width + "x" + height;
    }

    public final float aspectRatio() {
        return (float)this.width / (float)this.height;
    }

    @Override
    public int compareTo(Size other) {
        return this.width * this.height - other.width * other.height;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof Size)) {
            return false;
        }
        Size otherSize = (Size)other;
        return this.width == otherSize.width && this.height == otherSize.height;
    }

    public int hashCode() {
        return this.width * 32713 + this.height;
    }

    public String toString() {
        return Size.dimensionsAsString(this.width, this.height);
    }
}

