/*
 * Decompiled with CFR 0.152.
 */
package id.vouched.android.customview;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import id.vouched.android.customview.ResultsView;
import id.vouched.android.tflite.Classifier;
import java.util.List;

public class RecognitionScoreView
extends View
implements ResultsView {
    private static final float TEXT_SIZE_DIP = 14.0f;
    private final float textSizePx = TypedValue.applyDimension((int)1, (float)14.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
    private final Paint fgPaint = new Paint();
    private final Paint bgPaint;
    private List<Classifier.Recognition> results;

    public RecognitionScoreView(Context context, AttributeSet set) {
        super(context, set);
        this.fgPaint.setTextSize(this.textSizePx);
        this.bgPaint = new Paint();
        this.bgPaint.setColor(-868055564);
    }

    @Override
    public void setResults(List<Classifier.Recognition> results) {
        this.results = results;
        this.postInvalidate();
    }

    public void onDraw(Canvas canvas) {
        int x = 10;
        int y = (int)(this.fgPaint.getTextSize() * 1.5f);
        canvas.drawPaint(this.bgPaint);
        if (this.results != null) {
            for (Classifier.Recognition recog : this.results) {
                canvas.drawText(recog.getTitle() + ": " + recog.getConfidence(), 10.0f, (float)y, this.fgPaint);
                y += (int)(this.fgPaint.getTextSize() * 1.5f);
            }
        }
    }
}

