/*
 * Decompiled with CFR 0.152.
 */
package id.vouched.android.box;

import android.graphics.Bitmap;
import android.graphics.PointF;
import android.graphics.RectF;
import com.google.mlkit.vision.face.FaceLandmark;
import id.vouched.android.box.Boundary;
import id.vouched.android.box.BoxStats;
import id.vouched.android.box.DetectedBox;
import id.vouched.android.box.PositionsTotal;
import java.util.LinkedList;
import java.util.List;
import java9.util.stream.Collectors;
import java9.util.stream.StreamSupport;

public class BoxUtility {
    private static final float STEADY_FPS_MIN = 5.0f;
    private static final float STEADY_FPS_MAX = 20.0f;
    private static final float STEADY_THRESHOLD_TIGHT_POS = 0.02f;
    private static final float STEADY_THRESHOLD_POS = 0.03f;
    private static final float STEADY_THRESHOLD_POS_FPS = 10.0f;

    public static boolean foundSteadyBox(List<DetectedBox> boxes, float fps) {
        int steadyNum = BoxUtility.calcSteadyNum(fps);
        int size = boxes.size();
        if (size < steadyNum) {
            return false;
        }
        PositionsTotal positionsTotal = (PositionsTotal)StreamSupport.stream(boxes).reduce((Object)new PositionsTotal(), (total, box) -> {
            total.x += box.x + box.width / 2.0f;
            total.y += box.y + box.height / 2.0f;
            return total;
        }, (total1, total2) -> total1);
        float avgPosX = positionsTotal.x / (float)size;
        float avgPosY = positionsTotal.y / (float)size;
        float steadyPos = BoxUtility.toSteadyPos(fps);
        int[] currentIndex = new int[]{0};
        List unsteadyBoxes = (List)StreamSupport.stream(boxes).map(box -> {
            float middleX = box.x + box.width / 2.0f;
            float middleY = box.y + box.height / 2.0f;
            float percentX = middleX > avgPosX ? avgPosX / middleX : middleX / avgPosX;
            float percentY = middleY > avgPosY ? avgPosY / middleY : middleY / avgPosY;
            boolean notPassX = 1.0f - percentX > steadyPos;
            boolean notPassY = 1.0f - percentY > steadyPos;
            BoxStats boxStat = new BoxStats(middleX, middleY, percentX, percentY, notPassX, notPassY, currentIndex[0]);
            currentIndex[0] = currentIndex[0] + 1;
            return boxStat;
        }).filter(boxStats -> boxStats.notPassX || boxStats.notPassY).collect(Collectors.toList());
        long theCount = unsteadyBoxes.size();
        if (theCount == 0L) {
            return true;
        }
        if ((float)steadyNum > 5.0f && theCount == 1L) {
            int unsteadyBoxIndex = ((BoxStats)unsteadyBoxes.get((int)0)).index;
            return unsteadyBoxIndex != size - 1 && unsteadyBoxIndex != size - 2;
        }
        return false;
    }

    public static DetectedBox toDetectedBox(FaceLandmark leftEye, FaceLandmark rightEye, FaceLandmark nose, int height, int width) {
        Boundary boundary = new Boundary(Float.NaN, Float.NaN, Float.NaN, Float.NaN);
        boundary = BoxUtility.toBoundaryFromPoints(leftEye, boundary, height, width);
        boundary = BoxUtility.toBoundaryFromPoints(rightEye, boundary, height, width);
        boundary = BoxUtility.toBoundaryFromPoints(nose, boundary, height, width);
        if (!(Float.isNaN(boundary.left) || Float.isNaN(boundary.right) || Float.isNaN(boundary.top) || Float.isNaN(boundary.bottom))) {
            float boxHeight = boundary.bottom - boundary.top;
            float boxWidth = boundary.right - boundary.left;
            return new DetectedBox(boundary.left, boundary.top, boxHeight, boxWidth);
        }
        return null;
    }

    public static DetectedBox toDetectedBox(Bitmap bitmap, RectF location) {
        float x = location.right / (float)bitmap.getWidth();
        float y = location.top / (float)bitmap.getHeight();
        float height = location.height() / (float)bitmap.getHeight();
        float width = location.width() / (float)bitmap.getWidth();
        return new DetectedBox(x, y, height, width);
    }

    public static void addBoxes(LinkedList<DetectedBox> boxes, DetectedBox box, float fps) {
        int steadyNum = BoxUtility.calcSteadyNum(fps);
        if (boxes.size() >= steadyNum) {
            boxes.removeFirst();
        }
        boxes.add(box);
    }

    public static boolean isBigBox(DetectedBox box, float threshold) {
        if (box == null) {
            return false;
        }
        return BoxUtility.toBigBox(box, threshold) != null;
    }

    private static DetectedBox toBigBox(DetectedBox box, float threshold) {
        return BoxUtility.toBigBox(box, threshold, null);
    }

    private static DetectedBox toBigBox(DetectedBox box, float threshold, DetectedBox currentBigBox) {
        float size = box.width * box.height;
        if (size < threshold) {
            return currentBigBox;
        }
        if (currentBigBox != null && currentBigBox.width * currentBigBox.height > size) {
            return currentBigBox;
        }
        if (box.x < 0.0f || box.y < 0.0f || box.x > 1.0f || box.y > 1.0f) {
            return currentBigBox;
        }
        return box;
    }

    public static boolean isSmallBox(DetectedBox box, float threshold) {
        if (box == null) {
            return false;
        }
        return BoxUtility.toSmallBox(box, threshold) != null;
    }

    private static DetectedBox toSmallBox(DetectedBox box, float threshold) {
        return BoxUtility.toSmallBox(box, threshold, null);
    }

    private static DetectedBox toSmallBox(DetectedBox box, float threshold, DetectedBox currentBigBox) {
        float size = box.width * box.height;
        if (size > threshold) {
            return currentBigBox;
        }
        if (currentBigBox != null && currentBigBox.width * currentBigBox.height < size) {
            return currentBigBox;
        }
        if (box.x < 0.0f || box.y < 0.0f || box.x > 1.0f || box.y > 1.0f) {
            return currentBigBox;
        }
        return box;
    }

    private static Boundary toBoundaryFromPoints(FaceLandmark landmark, Boundary currentBoundary, int height, int width) {
        if (landmark == null) {
            return currentBoundary;
        }
        PointF point = landmark.getPosition();
        float x = point.x / (float)width;
        float y = point.y / (float)height;
        if (Float.isNaN(currentBoundary.left) || x < currentBoundary.left) {
            currentBoundary.left = x;
        }
        if (Float.isNaN(currentBoundary.top) || y < currentBoundary.top) {
            currentBoundary.top = y;
        }
        if (Float.isNaN(currentBoundary.bottom) || y > currentBoundary.bottom) {
            currentBoundary.bottom = y;
        }
        if (Float.isNaN(currentBoundary.right) || x > currentBoundary.right) {
            currentBoundary.right = x;
        }
        return currentBoundary;
    }

    private static float toSteadyPos(float fps) {
        return fps > 10.0f ? 0.03f : 0.02f;
    }

    private static int calcSteadyNum(float fps) {
        float steadyNum = Math.max(fps, 5.0f);
        steadyNum = Math.min(steadyNum, 20.0f);
        return (int)steadyNum;
    }
}

