/*
 * Decompiled with CFR 0.152.
 */
package id.vouched.android;

import id.vouched.android.RetryableOptions;
import id.vouched.android.kt.event.SessionEventManager;
import id.vouched.android.model.Confidence;
import id.vouched.android.model.Insight;
import id.vouched.android.model.Job;
import id.vouched.android.model.JobError;
import id.vouched.android.model.RetryableError;
import id.vouched.android.model.Signal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VouchedUtils {
    private static final Map<String, Insight> insightMap = new HashMap<String, Insight>();

    public static List<RetryableError> extractRetryableIdErrors(Job job) {
        return VouchedUtils.extractRetryableIdErrors(job, RetryableOptions.defaultOptions());
    }

    public static List<RetryableError> extractRetryableIdErrors(Job job, RetryableOptions options) {
        ArrayList<RetryableError> retryableErrors = new ArrayList<RetryableError>();
        if (job == null || job.getResult() == null || job.getResult().getConfidences() == null) {
            return retryableErrors;
        }
        if (job.getErrors() == null || job.getErrors().length == 0) {
            return retryableErrors;
        }
        if (!VouchedUtils.hasError("InvalidIdPhotoError", job.getErrors())) {
            return retryableErrors;
        }
        Confidence confidence = job.getResult().getConfidences();
        if (confidence.getId() > options.getRecognizeIDThreshold()) {
            if (confidence.getIdQuality() < options.getQualityThreshold()) {
                retryableErrors.add(RetryableError.BlurryIdPhotoError);
            }
            if (confidence.getIdGlareQuality() < options.getGlareQualityThreshold()) {
                retryableErrors.add(RetryableError.GlareIdPhotoError);
            }
        }
        retryableErrors.add(RetryableError.InvalidIdPhotoError);
        return retryableErrors;
    }

    public static List<RetryableError> extractRetryableFaceErrors(Job job) {
        ArrayList<RetryableError> retryableErrors = new ArrayList<RetryableError>();
        if (job == null || job.getResult() == null || job.getResult().getConfidences() == null) {
            return retryableErrors;
        }
        if (VouchedUtils.hasError("InvalidUserPhotoError", job.getErrors())) {
            retryableErrors.add(RetryableError.InvalidUserPhotoError);
        }
        return retryableErrors;
    }

    public static List<Insight> extractInsights(Job job) {
        ArrayList<Insight> insights = new ArrayList<Insight>();
        if (job != null && job.getErrors() != null && VouchedUtils.hasError("InvalidIdPhotoError", job.getErrors())) {
            insights.add(Insight.ID_PHOTO);
        } else if (job != null && job.getResult() != null && job.getResult().getConfidences() != null) {
            Signal[] signals;
            for (Signal signal : signals = job.getSignals()) {
                if (!signal.getProperty().equals("public")) continue;
                insights.add(VouchedUtils.getInsightFromSignal(signal));
            }
        }
        return insights;
    }

    private static Insight getInsightFromSignal(Signal signal) {
        Insight insight = insightMap.get(signal.getType());
        if (insight == Insight.FACE) {
            if (signal.getCategory().equals("id")) {
                insight = Insight.ID_PHOTO;
            }
        } else if (insight == null) {
            SessionEventManager.Companion.getInstance().postException(new Exception("Unknown Signal: " + signal.getType()));
            insight = Insight.UNKNOWN;
        }
        return insight;
    }

    private static boolean hasError(String errorType, JobError[] jobErrors) {
        if (jobErrors == null || jobErrors.length == 0) {
            return false;
        }
        for (JobError error : jobErrors) {
            if (!error.getType().equals(errorType)) continue;
            return true;
        }
        return false;
    }

    static {
        insightMap.put("quality", Insight.QUALITY);
        insightMap.put("brightness", Insight.BRIGHTNESS);
        insightMap.put("nonglare", Insight.NON_GLARE);
        insightMap.put("glasses", Insight.GLASSES);
        insightMap.put("face", Insight.FACE);
        insightMap.put("id.face", Insight.ID_PHOTO);
    }
}

