/*
 * Decompiled with CFR 0.152.
 */
package id.vouched.android;

import android.util.Log;

public class VouchedLogger {
    private final Mode logMode;
    private static VouchedLogger instance = null;
    private static String TAG = "id.vouched";

    public VouchedLogger(Mode logMode) {
        this.logMode = logMode;
    }

    public static VouchedLogger getInstance() {
        if (instance == null) {
            instance = new VouchedLogger(Mode.OFF);
        }
        return instance;
    }

    public static void configure(Mode level) {
        instance = new VouchedLogger(level);
    }

    public void error(String message) {
        if (this.logMode == Mode.ON) {
            Log.e((String)TAG, (String)message);
        }
    }

    public void info(String message) {
        if (this.logMode == Mode.ON) {
            Log.i((String)TAG, (String)message);
        }
    }

    public void debug(String message) {
        if (this.logMode == Mode.ON) {
            Log.d((String)TAG, (String)message);
        }
    }

    public static enum Mode {
        ON,
        OFF;

    }
}

