/*
 * Decompiled with CFR 0.152.
 */
package id.vouched.android;

import id.vouched.android.TimeoutListener;
import id.vouched.android.event.SessionEventType;
import id.vouched.android.kt.event.SessionEventManager;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executor;

class VouchedCameraHelperTimeout {
    private final Long milliseconds;
    private final TimeoutListener listener;
    private boolean timeoutExpired = false;
    private Timer timer;
    private Executor mainExecutor;

    VouchedCameraHelperTimeout(Long milliseconds, TimeoutListener listener) {
        this.milliseconds = milliseconds;
        this.listener = listener;
    }

    public void setMainExecutor(Executor mainExecutor) {
        this.mainExecutor = mainExecutor;
    }

    public boolean timeoutIsExpired() {
        return this.timeoutExpired;
    }

    public void tryToResume() {
        if (this.timeoutExpired) {
            return;
        }
        this.stop();
        this.timer = new Timer();
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                VouchedCameraHelperTimeout.this.mainExecutor.execute(() -> {
                    VouchedCameraHelperTimeout.this.timeoutExpired = true;
                    VouchedCameraHelperTimeout.this.listener.onTimeout();
                    SessionEventManager.Companion.getInstance().sendEvent(new SessionEventType.CardDetectionTimeout(VouchedCameraHelperTimeout.this.milliseconds));
                });
            }
        }, this.milliseconds);
    }

    public void stop() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = null;
    }

    public void restart() {
        this.timeoutExpired = false;
        this.tryToResume();
    }
}

