/*
 * Decompiled with CFR 0.152.
 */
package id.vouched.android;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.YuvImage;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.SystemClock;
import android.util.Size;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.camera.core.Camera;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.ImageAnalysis;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.ImageCaptureException;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.Preview;
import androidx.camera.core.UseCase;
import androidx.camera.lifecycle.ProcessCameraProvider;
import androidx.camera.view.PreviewView;
import androidx.lifecycle.LifecycleOwner;
import com.google.common.util.concurrent.ListenableFuture;
import id.vouched.android.BarcodeDetect;
import id.vouched.android.CardDetect;
import id.vouched.android.CardDetectOptions;
import id.vouched.android.CardDetectResult;
import id.vouched.android.FaceDetect;
import id.vouched.android.FaceDetectOptions;
import id.vouched.android.IdDetectMgr;
import id.vouched.android.ImageCaptureListener;
import id.vouched.android.Instruction;
import id.vouched.android.Step;
import id.vouched.android.VouchedCameraHelperOptions;
import id.vouched.android.VouchedCameraHelperTimeout;
import id.vouched.android.VouchedLogger;
import id.vouched.android.event.SessionEventType;
import id.vouched.android.exception.VouchedAssetsMissingException;
import id.vouched.android.exception.VouchedCameraHelperException;
import id.vouched.android.kt.event.SessionEventManager;
import id.vouched.android.model.JobResult;
import id.vouched.android.utils.BitmapUtils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;

public class VouchedCameraHelper {
    private static final Size DESIRED_PREVIEW_SIZE = new Size(720, 1280);
    private static final Size BARCODE_DESIRED_PREVIEW_SIZE = new Size(1536, 2048);
    private static final int MAX_ID_PHOTO_SIZE_IN_PIXELS = 4000000;
    private final Context context;
    private final LifecycleOwner lifecycleOwner;
    private Mode mode;
    private final PreviewView previewView;
    private final ImageView imageView;
    private final boolean flashDisabled;
    private final CardDetectOptions cardDetectOptions;
    private final CardDetect.OnDetectResultListener cardDetectResultListener;
    private CardDetect cardDetect;
    private final BarcodeDetect.OnBarcodeResultListener barcodeDetectResultListener;
    private BarcodeDetect barcodeDetect;
    private final FaceDetectOptions faceDetectOptions;
    private final FaceDetect.OnDetectResultListener faceDetectResultListener;
    private FaceDetect faceDetect;
    private final ListenableFuture<ProcessCameraProvider> cameraProviderFuture;
    private CameraSelector cameraSelector;
    private ProcessCameraProvider cameraProvider;
    private Preview previewUseCase;
    private ImageAnalysis analysisUseCase;
    private ImageCapture captureUseCase;
    private Handler handler;
    private HandlerThread handlerThread;
    private final Executor mainExecutor;
    private AtomicBoolean isPaused;
    private AtomicBoolean isCapturing;
    private List<CardDetectResult> resultsWhileCapturing;
    private IdDetectMgr idModeMgr;
    private VouchedCameraHelperTimeout timeoutHelper;

    public VouchedCameraHelper(Context context, LifecycleOwner lifecycleOwner, Executor mainExecutor, PreviewView previewView, Mode mode, VouchedCameraHelperOptions cameraHelperOptions) throws VouchedAssetsMissingException {
        this.context = context;
        this.lifecycleOwner = lifecycleOwner;
        this.mode = mode;
        this.previewView = previewView;
        this.imageView = cameraHelperOptions.getImageView();
        this.flashDisabled = cameraHelperOptions.isCameraFlashDisabled();
        this.cardDetectOptions = cameraHelperOptions.getCardDetectOptions();
        this.cardDetectResultListener = cameraHelperOptions.getCardDetectResultListener();
        this.barcodeDetectResultListener = cameraHelperOptions.getBarcodeDetectResultListener();
        this.faceDetectOptions = cameraHelperOptions.getFaceDetectOptions();
        this.faceDetectResultListener = cameraHelperOptions.getFaceDetectResultListener();
        if (cameraHelperOptions.getVouchedCameraHelperTimeout() != null) {
            this.timeoutHelper = cameraHelperOptions.getVouchedCameraHelperTimeout();
            this.timeoutHelper.setMainExecutor(mainExecutor);
        }
        this.mainExecutor = mainExecutor;
        this.isPaused = new AtomicBoolean();
        this.isPaused.set(true);
        this.isCapturing = new AtomicBoolean();
        this.isCapturing.set(false);
        this.resultsWhileCapturing = new ArrayList<CardDetectResult>();
        this.cameraProviderFuture = ProcessCameraProvider.getInstance((Context)context);
        this.idModeMgr = new IdDetectMgr();
        SessionEventManager.Companion.getInstance().sendEvent(new SessionEventType.StartingCameraHelper(mode.name()));
        this.setFieldsForMode();
    }

    public Mode getCurrentMode() {
        return this.idModeMgr.currentMode;
    }

    public void updateDetectionModes(JobResult result) {
        if (this.cardDetectOptions.isEnhanceInfoExtraction()) {
            this.idModeMgr.updateIdDetectionModes(result);
        }
    }

    public Mode getNextMode() {
        return this.idModeMgr.nextMode();
    }

    public void switchMode(Mode mode) throws VouchedAssetsMissingException {
        this.onPause();
        this.mode = mode;
        SessionEventManager.Companion.getInstance().sendEvent(new SessionEventType.CameraHelperModeChanged(mode.name()));
        this.setFieldsForMode();
    }

    public void onResume() throws VouchedCameraHelperException {
        this.validateMode();
        this.isPaused.set(false);
        this.isCapturing.set(false);
        this.resultsWhileCapturing.clear();
        try {
            if (this.cameraProvider == null) {
                this.cameraProvider = (ProcessCameraProvider)this.cameraProviderFuture.get();
            }
            if (this.cardDetect != null) {
                this.cardDetect.reset();
            }
            if (this.faceDetect != null) {
                this.faceDetect.reset();
            }
            if (this.imageView != null) {
                this.imageView.setImageBitmap(null);
            }
            this.createHandler();
            this.bindAllCameraUseCases();
            if (this.timeoutHelper != null) {
                this.timeoutHelper.tryToResume();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
    }

    public void onPause() {
        this.isPaused.set(true);
        if (this.cameraProvider != null) {
            this.cameraProvider.unbindAll();
        }
        if (this.cardDetect != null) {
            this.cardDetect.reset();
        }
        if (this.faceDetect != null) {
            this.faceDetect.reset();
        }
        this.destroyHandler();
        if (this.timeoutHelper != null) {
            this.timeoutHelper.stop();
        }
    }

    private void setFieldsForMode() throws VouchedAssetsMissingException {
        if (Mode.ID.equals((Object)this.mode)) {
            this.cardDetect = new CardDetect(this.context.getAssets(), this.cardDetectOptions, this.getHelperCardListener());
            this.cameraSelector = new CameraSelector.Builder().requireLensFacing(1).build();
        } else if (Mode.ID_BACK.equals((Object)this.mode)) {
            CardDetectOptions backsideOptions = CardDetectOptions.defaultOptions();
            this.cardDetect = new CardDetect(this.context.getAssets(), backsideOptions, this.getHelperCardListener());
            this.cameraSelector = new CameraSelector.Builder().requireLensFacing(1).build();
        } else if (Mode.BARCODE.equals((Object)this.mode)) {
            this.barcodeDetect = new BarcodeDetect(this.context.getAssets(), barcodeResult -> this.mainExecutor.execute(() -> this.barcodeDetectResultListener.onBarcodeResult(barcodeResult)));
            this.cameraSelector = new CameraSelector.Builder().requireLensFacing(1).build();
        } else if (Mode.FACE.equals((Object)this.mode)) {
            this.faceDetect = new FaceDetect(this.context, this.faceDetectOptions, this.faceDetectResultListener);
            this.cameraSelector = new CameraSelector.Builder().requireLensFacing(0).build();
        } else {
            VouchedLogger.getInstance().error(String.format("Unsupported mode: {}", this.mode.toString()));
        }
    }

    private CardDetect.OnDetectResultListener getHelperCardListener() {
        return new CardDetect.OnDetectResultListener(){

            @Override
            public void onCardDetectResult(final CardDetectResult cardDetectResult) {
                VouchedCameraHelper.this.mainExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (!VouchedCameraHelper.this.isCapturing.get() && Step.POSTABLE.equals((Object)cardDetectResult.getStep())) {
                            final boolean enhancedInfoFound = cardDetectResult.getBarcodeText() != null && !cardDetectResult.getBarcodeText().isEmpty();
                            try {
                                if (VouchedCameraHelper.this.captureUseCase != null) {
                                    VouchedCameraHelper.this.isCapturing.set(true);
                                    final long snapshotTime = SystemClock.elapsedRealtime();
                                    Timer timer = new Timer();
                                    timer.schedule(new TimerTask(){

                                        @Override
                                        public void run() {
                                            VouchedCameraHelper.this.mainExecutor.execute(new Runnable(){

                                                @Override
                                                public void run() {
                                                    if (VouchedCameraHelper.this.imageView != null) {
                                                        Bitmap rb = Bitmap.createScaledBitmap((Bitmap)cardDetectResult.getImageBitmap(), (int)VouchedCameraHelper.this.imageView.getWidth(), (int)VouchedCameraHelper.this.imageView.getHeight(), (boolean)true);
                                                        VouchedCameraHelper.this.imageView.setImageBitmap(rb);
                                                    }
                                                }
                                            });
                                        }
                                    }, 300L);
                                    VouchedCameraHelper.this.captureUseCase.takePicture(VouchedCameraHelper.this.mainExecutor, new ImageCapture.OnImageCapturedCallback(){

                                        /*
                                         * WARNING - Removed try catching itself - possible behaviour change.
                                         */
                                        public void onCaptureSuccess(@NonNull ImageProxy imageProxy) {
                                            long capturedTime = 0L;
                                            long manipulationTime = 0L;
                                            Exception handledException = null;
                                            boolean usedFallbackImage = false;
                                            try {
                                                VouchedCameraHelper.this.onPause();
                                                capturedTime = SystemClock.elapsedRealtime() - snapshotTime;
                                                VouchedLogger.getInstance().info("captureTime: " + capturedTime);
                                                Bitmap bitmap = VouchedCameraHelper.this.toBitmap(imageProxy);
                                                RectF location = cardDetectResult.getLocation();
                                                Bitmap croppedBitmap = cardDetectResult.getImageBitmap();
                                                Bitmap downscaledBitmap = BitmapUtils.downsizeIfNeeded(croppedBitmap, 4000000);
                                                CardDetectResult cardDetectHr = new CardDetectResult(cardDetectResult.getStep(), cardDetectResult.getInstruction(), BitmapUtils.toBase64(downscaledBitmap), cardDetectResult.getDistanceImage(), cardDetectResult.getLocation(), cardDetectResult.getImageBitmap(), cardDetectResult.getBarcodeText());
                                                manipulationTime = SystemClock.elapsedRealtime() - capturedTime;
                                                VouchedLogger.getInstance().info("manipulationTime: " + manipulationTime);
                                                boolean allPostable = true;
                                                for (CardDetectResult cr : VouchedCameraHelper.this.resultsWhileCapturing) {
                                                    allPostable = Step.POSTABLE.equals((Object)cr.getStep());
                                                }
                                                if (allPostable) {
                                                    VouchedCameraHelper.this.cardDetectResultListener.onCardDetectResult(cardDetectHr);
                                                } else {
                                                    usedFallbackImage = true;
                                                    VouchedCameraHelper.this.cardDetectResultListener.onCardDetectResult(cardDetectResult);
                                                }
                                                VouchedCameraHelper.this.isCapturing.set(false);
                                                VouchedCameraHelper.this.resultsWhileCapturing.clear();
                                            }
                                            catch (Exception e2) {
                                                try {
                                                    handledException = e2;
                                                    VouchedCameraHelper.this.cardDetectResultListener.onCardDetectResult(cardDetectResult);
                                                    SessionEventManager.Companion.getInstance().postException(e2);
                                                    VouchedCameraHelper.this.isCapturing.set(false);
                                                    VouchedCameraHelper.this.resultsWhileCapturing.clear();
                                                }
                                                catch (Throwable throwable) {
                                                    VouchedCameraHelper.this.isCapturing.set(false);
                                                    VouchedCameraHelper.this.resultsWhileCapturing.clear();
                                                    imageProxy.close();
                                                    SessionEventManager.Companion.getInstance().sendEvent(new SessionEventType.CardDetected(usedFallbackImage, capturedTime, manipulationTime, handledException != null, handledException == null ? "" : handledException.getLocalizedMessage(), VouchedCameraHelper.this.cardDetectOptions.isEnhanceInfoExtraction(), enhancedInfoFound));
                                                    throw throwable;
                                                }
                                                imageProxy.close();
                                                SessionEventManager.Companion.getInstance().sendEvent(new SessionEventType.CardDetected(usedFallbackImage, capturedTime, manipulationTime, handledException != null, handledException == null ? "" : handledException.getLocalizedMessage(), VouchedCameraHelper.this.cardDetectOptions.isEnhanceInfoExtraction(), enhancedInfoFound));
                                            }
                                            imageProxy.close();
                                            SessionEventManager.Companion.getInstance().sendEvent(new SessionEventType.CardDetected(usedFallbackImage, capturedTime, manipulationTime, handledException != null, handledException == null ? "" : handledException.getLocalizedMessage(), VouchedCameraHelper.this.cardDetectOptions.isEnhanceInfoExtraction(), enhancedInfoFound));
                                        }

                                        public void onError(@NonNull ImageCaptureException exception) {
                                            VouchedCameraHelper.this.onPause();
                                            exception.printStackTrace();
                                            SessionEventManager.Companion.getInstance().postException((Exception)exception);
                                            SessionEventManager.Companion.getInstance().sendEvent(new SessionEventType.CardDetectionError(exception.getLocalizedMessage()));
                                        }
                                    });
                                }
                            }
                            catch (Exception e) {
                                VouchedCameraHelper.this.cardDetectResultListener.onCardDetectResult(cardDetectResult);
                                SessionEventManager.Companion.getInstance().postException(e);
                                SessionEventManager.Companion.getInstance().sendEvent(new SessionEventType.CardDetected(true, 0L, 0L, true, e.getLocalizedMessage(), VouchedCameraHelper.this.cardDetectOptions.isEnhanceInfoExtraction(), enhancedInfoFound));
                            }
                        } else if (VouchedCameraHelper.this.isCapturing.get()) {
                            VouchedCameraHelper.this.resultsWhileCapturing.add(cardDetectResult);
                        } else if (!VouchedCameraHelper.this.isPaused.get()) {
                            VouchedCameraHelper.this.cardDetectResultListener.onCardDetectResult(cardDetectResult);
                        }
                    }
                });
            }
        };
    }

    private void createHandler() {
        this.handlerThread = new HandlerThread("vouchedCameraHelper");
        this.handlerThread.start();
        this.handler = new Handler(this.handlerThread.getLooper());
    }

    private void destroyHandler() {
        if (this.handlerThread != null) {
            this.handlerThread.quitSafely();
            try {
                this.handlerThread.join();
                this.handlerThread = null;
                this.handler = null;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void bindAllCameraUseCases() {
        if (this.cameraProvider == null) {
            return;
        }
        this.cameraProvider.unbindAll();
        if (this.captureUseCase != null) {
            this.cameraProvider.unbind(new UseCase[]{this.captureUseCase});
        }
        if (this.previewUseCase != null) {
            this.cameraProvider.unbind(new UseCase[]{this.previewUseCase});
        }
        if (this.analysisUseCase != null) {
            this.cameraProvider.unbind(new UseCase[]{this.analysisUseCase});
        }
        Preview.Builder previewBuilder = new Preview.Builder();
        previewBuilder.setTargetResolution(Mode.BARCODE.equals((Object)this.mode) ? BARCODE_DESIRED_PREVIEW_SIZE : DESIRED_PREVIEW_SIZE);
        this.previewUseCase = previewBuilder.build();
        this.previewUseCase.setSurfaceProvider(this.previewView.getSurfaceProvider());
        ImageAnalysis.Builder analysisBuilder = new ImageAnalysis.Builder();
        analysisBuilder.setTargetResolution(Mode.BARCODE.equals((Object)this.mode) ? BARCODE_DESIRED_PREVIEW_SIZE : DESIRED_PREVIEW_SIZE);
        this.analysisUseCase = analysisBuilder.build();
        this.analysisUseCase.setAnalyzer(this.mainExecutor, this.getAnalyzer());
        try {
            Camera cam;
            if (Mode.ID.equals((Object)this.mode) || Mode.ID_BACK.equals((Object)this.mode) || Mode.BARCODE.equals((Object)this.mode)) {
                ImageCapture.Builder imageCaptureBuilder = new ImageCapture.Builder();
                imageCaptureBuilder.setCaptureMode(0);
                imageCaptureBuilder.setTargetResolution(new Size(2448, 3264));
                this.captureUseCase = imageCaptureBuilder.build();
                cam = this.cameraProvider.bindToLifecycle(this.lifecycleOwner, this.cameraSelector, new UseCase[]{this.captureUseCase, this.analysisUseCase, this.previewUseCase});
            } else {
                cam = this.cameraProvider.bindToLifecycle(this.lifecycleOwner, this.cameraSelector, new UseCase[]{this.analysisUseCase, this.previewUseCase});
            }
            if (cam.getCameraInfo().hasFlashUnit() && this.flashDisabled) {
                cam.getCameraControl().enableTorch(false);
            }
        }
        catch (IllegalArgumentException iae) {
            SessionEventManager.Companion.getInstance().postException(iae);
        }
    }

    @SuppressLint(value={"UnsafeOptInUsageError"})
    private ImageAnalysis.Analyzer getAnalyzer() {
        if (Mode.ID.equals((Object)this.mode) || Mode.ID_BACK.equals((Object)this.mode)) {
            return imageProxy -> {
                if (this.timeoutHelper != null && this.timeoutHelper.timeoutIsExpired()) {
                    CardDetectResult result = new CardDetectResult(Step.PRE_DETECTED, Instruction.NONE, null, null, null, null);
                    this.cardDetectResultListener.onCardDetectResult(result);
                    imageProxy.close();
                    return;
                }
                try {
                    this.cardDetect.processImageProxy(imageProxy, this.handler);
                }
                catch (Exception e) {
                    System.out.println("Failed to process image. Error: " + e.getLocalizedMessage());
                    e.printStackTrace();
                }
            };
        }
        if (Mode.BARCODE.equals((Object)this.mode)) {
            return imageProxy -> {
                try {
                    if (this.timeoutHelper != null && this.timeoutHelper.timeoutIsExpired()) {
                        imageProxy.close();
                    } else {
                        this.barcodeDetect.findBarcode(imageProxy, this.handler);
                    }
                }
                catch (Exception e) {
                    System.out.println("Failed to process image. Error: " + e.getLocalizedMessage());
                    e.printStackTrace();
                }
            };
        }
        return imageProxy -> {
            try {
                this.faceDetect.processImageProxy(imageProxy, null);
            }
            catch (Exception e) {
                System.out.println("Failed to process image. Error: " + e.getLocalizedMessage());
                e.printStackTrace();
            }
        };
    }

    private void validateMode() throws VouchedCameraHelperException {
        if (this.mode == null) {
            throw new VouchedCameraHelperException("Must specify a CameraHelperMode");
        }
        if (Mode.ID.equals((Object)this.mode) || Mode.ID_BACK.equals((Object)this.mode)) {
            if (this.cardDetectOptions == null) {
                throw new VouchedCameraHelperException("Must specify 'cardDetectOptions' in VouchedCameraHelperOptions for CameraHelperMode.ID");
            }
            if (this.cardDetectResultListener == null) {
                throw new VouchedCameraHelperException("Must specify 'cardDetectResultListener' in VouchedCameraHelperOptions for CameraHelperMode.ID");
            }
        } else if (Mode.BARCODE.equals((Object)this.mode)) {
            if (this.barcodeDetectResultListener == null) {
                throw new VouchedCameraHelperException("Must specify 'barcodeDetectResultListener' in VouchedCameraHelperOptions for CameraHelperMode.BARCODE");
            }
        } else {
            if (this.faceDetectOptions == null) {
                throw new VouchedCameraHelperException("Must specify 'faceDetectOptions' in VouchedCameraHelperOptions for CameraHelperMode.FACE");
            }
            if (this.faceDetectResultListener == null) {
                throw new VouchedCameraHelperException("Must specify 'faceDetectResultListener' in VouchedCameraHelperOptions for CameraHelperMode.FACE");
            }
        }
    }

    private Bitmap toBitmap(ImageProxy.PlaneProxy[] planes) {
        ByteBuffer buffer = planes[0].getBuffer();
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        return BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length, null);
    }

    private Bitmap toBitmap(ImageProxy imageProxy) {
        ImageProxy.PlaneProxy[] planes = imageProxy.getPlanes();
        if (planes.length == 1) {
            return this.toBitmap(planes);
        }
        ByteBuffer yBuffer = planes[0].getBuffer();
        ByteBuffer uBuffer = planes[1].getBuffer();
        ByteBuffer vBuffer = planes[2].getBuffer();
        int ySize = yBuffer.remaining();
        int uSize = uBuffer.remaining();
        int vSize = vBuffer.remaining();
        byte[] nv21 = new byte[ySize + uSize + vSize];
        yBuffer.get(nv21, 0, ySize);
        vBuffer.get(nv21, ySize, vSize);
        uBuffer.get(nv21, ySize + vSize, uSize);
        YuvImage yuvImage = new YuvImage(nv21, 17, imageProxy.getWidth(), imageProxy.getHeight(), null);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        yuvImage.compressToJpeg(new Rect(0, 0, yuvImage.getWidth(), yuvImage.getHeight()), 100, (OutputStream)out);
        byte[] imageBytes = out.toByteArray();
        return BitmapFactory.decodeByteArray((byte[])imageBytes, (int)0, (int)imageBytes.length);
    }

    public void clearAndRestartTimeout() {
        if (this.timeoutHelper != null) {
            this.timeoutHelper.restart();
        }
    }

    public void capturePhoto(final ImageCaptureListener callback) {
        if (this.captureUseCase != null) {
            this.captureUseCase.takePicture(this.mainExecutor, new ImageCapture.OnImageCapturedCallback(){

                public void onCaptureSuccess(@NonNull ImageProxy image) {
                    Bitmap bitmap = VouchedCameraHelper.this.toBitmap(image);
                    Bitmap downscaledBitmap = BitmapUtils.downsizeIfNeeded(bitmap, 4000000);
                    callback.onImageCapture(downscaledBitmap);
                }

                public void onError(@NonNull ImageCaptureException exception) {
                    VouchedLogger.getInstance().error("Failed to capture an image. Error: " + exception.getLocalizedMessage());
                    exception.printStackTrace();
                    callback.onImageCapture(null);
                }
            });
        }
    }

    public static enum Mode {
        ID,
        BARCODE,
        ID_BACK,
        FACE,
        COMPLETED;

    }
}

