/*
 * Decompiled with CFR 0.152.
 */
package id.vouched.android;

import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.RectF;
import android.os.Trace;
import id.vouched.android.exception.VouchedAssetsMissingException;
import id.vouched.android.kt.event.SessionEventManager;
import id.vouched.android.tflite.Classifier;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.tensorflow.lite.Interpreter;

public class TFLiteObjectDetectionAPIModel
implements Classifier {
    private static final int NUM_DETECTIONS = 3;
    private static final float IMAGE_MEAN = 127.5f;
    private static final float IMAGE_STD = 127.5f;
    private static final int NUM_THREADS = 4;
    private boolean isModelQuantized;
    private int inputSize;
    private Vector<String> labels = new Vector();
    private int[] intValues;
    private float[][][] outputLocations;
    private float[][] outputClasses;
    private float[][] outputScores;
    private float[] numDetections;
    private ByteBuffer imgData;
    private Interpreter tfLite;

    private TFLiteObjectDetectionAPIModel() {
    }

    private static MappedByteBuffer loadModelFile(AssetManager assets, String modelFilename) throws IOException {
        AssetFileDescriptor fileDescriptor = assets.openFd(modelFilename);
        FileInputStream inputStream = new FileInputStream(fileDescriptor.getFileDescriptor());
        FileChannel fileChannel = inputStream.getChannel();
        long startOffset = fileDescriptor.getStartOffset();
        long declaredLength = fileDescriptor.getDeclaredLength();
        return fileChannel.map(FileChannel.MapMode.READ_ONLY, startOffset, declaredLength);
    }

    public static Classifier create(AssetManager assetManager, String modelFilename, String labelFilename, int inputSize, boolean isQuantized) throws VouchedAssetsMissingException {
        TFLiteObjectDetectionAPIModel d = new TFLiteObjectDetectionAPIModel();
        try {
            String line;
            String actualFilename = labelFilename.contains("file:///android_asset/") ? labelFilename.split("file:///android_asset/")[1] : labelFilename;
            InputStream labelsInput = assetManager.open(actualFilename);
            BufferedReader br = new BufferedReader(new InputStreamReader(labelsInput));
            while ((line = br.readLine()) != null) {
                d.labels.add(line);
            }
            br.close();
            d.inputSize = inputSize;
            MappedByteBuffer modelFileByteBuffer = TFLiteObjectDetectionAPIModel.loadModelFile(assetManager, modelFilename);
            try {
                Interpreter.Options options = new Interpreter.Options();
                options.setNumThreads(4);
                d.tfLite = new Interpreter((ByteBuffer)modelFileByteBuffer, options);
            }
            catch (Exception ex) {
                SessionEventManager.Companion.getInstance().postException(ex);
                throw new VouchedAssetsMissingException("Invalid Model GraphDef File", ex);
            }
        }
        catch (IOException e) {
            SessionEventManager.Companion.getInstance().postException(e);
            throw new VouchedAssetsMissingException("Cannot read the files from assets folder, please add the assets.", e);
        }
        d.isModelQuantized = isQuantized;
        int numBytesPerChannel = isQuantized ? 1 : 4;
        d.imgData = ByteBuffer.allocateDirect(d.inputSize * d.inputSize * 3 * numBytesPerChannel);
        d.imgData.order(ByteOrder.nativeOrder());
        d.intValues = new int[d.inputSize * d.inputSize];
        d.outputLocations = new float[1][3][4];
        d.outputClasses = new float[1][3];
        d.outputScores = new float[1][3];
        d.numDetections = new float[1];
        return d;
    }

    @Override
    public List<Classifier.Recognition> recognizeImage(Bitmap bitmap) {
        Trace.beginSection((String)"recognizeImage");
        Trace.beginSection((String)"preprocessBitmap");
        bitmap.getPixels(this.intValues, 0, bitmap.getWidth(), 0, 0, bitmap.getWidth(), bitmap.getHeight());
        this.imgData.rewind();
        for (int i = 0; i < this.inputSize; ++i) {
            for (int j = 0; j < this.inputSize; ++j) {
                int pixelValue = this.intValues[i * this.inputSize + j];
                if (this.isModelQuantized) {
                    this.imgData.put((byte)(pixelValue >> 16 & 0xFF));
                    this.imgData.put((byte)(pixelValue >> 8 & 0xFF));
                    this.imgData.put((byte)(pixelValue & 0xFF));
                    continue;
                }
                this.imgData.putFloat(((float)(pixelValue >> 16 & 0xFF) - 127.5f) / 127.5f);
                this.imgData.putFloat(((float)(pixelValue >> 8 & 0xFF) - 127.5f) / 127.5f);
                this.imgData.putFloat(((float)(pixelValue & 0xFF) - 127.5f) / 127.5f);
            }
        }
        Trace.endSection();
        Trace.beginSection((String)"feed");
        this.outputLocations = new float[1][3][4];
        this.outputClasses = new float[1][3];
        this.outputScores = new float[1][3];
        this.numDetections = new float[1];
        Object[] inputArray = new Object[]{this.imgData};
        HashMap<Integer, Object> outputMap = new HashMap<Integer, Object>();
        outputMap.put(0, this.outputLocations);
        outputMap.put(1, this.outputClasses);
        outputMap.put(2, this.outputScores);
        outputMap.put(3, this.numDetections);
        Trace.endSection();
        Trace.beginSection((String)"run");
        this.tfLite.runForMultipleInputsOutputs(inputArray, outputMap);
        Trace.endSection();
        int numDetectionsOutput = Math.min(3, (int)this.numDetections[0]);
        ArrayList<Classifier.Recognition> recognitions = new ArrayList<Classifier.Recognition>(numDetectionsOutput);
        for (int i = 0; i < numDetectionsOutput; ++i) {
            RectF detection = new RectF(this.outputLocations[0][i][1] * (float)this.inputSize, this.outputLocations[0][i][0] * (float)this.inputSize, this.outputLocations[0][i][3] * (float)this.inputSize, this.outputLocations[0][i][2] * (float)this.inputSize);
            int labelOffset = 1;
            recognitions.add(new Classifier.Recognition("" + i, this.labels.get((int)this.outputClasses[0][i] + labelOffset), Float.valueOf(this.outputScores[0][i]), detection));
        }
        Trace.endSection();
        return recognitions;
    }

    @Override
    public void enableStatLogging(boolean logStats) {
    }

    @Override
    public String getStatString() {
        return "";
    }

    @Override
    public void close() {
    }
}

