/*
 * Decompiled with CFR 0.152.
 */
package id.vouched.android;

import android.graphics.Bitmap;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.mlkit.vision.barcode.BarcodeScanner;
import com.google.mlkit.vision.barcode.BarcodeScannerOptions;
import com.google.mlkit.vision.barcode.BarcodeScanning;
import com.google.mlkit.vision.barcode.common.Barcode;
import com.google.mlkit.vision.common.InputImage;
import id.vouched.android.VouchedLogger;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class FrontBarcodeScanner {
    BarcodeScanner scanner = BarcodeScanning.getClient((BarcodeScannerOptions)new BarcodeScannerOptions.Builder().setBarcodeFormats(2048, new int[0]).build());

    public String analyzeImageForBarcodes(Bitmap crop, int orientation) {
        InputImage inputImg = InputImage.fromBitmap((Bitmap)crop, (int)orientation);
        return this.getBarcodeTextLatch(inputImg);
    }

    @Nullable
    private String getBarcodeTextAwait(InputImage inputImg) {
        String barcodeText = "";
        try {
            List barcodes = (List)Tasks.await((Task)this.scanner.process(inputImg), (long)2000L, (TimeUnit)TimeUnit.MILLISECONDS);
            if (barcodes.size() > 0) {
                barcodeText = ((Barcode)barcodes.get(0)).getRawValue();
            }
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            VouchedLogger.getInstance().error(e.getLocalizedMessage());
        }
        return barcodeText;
    }

    @Nullable
    public String getBarcodeTextLatch(InputImage img) {
        final CountDownLatch latch = new CountDownLatch(1);
        final String[] barcodeText = new String[]{""};
        this.scanner.process(img).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<List<Barcode>>(){

            public void onSuccess(List<Barcode> barcodes) {
                if (barcodes.size() > 0) {
                    barcodeText[0] = barcodes.get(0).getRawValue();
                }
                latch.countDown();
            }
        }).addOnFailureListener(new OnFailureListener(){

            public void onFailure(@NonNull Exception e) {
                latch.countDown();
            }
        });
        try {
            latch.await(4000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return barcodeText[0];
    }
}

