/*
 * Decompiled with CFR 0.152.
 */
package id.vouched.android;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.SystemClock;
import androidx.annotation.RequiresApi;
import androidx.camera.core.ExperimentalGetImage;
import androidx.camera.core.ImageProxy;
import com.google.mlkit.common.MlKitException;
import com.google.mlkit.vision.common.InputImage;
import com.google.mlkit.vision.common.internal.ImageConvertUtils;
import com.google.mlkit.vision.face.Face;
import com.google.mlkit.vision.face.FaceDetectorOptions;
import com.google.mlkit.vision.face.FaceLandmark;
import id.vouched.android.FaceDetectOptions;
import id.vouched.android.FaceDetectResult;
import id.vouched.android.Instruction;
import id.vouched.android.Step;
import id.vouched.android.VouchedLogger;
import id.vouched.android.box.BoxUtility;
import id.vouched.android.box.DetectedBox;
import id.vouched.android.event.SessionEventType;
import id.vouched.android.kt.event.SessionEventManager;
import id.vouched.android.liveness.Liveness;
import id.vouched.android.liveness.LivenessFactory;
import id.vouched.android.liveness.LivenessMode;
import id.vouched.android.liveness.LivenessStep;
import id.vouched.android.liveness.impl.LookStraight;
import id.vouched.android.liveness.impl.MouthClosed;
import id.vouched.android.mlkit.FaceDetectorProcessor;
import id.vouched.android.mlkit.FacesFound;
import id.vouched.android.mlkit.GraphicOverlay;
import id.vouched.android.utils.BitmapUtils;
import java.util.LinkedList;
import java.util.List;
import java9.util.function.Consumer;
import java9.util.stream.StreamSupport;

public class FaceDetect {
    private static final float FACE_BIG_BOX = 0.018f;
    private Context context;
    private final FaceDetectorOptions faceDetectorOptions;
    private final Consumer<FacesFound> facesFoundFn;
    private FaceDetectorProcessor imageProcessor;
    private Liveness liveness;
    private LinkedList<DetectedBox> boxes;
    private long holdSteadyInterval;
    private long holdSteadyStart;
    private String userDistanceImage;
    private InternalStatus _status;

    public FaceDetect(Context context, FaceDetectOptions options, OnDetectResultListener resultListener) {
        LivenessMode livenessModeOptions = options.getLivenessMode();
        this.context = context;
        this.facesFoundFn = this.getFacesCallback(resultListener);
        this.faceDetectorOptions = new FaceDetectorOptions.Builder().setLandmarkMode(2).setContourMode(livenessModeOptions == LivenessMode.MOUTH_MOVEMENT ? 2 : 1).setClassificationMode(livenessModeOptions == LivenessMode.BLINKING ? 2 : 1).setPerformanceMode(1).setMinFaceSize(0.1f).build();
        this.imageProcessor = new FaceDetectorProcessor(context, this.faceDetectorOptions, this.facesFoundFn);
        this.liveness = LivenessFactory.get(livenessModeOptions);
        this.boxes = new LinkedList();
        this.holdSteadyInterval = 1250L;
        this.holdSteadyStart = Long.MIN_VALUE;
        this.userDistanceImage = null;
        this._status = InternalStatus.NOT_STARTED;
    }

    public FaceDetect(Context context) {
        this(context, FaceDetectOptions.defaultOptions(), null);
    }

    private Consumer<FacesFound> getFacesCallback(OnDetectResultListener resultListener) {
        return facesFound -> {
            int width;
            int height;
            FaceLandmark nose;
            FaceLandmark rightEye;
            if (resultListener == null) {
                return;
            }
            List<Face> faces = facesFound.getFaces();
            InputImage inputImage = facesFound.getImage();
            GraphicOverlay overlay = facesFound.getGraphicOverlay();
            float fps = facesFound.getFps();
            Step step = Step.PRE_DETECTED;
            if (faces.isEmpty()) {
                resultListener.onFaceDetectResult(this.getResult(step, Instruction.NO_FACE));
                return;
            }
            if (faces.size() > 1) {
                resultListener.onFaceDetectResult(this.getResult(step, Instruction.ONLY_ONE));
                return;
            }
            Face face = faces.get(0);
            step = Step.DETECTED;
            FaceLandmark leftEye = face.getLandmark(4);
            DetectedBox box = BoxUtility.toDetectedBox(leftEye, rightEye = face.getLandmark(10), nose = face.getLandmark(6), height = overlay != null ? overlay.getImageHeight() : inputImage.getHeight(), width = overlay != null ? overlay.getImageWidth() : inputImage.getWidth());
            LivenessStep livenessStep = this.liveness.execute(box, face, fps);
            if (livenessStep != LivenessStep.COMPLETE) {
                Instruction instruction = null;
                switch (livenessStep) {
                    case OPEN_MOUTH: {
                        instruction = Instruction.OPEN_MOUTH;
                        break;
                    }
                    case CLOSE_MOUTH: {
                        instruction = Instruction.CLOSE_MOUTH;
                        break;
                    }
                    case LOOK_FORWARD: {
                        instruction = Instruction.LOOK_FORWARD;
                        break;
                    }
                    case MOVE_AWAY: {
                        instruction = Instruction.MOVE_AWAY;
                        break;
                    }
                    case HOLD_STEADY: {
                        instruction = Instruction.HOLD_STEADY;
                        break;
                    }
                    case CAPTURE_DISTANCE_IMAGE: {
                        this.userDistanceImage = this.convertImageToBase64(inputImage);
                        break;
                    }
                    case BLINK_EYES: {
                        instruction = Instruction.BLINK_EYES;
                        break;
                    }
                    default: {
                        instruction = Instruction.NO_FACE;
                    }
                }
                if (instruction != null) {
                    resultListener.onFaceDetectResult(this.getResult(step, instruction));
                    return;
                }
            }
            if (!BoxUtility.isBigBox(box, 0.018f)) {
                resultListener.onFaceDetectResult(this.getResult(step, Instruction.MOVE_CLOSER));
                return;
            }
            if (new LookStraight(1).execute(box, face, fps) != LivenessStep.COMPLETE) {
                resultListener.onFaceDetectResult(this.getResult(step, Instruction.LOOK_FORWARD));
                return;
            }
            if (new MouthClosed().execute(box, face, fps) != LivenessStep.COMPLETE) {
                resultListener.onFaceDetectResult(this.getResult(step, Instruction.CLOSE_MOUTH));
                return;
            }
            BoxUtility.addBoxes(this.boxes, box, fps);
            long l = this.holdSteadyStart = this.holdSteadyStart == Long.MIN_VALUE ? this.createHoldSteadyTime() : this.holdSteadyStart;
            if (SystemClock.elapsedRealtime() < this.holdSteadyStart) {
                resultListener.onFaceDetectResult(this.getResult(step, Instruction.HOLD_STEADY));
                return;
            }
            if (!BoxUtility.foundSteadyBox(this.boxes, fps)) {
                resultListener.onFaceDetectResult(this.getResult(step, Instruction.HOLD_STEADY));
                return;
            }
            this.updateCompleteStatus();
            step = Step.POSTABLE;
            resultListener.onFaceDetectResult(this.getResult(step, Instruction.NONE, this.convertImageToBase64(inputImage), this.userDistanceImage));
        };
    }

    private String convertImageToBase64(InputImage inputImage) {
        try {
            Bitmap bitmap = ImageConvertUtils.getInstance().convertToUpRightBitmap(inputImage);
            return BitmapUtils.toBase64(bitmap, Bitmap.CompressFormat.JPEG, 100, 0);
        }
        catch (MlKitException e) {
            e.printStackTrace();
            SessionEventManager.Companion.getInstance().postException((Exception)((Object)e));
            return "";
        }
    }

    private long createHoldSteadyTime() {
        long now = SystemClock.elapsedRealtime();
        return now + this.holdSteadyInterval;
    }

    private float calculateFPS(List<Long> processingTimes) {
        Long sum = (Long)StreamSupport.stream(processingTimes).reduce((Object)0L, (a, b) -> a + b);
        long avgTimeInMs = sum / (long)processingTimes.size();
        float fps = 1000.0f / (float)avgTimeInMs;
        return fps;
    }

    private FaceDetectResult getResult(Step step, Instruction instruction) {
        return this.getResult(step, instruction, null, null);
    }

    private FaceDetectResult getResult(Step step, Instruction instruction, String image, String userDistanceImage) {
        if (instruction == Instruction.NO_FACE || instruction == Instruction.ONLY_ONE) {
            this.liveness.resetValues();
        }
        return new FaceDetectResult(step, instruction, image, userDistanceImage);
    }

    @RequiresApi(value=19)
    @ExperimentalGetImage
    public void processImageProxy(ImageProxy imageProxy, GraphicOverlay graphicOverlay) {
        try {
            if (this.imageProcessor != null) {
                this.updateStartStatus();
                this.imageProcessor.processImageProxy(imageProxy, graphicOverlay);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            SessionEventManager.Companion.getInstance().postException(e);
        }
    }

    public void stop() {
        if (this.imageProcessor != null) {
            this.imageProcessor.stop();
            this.imageProcessor = null;
        }
    }

    public void resume() {
        if (this.imageProcessor == null) {
            this.imageProcessor = new FaceDetectorProcessor(this.context, this.faceDetectorOptions, this.facesFoundFn);
        }
    }

    public void reset() {
        this.liveness.resetValues();
        this.boxes = new LinkedList();
        this.holdSteadyStart = Long.MIN_VALUE;
        this.userDistanceImage = null;
    }

    private void updateStartStatus() {
        if (this._status.equals((Object)InternalStatus.STARTED) || this._status.equals((Object)InternalStatus.RE_STARTED)) {
            return;
        }
        if (this._status.equals((Object)InternalStatus.COMPLETED) || this._status.equals((Object)InternalStatus.RE_COMPLETED)) {
            this._status = InternalStatus.RE_STARTED;
        } else if (this._status.equals((Object)InternalStatus.NOT_STARTED)) {
            this._status = InternalStatus.STARTED;
        }
    }

    private void updateCompleteStatus() {
        long now = SystemClock.elapsedRealtime();
        long holdSteadyTime = now - this.holdSteadyStart;
        VouchedLogger.getInstance().info("holdSteadyTime: " + holdSteadyTime);
        if (this._status.equals((Object)InternalStatus.STARTED)) {
            this._status = InternalStatus.COMPLETED;
        } else if (this._status.equals((Object)InternalStatus.RE_STARTED)) {
            this._status = InternalStatus.RE_COMPLETED;
        }
        SessionEventManager.Companion.getInstance().sendEvent(new SessionEventType.FaceDetected(holdSteadyTime));
    }

    public static interface OnDetectResultListener {
        public void onFaceDetectResult(FaceDetectResult var1);
    }

    private static enum InternalStatus {
        NOT_STARTED,
        STARTED,
        COMPLETED,
        RE_STARTED,
        RE_COMPLETED;

    }
}

