/*
 * Decompiled with CFR 0.152.
 */
package id.vouched.android;

import android.annotation.SuppressLint;
import android.graphics.Bitmap;
import android.graphics.RectF;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import id.vouched.android.Instruction;
import id.vouched.android.Step;

public class CardDetectResult {
    private Step step;
    private Instruction instruction;
    private String image;
    private String distanceImage;
    private RectF location;
    private Bitmap imageBitmap;
    private String barcodeText;

    public CardDetectResult(Step step, Instruction instruction, String image, String distanceImage, RectF location, Bitmap imageBitmap) {
        this(step, instruction, image, distanceImage, location, imageBitmap, "");
    }

    public CardDetectResult(Step step, Instruction instruction, String image, String distanceImage, RectF location, Bitmap imageBitmap, String barcodeText) {
        this.step = step;
        this.instruction = instruction;
        this.image = image;
        this.distanceImage = distanceImage;
        this.location = location;
        this.imageBitmap = imageBitmap;
        this.barcodeText = barcodeText;
    }

    public Step getStep() {
        return this.step;
    }

    public Instruction getInstruction() {
        return this.instruction;
    }

    @Nullable
    public String getImage() {
        return this.image;
    }

    @Nullable
    public String getDistanceImage() {
        return this.distanceImage;
    }

    @Nullable
    public RectF getLocation() {
        return this.location;
    }

    @Nullable
    public Bitmap getImageBitmap() {
        return this.imageBitmap;
    }

    @Nullable
    public String getBarcodeText() {
        return this.barcodeText;
    }

    public void setBarcodeText(String barcodeText) {
        this.barcodeText = barcodeText;
    }

    @NonNull
    @SuppressLint(value={"DefaultLocale"})
    public String toString() {
        return "CardDetectResult{step=" + (Object)((Object)this.step) + ", instruction=" + (Object)((Object)this.instruction) + ", image='" + (this.image != null) + '\'' + ", distanceImage='" + (this.distanceImage != null) + '\'' + ", location=" + (this.location != null ? String.format("Location(%f, %f, %f, %f)", Float.valueOf(this.location.top), Float.valueOf(this.location.bottom), Float.valueOf(this.location.left), Float.valueOf(this.location.right)) : null) + ", imageBitmap=" + (this.imageBitmap != null ? new Size(this.imageBitmap.getWidth(), this.imageBitmap.getHeight()).toString() : null) + ", barcodeText=" + this.barcodeText + '}';
    }
}

