/*
 * Decompiled with CFR 0.152.
 */
package id.vouched.android;

public class CardDetectOptions {
    private boolean enableDistanceCheck;
    private boolean enableEnhancedIdScan;
    private boolean enableOrientationCheck;

    private CardDetectOptions(boolean enableDistanceCheck, boolean enableEnhancedIdScan, boolean enableOrientationCheck) {
        this.enableDistanceCheck = enableDistanceCheck;
        this.enableEnhancedIdScan = enableEnhancedIdScan;
        this.enableOrientationCheck = enableOrientationCheck;
    }

    public boolean isEnableDistanceCheck() {
        return this.enableDistanceCheck;
    }

    public boolean isEnhanceInfoExtraction() {
        return this.enableEnhancedIdScan;
    }

    public boolean isEnableOrientationCheck() {
        return this.enableOrientationCheck;
    }

    public static CardDetectOptions defaultOptions() {
        return new CardDetectOptions(false, false, false);
    }

    public static class Builder {
        private boolean enableDistanceCheck = false;
        private boolean enableEnhancedIdScan = false;
        private boolean enableOrientationCheck = false;

        public Builder withEnableDistanceCheck(boolean enableDistanceCheck) {
            this.enableDistanceCheck = enableDistanceCheck;
            return this;
        }

        public Builder withEnhanceInfoExtraction(boolean enableEnhancedIdScan) {
            this.enableEnhancedIdScan = enableEnhancedIdScan;
            return this;
        }

        public Builder withEnableOrientationCheck(boolean enableOrientationCheck) {
            this.enableOrientationCheck = enableOrientationCheck;
            return this;
        }

        public CardDetectOptions build() {
            return new CardDetectOptions(this.enableDistanceCheck, this.enableEnhancedIdScan, this.enableOrientationCheck);
        }
    }
}

