/*
 * Decompiled with CFR 0.152.
 */
package id.vouched.android;

import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import android.os.Handler;
import android.os.SystemClock;
import androidx.annotation.NonNull;
import androidx.camera.core.ImageProxy;
import id.vouched.android.CardDetectOptions;
import id.vouched.android.CardDetectResult;
import id.vouched.android.FrontBarcodeScanner;
import id.vouched.android.Instruction;
import id.vouched.android.Step;
import id.vouched.android.TFLiteObjectDetectionAPIModel;
import id.vouched.android.VouchedLogger;
import id.vouched.android.box.BoxUtility;
import id.vouched.android.box.DetectedBox;
import id.vouched.android.box.Orientation;
import id.vouched.android.box.OrientationUtils;
import id.vouched.android.customview.OverlayView;
import id.vouched.android.env.ImageUtils;
import id.vouched.android.exception.VouchedAssetsMissingException;
import id.vouched.android.mlkit.BitmapUtils;
import id.vouched.android.tflite.Classifier;
import id.vouched.android.tracking.MultiBoxTracker;
import java.util.LinkedList;
import java.util.List;
import java9.util.function.Consumer;
import java9.util.stream.Collectors;
import java9.util.stream.StreamSupport;

public class CardDetect {
    private static final float minAspectRatio = 1.2f;
    private static final float maxAspectRatio = 1.8f;
    private static final int TF_OD_API_INPUT_SIZE = 320;
    private static final boolean TF_OD_API_IS_QUANTIZED = false;
    private static final String TF_OD_API_MODEL_FILE = "inference_graph.tflite";
    private static final String TF_OD_API_LABELS_FILE = "file:///android_asset/labelmap_mobilenet_card.txt";
    private static final float CARD_BIG_BOX = 0.24f;
    private static final float CARD_SMALL_BOX = 0.17f;
    private Classifier detector;
    private LinkedList<Long> processingTimes;
    private LinkedList<DetectedBox> boxes;
    private long holdSteadyInterval;
    private long holdSteadyStart;
    private String distanceImage;
    private boolean distanceCheckComplete;
    private boolean enableDistanceCheck;
    private boolean enableEnhanceInfoExtraction;
    private boolean enableOrientationCheck;
    private final OnDetectResultListener detectResultListener;
    private InternalStatus _status;
    private Instruction previousInstruction;
    private long latestHoldSteadyAsk;
    private int distanceCheckCount = 0;
    private long lastDistanceCheckStartTime = 0L;
    private static final int DISTANCE_INTERVAL_SECONDS = 5000;
    private static final int MAX_DISTANCE_INCREASES = 5;
    private static final double DISTANCE_INCREASE_PERCENT_INCREMENT = 0.05;

    public CardDetect(AssetManager assetManager, CardDetectOptions cardDetectOptions, OnDetectResultListener detectResultListener) throws VouchedAssetsMissingException {
        this.detectResultListener = detectResultListener;
        this.processingTimes = new LinkedList();
        this.boxes = new LinkedList();
        this.holdSteadyInterval = 750L;
        this.holdSteadyStart = Long.MIN_VALUE;
        this.distanceImage = null;
        this.enableDistanceCheck = cardDetectOptions.isEnableDistanceCheck();
        this.distanceCheckComplete = false;
        this.latestHoldSteadyAsk = Long.MIN_VALUE;
        this._status = InternalStatus.NOT_STARTED;
        this.detector = TFLiteObjectDetectionAPIModel.create(assetManager, TF_OD_API_MODEL_FILE, TF_OD_API_LABELS_FILE, 320, false);
        this.enableEnhanceInfoExtraction = cardDetectOptions.isEnhanceInfoExtraction();
        this.enableOrientationCheck = cardDetectOptions.isEnableOrientationCheck();
    }

    public void reset() {
        this.processingTimes = new LinkedList();
        this.boxes = new LinkedList();
        this.holdSteadyInterval = 750L;
        this.holdSteadyStart = Long.MIN_VALUE;
        this.distanceImage = null;
        this.distanceCheckComplete = false;
        this.latestHoldSteadyAsk = Long.MIN_VALUE;
    }

    public void processImageProxy(@NonNull ImageProxy imageProxy, @NonNull Handler handler) {
        Bitmap bitmap = BitmapUtils.getBitmap(imageProxy);
        if (bitmap != null) {
            this.processImage(bitmap, null, null, handler, (Consumer<Void>)((Consumer)_nada -> imageProxy.close()));
        } else {
            VouchedLogger.getInstance().error("Unable to convert imageProxy to bitmap. Skipping ID detection.");
            imageProxy.close();
        }
    }

    public void processImage(@NonNull Bitmap rgbFrameBitmap, MultiBoxTracker tracker, OverlayView trackingOverlay, @NonNull Handler handler) {
        this.processImage(rgbFrameBitmap, tracker, trackingOverlay, handler, null);
    }

    private void processImage(final @NonNull Bitmap rgbFrameBitmap, final MultiBoxTracker tracker, final OverlayView trackingOverlay, @NonNull Handler handler, final Consumer<Void> imageCloseFn) {
        if (rgbFrameBitmap == null || handler == null) {
            VouchedLogger.getInstance().error("{} is null. Skipping ID detection.".replace("{}", rgbFrameBitmap == null ? "Bitmap" : "Handler"));
            this.detectResultListener.onCardDetectResult(this.getResult(Step.PRE_DETECTED, Instruction.NONE));
            this.closeImage(imageCloseFn);
            return;
        }
        handler.post(new Runnable(){

            @Override
            public void run() {
                if (CardDetect.this.detector == null) {
                    CardDetect.this.detectResultListener.onCardDetectResult(CardDetect.this.getResult(Step.PRE_DETECTED, Instruction.NONE));
                    CardDetect.this.closeImage((Consumer<Void>)imageCloseFn);
                    return;
                }
                CardDetect.this.updateStartStatus();
                long startTime = SystemClock.elapsedRealtime();
                Bitmap croppedBitmap = Bitmap.createBitmap((int)320, (int)320, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Matrix frameToCropTransform = ImageUtils.getTransformationMatrix(rgbFrameBitmap.getWidth(), rgbFrameBitmap.getHeight(), 320, 320, 0, false);
                Matrix cropToFrameTransform = new Matrix();
                frameToCropTransform.invert(cropToFrameTransform);
                Canvas croppedCanvas = new Canvas(croppedBitmap);
                croppedCanvas.drawBitmap(rgbFrameBitmap, frameToCropTransform, null);
                Step step = Step.PRE_DETECTED;
                List<Classifier.Recognition> results = CardDetect.this.detector.recognizeImage(croppedBitmap);
                long processingTime = SystemClock.elapsedRealtime() - startTime;
                if (CardDetect.this.processingTimes.size() >= 30) {
                    CardDetect.this.processingTimes.removeFirst();
                }
                CardDetect.this.processingTimes.add(processingTime);
                float fps = CardDetect.this.calculateFPS(CardDetect.this.processingTimes);
                LinkedList<Classifier.Recognition> mappedRecognitions = new LinkedList<Classifier.Recognition>();
                if (results.isEmpty()) {
                    CardDetect.this.detectResultListener.onCardDetectResult(CardDetect.this.getResult(step, Instruction.NO_CARD));
                    CardDetect.this.trackResults(tracker, trackingOverlay, mappedRecognitions, startTime);
                    CardDetect.this.closeImage((Consumer<Void>)imageCloseFn);
                    return;
                }
                List cardResults = (List)StreamSupport.stream(results).filter(r -> r.getConfidence().floatValue() > 0.7f).collect(Collectors.toList());
                if (cardResults.isEmpty()) {
                    CardDetect.this.detectResultListener.onCardDetectResult(CardDetect.this.getResult(step, Instruction.NO_CARD));
                    CardDetect.this.trackResults(tracker, trackingOverlay, mappedRecognitions, startTime);
                    CardDetect.this.closeImage((Consumer<Void>)imageCloseFn);
                    return;
                }
                if (cardResults.size() > 1) {
                    CardDetect.this.detectResultListener.onCardDetectResult(CardDetect.this.getResult(step, Instruction.ONLY_ONE));
                    CardDetect.this.trackResults(tracker, trackingOverlay, mappedRecognitions, startTime);
                    CardDetect.this.closeImage((Consumer<Void>)imageCloseFn);
                    return;
                }
                step = Step.DETECTED;
                Classifier.Recognition result = results.get(0);
                RectF location = result.getLocation();
                if (CardDetect.this.enableOrientationCheck) {
                    Orientation fullPhotoOrientation = OrientationUtils.getOrientation(rgbFrameBitmap.getWidth(), rgbFrameBitmap.getHeight());
                    RectF originalResultLocation = new RectF(location);
                    cropToFrameTransform.mapRect(originalResultLocation);
                    Orientation resultOrientation = OrientationUtils.getOrientation(originalResultLocation);
                    if (fullPhotoOrientation != Orientation.SQUARE && !fullPhotoOrientation.equals((Object)resultOrientation)) {
                        Instruction instruction = fullPhotoOrientation == Orientation.HORIZONTAL ? Instruction.ROTATE_TO_HORIZONTAL : Instruction.ROTATE_TO_VERTICAL;
                        CardDetect.this.detectResultListener.onCardDetectResult(CardDetect.this.getResult(step, instruction));
                        CardDetect.this.trackResults(tracker, trackingOverlay, mappedRecognitions, startTime);
                        CardDetect.this.closeImage((Consumer<Void>)imageCloseFn);
                        return;
                    }
                }
                Bitmap cropCopyBitmap = Bitmap.createBitmap((Bitmap)croppedBitmap);
                Canvas canvas = new Canvas(cropCopyBitmap);
                Paint paint = new Paint();
                paint.setColor(-65536);
                paint.setStyle(Paint.Style.STROKE);
                paint.setStrokeWidth(2.0f);
                canvas.drawRect(location, paint);
                cropToFrameTransform.mapRect(location);
                result.setLocation(location);
                mappedRecognitions.add(result);
                CardDetect.this.trackResults(tracker, trackingOverlay, mappedRecognitions, startTime);
                DetectedBox box = BoxUtility.toDetectedBox(rgbFrameBitmap, location);
                if (CardDetect.this.enableDistanceCheck && !CardDetect.this.distanceCheckComplete) {
                    if (!BoxUtility.isSmallBox(box, 0.17f + (float)((double)(0.17f * (float)(CardDetect.this.distanceCheckCount + 1) * 0.17f) * 0.05))) {
                        long currentTime = System.currentTimeMillis();
                        if ((CardDetect.this.lastDistanceCheckStartTime == 0L || currentTime - CardDetect.this.lastDistanceCheckStartTime > 5000L) && CardDetect.this.distanceCheckCount < 5) {
                            CardDetect.this.lastDistanceCheckStartTime = currentTime;
                            CardDetect.this.distanceCheckCount += 1;
                        }
                        CardDetect.this.detectResultListener.onCardDetectResult(CardDetect.this.getResult(step, Instruction.MOVE_AWAY));
                        CardDetect.this.closeImage((Consumer<Void>)imageCloseFn);
                        return;
                    }
                    BoxUtility.addBoxes(CardDetect.this.boxes, box, fps);
                    if (!BoxUtility.foundSteadyBox(CardDetect.this.boxes, fps)) {
                        CardDetect.this.detectResultListener.onCardDetectResult(CardDetect.this.getResult(step, Instruction.HOLD_STEADY));
                        CardDetect.this.closeImage((Consumer<Void>)imageCloseFn);
                        return;
                    }
                    CardDetect.this.distanceImage = id.vouched.android.utils.BitmapUtils.toBase64(rgbFrameBitmap);
                    CardDetect.this.distanceCheckComplete = true;
                }
                if (!BoxUtility.isBigBox(box, 0.24f)) {
                    CardDetect.this.detectResultListener.onCardDetectResult(CardDetect.this.getResult(step, Instruction.MOVE_CLOSER));
                    CardDetect.this.closeImage((Consumer<Void>)imageCloseFn);
                    return;
                }
                if (CardDetect.this.isDetectionTooLarge(location, rgbFrameBitmap.getHeight(), rgbFrameBitmap.getWidth())) {
                    CardDetect.this.detectResultListener.onCardDetectResult(CardDetect.this.getResult(step, Instruction.MOVE_AWAY));
                    CardDetect.this.closeImage((Consumer<Void>)imageCloseFn);
                    return;
                }
                BoxUtility.addBoxes(CardDetect.this.boxes, box, fps);
                CardDetect.this.holdSteadyStart = CardDetect.this.holdSteadyStart == Long.MIN_VALUE ? CardDetect.this.createHoldSteadyTime() : CardDetect.this.holdSteadyStart;
                if (SystemClock.elapsedRealtime() < CardDetect.this.holdSteadyStart) {
                    CardDetect.this.detectResultListener.onCardDetectResult(CardDetect.this.getResult(step, Instruction.HOLD_STEADY));
                    CardDetect.this.closeImage((Consumer<Void>)imageCloseFn);
                    return;
                }
                if (!BoxUtility.foundSteadyBox(CardDetect.this.boxes, fps)) {
                    CardDetect.this.detectResultListener.onCardDetectResult(CardDetect.this.getResult(step, Instruction.HOLD_STEADY));
                    CardDetect.this.closeImage((Consumer<Void>)imageCloseFn);
                    return;
                }
                CardDetect.this.updateCompleteStatus();
                step = Step.POSTABLE;
                Bitmap detectCropBitmap = id.vouched.android.utils.BitmapUtils.clippingBitmap(location, rgbFrameBitmap);
                String image = id.vouched.android.utils.BitmapUtils.toBase64(detectCropBitmap);
                String barcodeText = "";
                if (CardDetect.this.enableEnhanceInfoExtraction) {
                    FrontBarcodeScanner barcodeScanner = new FrontBarcodeScanner();
                    barcodeText = barcodeScanner.analyzeImageForBarcodes(detectCropBitmap, 0);
                }
                if (CardDetect.this.hasValidAspectRatio(location)) {
                    CardDetect.this.detectResultListener.onCardDetectResult(CardDetect.this.getResult(step, Instruction.HOLD_STEADY, image, CardDetect.this.distanceImage, location, detectCropBitmap, barcodeText));
                } else {
                    location = new RectF(0.0f, 0.0f, (float)rgbFrameBitmap.getWidth(), (float)rgbFrameBitmap.getHeight());
                    CardDetect.this.detectResultListener.onCardDetectResult(CardDetect.this.getResult(step, Instruction.HOLD_STEADY, id.vouched.android.utils.BitmapUtils.toBase64(rgbFrameBitmap), CardDetect.this.distanceImage, location, rgbFrameBitmap, barcodeText));
                }
                CardDetect.this.closeImage((Consumer<Void>)imageCloseFn);
            }
        });
    }

    private void closeImage(Consumer<Void> imageCloseFn) {
        if (imageCloseFn != null) {
            imageCloseFn.accept(null);
        }
    }

    private boolean isDetectionTooLarge(RectF box, int height, int width) {
        return box.height() > (float)(height - 10) || box.width() > (float)(width - 10);
    }

    private void trackResults(MultiBoxTracker tracker, OverlayView trackingOverlay, List<Classifier.Recognition> mappedRecognitions, long startTime) {
        if (tracker != null) {
            tracker.trackResults(mappedRecognitions, startTime);
        }
        if (trackingOverlay != null) {
            trackingOverlay.postInvalidate();
        }
    }

    private float calculateFPS(List<Long> processingTimes) {
        Long sum = (Long)StreamSupport.stream(processingTimes).reduce((Object)0L, (a, b) -> a + b);
        long avgTimeInMs = sum / (long)processingTimes.size();
        float fps = 1000.0f / (float)avgTimeInMs;
        return fps;
    }

    private long createHoldSteadyTime() {
        long now = SystemClock.elapsedRealtime();
        return now + this.holdSteadyInterval;
    }

    private CardDetectResult getResult(Step step, Instruction instruction) {
        return this.getResult(step, instruction, null, null, null, null, "");
    }

    private CardDetectResult getResult(Step step, Instruction instruction, String image, String distanceImage, RectF location, Bitmap imageBitmap, String barcodeText) {
        if (this.latestHoldSteadyAsk == Long.MIN_VALUE || instruction == Instruction.HOLD_STEADY && Instruction.HOLD_STEADY != this.previousInstruction) {
            this.latestHoldSteadyAsk = SystemClock.elapsedRealtime();
        }
        this.previousInstruction = instruction;
        return new CardDetectResult(step, instruction, image, distanceImage, location, imageBitmap, barcodeText);
    }

    private boolean hasValidAspectRatio(RectF location) {
        float aspectRatio = this.getAspectRatio(location);
        return 1.2f < aspectRatio && aspectRatio < 1.8f;
    }

    private float getAspectRatio(RectF location) {
        float width = Math.abs(location.left - location.right);
        float height = Math.abs(location.top - location.bottom);
        float minSize = Math.min(width, height);
        float maxSize = Math.max(width, height);
        return maxSize / minSize;
    }

    private void updateStartStatus() {
        if (this._status.equals((Object)InternalStatus.STARTED) || this._status.equals((Object)InternalStatus.RE_STARTED)) {
            return;
        }
        if (this._status.equals((Object)InternalStatus.COMPLETED) || this._status.equals((Object)InternalStatus.RE_COMPLETED)) {
            this._status = InternalStatus.RE_STARTED;
        } else if (this._status.equals((Object)InternalStatus.NOT_STARTED)) {
            this._status = InternalStatus.STARTED;
        }
    }

    private void updateCompleteStatus() {
        long now = SystemClock.elapsedRealtime();
        VouchedLogger.getInstance().info("holdSteadyTime: " + (now - this.holdSteadyStart + this.holdSteadyInterval) + " || " + (now - this.latestHoldSteadyAsk));
        if (this._status.equals((Object)InternalStatus.STARTED)) {
            this._status = InternalStatus.COMPLETED;
        } else if (this._status.equals((Object)InternalStatus.RE_STARTED)) {
            this._status = InternalStatus.RE_COMPLETED;
        }
    }

    public static interface OnDetectResultListener {
        public void onCardDetectResult(CardDetectResult var1);
    }

    private static enum InternalStatus {
        NOT_STARTED,
        STARTED,
        COMPLETED,
        RE_STARTED,
        RE_COMPLETED;

    }
}

