/*
 * Decompiled with CFR 0.152.
 */
package id.unum.crossPlatformInterfaces;

import id.unum.Base58;
import id.unum.crossPlatformInterfaces.Encoding;
import id.unum.crossPlatformInterfaces.KeyGenerator;
import id.unum.crossPlatformInterfaces.KeyType;
import id.unum.crossPlatformInterfaces.PemUtil;
import id.unum.protos.crypto.v1.KeyPair;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0012\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u00a8\u0006\u0018"}, d2={"Lid/unum/crossPlatformInterfaces/JvmKeys;", "", "()V", "createKeyPair", "Lid/unum/protos/crypto/v1/KeyPair;", "encoding", "Lid/unum/crossPlatformInterfaces/Encoding;", "private", "Ljava/security/PrivateKey;", "public", "Ljava/security/PublicKey;", "generateEcKey", "generateRsaKey", "getJvmKeyPair", "Ljava/security/KeyPair;", "keyPair", "type", "Lid/unum/crossPlatformInterfaces/KeyType;", "getPrivateKey", "getPublicKey", "toBase58", "", "byteArray", "", "cryptography-lib"})
public final class JvmKeys {
    @NotNull
    public static final JvmKeys INSTANCE = new JvmKeys();

    private JvmKeys() {
    }

    @Nullable
    public final KeyPair generateEcKey(@NotNull Encoding encoding) {
        Intrinsics.checkNotNullParameter((Object)((Object)encoding), (String)"encoding");
        KeyGenerator generator = new KeyGenerator("EC");
        generator.generate(512);
        PrivateKey privateKey = generator.getPrivateKey();
        if (privateKey != null) {
            PrivateKey privateKey2 = privateKey;
            boolean bl = false;
            boolean bl2 = false;
            PrivateKey privateKey3 = privateKey2;
            boolean bl3 = false;
            PublicKey publicKey = generator.getPublicKey();
            if (publicKey != null) {
                PublicKey publicKey2 = publicKey;
                boolean bl4 = false;
                boolean bl5 = false;
                PublicKey publicKey3 = publicKey2;
                boolean bl6 = false;
                return INSTANCE.createKeyPair(encoding, privateKey3, publicKey3);
            }
        }
        return null;
    }

    @Nullable
    public final KeyPair generateRsaKey(@NotNull Encoding encoding) {
        Intrinsics.checkNotNullParameter((Object)((Object)encoding), (String)"encoding");
        KeyGenerator generator = new KeyGenerator("RSA");
        generator.generate(2048);
        PrivateKey privateKey = generator.getPrivateKey();
        if (privateKey != null) {
            PrivateKey privateKey2 = privateKey;
            boolean bl = false;
            boolean bl2 = false;
            PrivateKey privateKey3 = privateKey2;
            boolean bl3 = false;
            PublicKey publicKey = generator.getPublicKey();
            if (publicKey != null) {
                PublicKey publicKey2 = publicKey;
                boolean bl4 = false;
                boolean bl5 = false;
                PublicKey publicKey3 = publicKey2;
                boolean bl6 = false;
                return INSTANCE.createKeyPair(encoding, privateKey3, publicKey3);
            }
        }
        return null;
    }

    private final KeyPair createKeyPair(Encoding encoding, PrivateKey privateKey, PublicKey publicKey) {
        String string;
        Object object;
        String privateString;
        String string2;
        byte[] byArray;
        if (encoding == Encoding.PEM) {
            byArray = privateKey.getEncoded();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"private.encoded");
            string2 = PemUtil.INSTANCE.toPem$cryptography_lib("PRIVATE KEY", byArray);
        } else {
            byArray = privateKey.getEncoded();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"private.encoded");
            string2 = privateString = this.toBase58(byArray);
        }
        if (encoding == Encoding.PEM) {
            object = publicKey.getEncoded();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"public.encoded");
            string = PemUtil.INSTANCE.toPem$cryptography_lib("PUBLIC KEY", (byte[])object);
        } else {
            object = publicKey.getEncoded();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"public.encoded");
            string = this.toBase58((byte[])object);
        }
        String publicString = string;
        object = KeyPair.newBuilder().setPublicKey(publicString).setPrivateKey(privateString).build();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"newBuilder().setPublicKe\u2026ey(privateString).build()");
        return object;
    }

    private final String toBase58(byte[] byteArray) {
        return Base58.INSTANCE.encode(byteArray);
    }

    @NotNull
    public final java.security.KeyPair getJvmKeyPair(@NotNull KeyPair keyPair, @NotNull KeyType type) {
        Intrinsics.checkNotNullParameter((Object)keyPair, (String)"keyPair");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        PublicKey publicKey = this.getPublicKey(keyPair, type);
        PrivateKey privateKey = this.getPrivateKey(keyPair, type);
        return new java.security.KeyPair(publicKey, privateKey);
    }

    @NotNull
    public final PublicKey getPublicKey(@NotNull KeyPair keyPair, @NotNull KeyType type) {
        Intrinsics.checkNotNullParameter((Object)keyPair, (String)"keyPair");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        String string = keyPair.getPublicKey();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"public");
        byte[] encoded = StringsKt.contains$default((CharSequence)string, (CharSequence)"PUBLIC", (boolean)false, (int)2, null) ? PemUtil.INSTANCE.getPublicKeyFromPem$cryptography_lib(string) : Base58.INSTANCE.decode(string);
        String typeString = type == KeyType.RSA ? "RSA" : "EC";
        KeyFactory keyFactory = KeyFactory.getInstance(typeString);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(encoded);
        PublicKey publicKey = keyFactory.generatePublic(keySpec);
        if (publicKey == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.security.PublicKey");
        }
        return publicKey;
    }

    @NotNull
    public final PrivateKey getPrivateKey(@NotNull KeyPair keyPair, @NotNull KeyType type) {
        Intrinsics.checkNotNullParameter((Object)keyPair, (String)"keyPair");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        String privateKey = keyPair.getPrivateKey();
        Intrinsics.checkNotNullExpressionValue((Object)privateKey, (String)"privateKey");
        byte[] encoded = StringsKt.contains$default((CharSequence)privateKey, (CharSequence)"PRIVATE", (boolean)false, (int)2, null) ? PemUtil.INSTANCE.getPrivateKeyFromPem(privateKey) : Base58.INSTANCE.decode(privateKey);
        String typeString = type == KeyType.RSA ? "RSA" : "EC";
        KeyFactory keyFactory = KeyFactory.getInstance(typeString);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(encoded);
        PrivateKey privateKey2 = keyFactory.generatePrivate(keySpec);
        if (privateKey2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.security.PrivateKey");
        }
        return privateKey2;
    }
}

