/*
 * Decompiled with CFR 0.152.
 */
package id.unum.crossPlatformInterfaces;

import id.unum.Base58;
import id.unum.protos.crypto.v1.EncryptedData;
import id.unum.protos.crypto.v1.EncryptedKey;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ(\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0004J\u0018\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ6\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006J\u0018\u0010\u0014\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J \u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u0015\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u001a\u00a8\u0006\u001b"}, d2={"Lid/unum/crossPlatformInterfaces/JvmEncryption;", "", "()V", "decryptData", "", "data", "", "privateKey", "Ljava/security/PrivateKey;", "decryptWithOptions", "iv", "algorithm", "key", "encryptData", "publicKey", "Ljava/security/PublicKey;", "encryptWithOptions", "Lid/unum/protos/crypto/v1/EncryptedData;", "did", "pemKey", "encryptWithProvidedKey", "getCipher", "Ljavax/crypto/Cipher;", "getPublicKeyFromString", "Ljava/security/Key;", "originalKey", "getPublicKeyFromString$cryptography_lib", "cryptography-lib"})
public final class JvmEncryption {
    @NotNull
    public static final JvmEncryption INSTANCE = new JvmEncryption();

    private JvmEncryption() {
    }

    @NotNull
    public final String encryptData(@NotNull byte[] data, @Nullable PublicKey publicKey) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        byte[] encoded = JvmEncryption.getCipher$default(this, null, publicKey, 1, null).doFinal(data);
        Intrinsics.checkNotNullExpressionValue((Object)encoded, (String)"encoded");
        return Base58.INSTANCE.encode(encoded);
    }

    @Nullable
    public final byte[] decryptData(@NotNull String data, @Nullable PrivateKey privateKey) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        try {
            byte[] array = Base58.INSTANCE.decode(data);
            byte[] decrypted = JvmEncryption.getCipher$default(this, privateKey, null, 2, null).doFinal(array);
            int zeroes = 0;
            while (decrypted[zeroes] == 0) {
                ++zeroes;
            }
            return Arrays.copyOfRange(decrypted, zeroes, decrypted.length);
        }
        catch (Exception e) {
            StackTraceElement[] stackTraceElementArray = e.getLocalizedMessage();
            boolean bl = false;
            System.out.println(stackTraceElementArray);
            stackTraceElementArray = e.getStackTrace();
            bl = false;
            System.out.println(stackTraceElementArray);
            throw e;
        }
    }

    @Nullable
    public final byte[] decryptWithOptions(@NotNull String data, @NotNull byte[] iv, @NotNull String algorithm, @NotNull byte[] key) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)iv, (String)"iv");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Security.addProvider((Provider)new BouncyCastleProvider());
        IvParameterSpec specs = new IvParameterSpec(iv);
        SecretKeySpec secretKey = new SecretKeySpec(key, algorithm);
        Cipher decryptCipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        decryptCipher.init(2, (Key)secretKey, specs);
        byte[] results = decryptCipher.doFinal(Base58.INSTANCE.decode(data));
        return results;
    }

    private final Cipher getCipher(PrivateKey privateKey, PublicKey publicKey) {
        int mode;
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        boolean encryptMode = publicKey != null;
        int n = mode = encryptMode ? 1 : 2;
        if (encryptMode) {
            cipher.init(mode, publicKey);
        } else {
            cipher.init(mode, privateKey);
        }
        Intrinsics.checkNotNullExpressionValue((Object)cipher, (String)"cipher");
        return cipher;
    }

    static /* synthetic */ Cipher getCipher$default(JvmEncryption jvmEncryption, PrivateKey privateKey, PublicKey publicKey, int n, Object object) {
        if ((n & 1) != 0) {
            privateKey = null;
        }
        if ((n & 2) != 0) {
            publicKey = null;
        }
        return jvmEncryption.getCipher(privateKey, publicKey);
    }

    private final String encryptWithProvidedKey(String key, byte[] data) {
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(1, this.getPublicKeyFromString$cryptography_lib(key));
        byte[] encrypted = cipher.doFinal(data);
        Intrinsics.checkNotNullExpressionValue((Object)encrypted, (String)"encrypted");
        return Base58.INSTANCE.encode(encrypted);
    }

    @NotNull
    public final Key getPublicKeyFromString$cryptography_lib(@NotNull String originalKey) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)originalKey, (String)"originalKey");
        if (StringsKt.contains$default((CharSequence)originalKey, (CharSequence)"PUBLIC KEY", (boolean)false, (int)2, null)) {
            String string = StringsKt.replace$default((String)StringsKt.replace$default((String)originalKey, (String)"-----BEGIN RSA PUBLIC KEY-----", (String)"", (boolean)false, (int)4, null), (String)"-----BEGIN PUBLIC KEY-----", (String)"", (boolean)false, (int)4, null);
            String string2 = System.lineSeparator();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"lineSeparator()");
            String publicKeyPEM = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)string, (String)string2, (String)"", (boolean)false, (int)4, null), (String)"-----END RSA PUBLIC KEY-----", (String)"", (boolean)false, (int)4, null), (String)"-----END PUBLIC KEY-----", (String)"", (boolean)false, (int)4, null);
            byArray = Base64.getDecoder().decode(publicKeyPEM);
        } else {
            byArray = Base58.INSTANCE.decode(originalKey);
        }
        byte[] encoded = byArray;
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(encoded);
        PublicKey publicKey = keyFactory.generatePublic(keySpec);
        if (publicKey == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.security.interfaces.RSAPublicKey");
        }
        return (RSAPublicKey)publicKey;
    }

    @NotNull
    public final EncryptedData encryptWithOptions(@NotNull byte[] data, @NotNull byte[] iv, @NotNull String algorithm, @NotNull byte[] key, @NotNull String did, @NotNull String pemKey) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)iv, (String)"iv");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)did, (String)"did");
        Intrinsics.checkNotNullParameter((Object)pemKey, (String)"pemKey");
        Security.addProvider((Provider)new BouncyCastleProvider());
        String encryptedIv = this.encryptWithProvidedKey(pemKey, iv);
        String string = algorithm;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        String encryptedAlgorithm = this.encryptWithProvidedKey(pemKey, byArray);
        String encryptedKey = this.encryptWithProvidedKey(pemKey, key);
        String string2 = did;
        Charset charset2 = Charsets.UTF_8;
        boolean bl2 = false;
        byte[] byArray2 = string2.getBytes(charset2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
        String encryptedDid = this.encryptWithProvidedKey(pemKey, byArray2);
        EncryptedKey finalKey = EncryptedKey.newBuilder().setKey(encryptedKey).setAlgorithm(encryptedAlgorithm).setIv(encryptedIv).setDid(encryptedDid).build();
        IvParameterSpec specs = new IvParameterSpec(iv);
        SecretKeySpec secretKey = new SecretKeySpec(key, algorithm);
        Cipher encrypt = Cipher.getInstance("AES/CBC/PKCS5Padding");
        encrypt.init(1, (Key)secretKey, specs);
        byte[] results = encrypt.doFinal(data);
        Intrinsics.checkNotNullExpressionValue((Object)results, (String)"results");
        String encryptedResults = Base58.INSTANCE.encode(results);
        EncryptedData encryptedData = EncryptedData.newBuilder().setData(encryptedResults).setKey(finalKey).build();
        Intrinsics.checkNotNullExpressionValue((Object)encryptedData, (String)"newBuilder()\n           \u2026Key)\n            .build()");
        return encryptedData;
    }
}

