/*
 * Decompiled with CFR 0.152.
 */
package id.unum.crossPlatformInterfaces;

import id.unum.crossPlatformInterfaces.JvmEncryption;
import id.unum.crossPlatformInterfaces.JvmSignature;
import id.unum.crossPlatformInterfaces.PlatformProvider;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J*\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0004H\u0016J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0016\u00a8\u0006\u0011"}, d2={"Lid/unum/crossPlatformInterfaces/JvmBasePlatformProvider;", "Lid/unum/crossPlatformInterfaces/PlatformProvider;", "()V", "base64Decode", "", "src", "", "base64Encode", "byteArrayToString", "decryptWithOptions", "data", "iv", "algorithm", "key", "verifySignature", "", "signature", "cryptography-lib"})
public final class JvmBasePlatformProvider
implements PlatformProvider {
    @NotNull
    public static final JvmBasePlatformProvider INSTANCE = new JvmBasePlatformProvider();

    private JvmBasePlatformProvider() {
    }

    @Override
    @NotNull
    public byte[] base64Encode(@NotNull byte[] src) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        byte[] byArray = Base64.getEncoder().encode(src);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getEncoder().encode(src)");
        return byArray;
    }

    @Override
    @NotNull
    public byte[] base64Decode(@NotNull String src) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        byte[] byArray = Base64.getDecoder().decode(src);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getDecoder().decode(src)");
        return byArray;
    }

    @Override
    public boolean verifySignature(@NotNull byte[] data, @NotNull byte[] signature, @NotNull byte[] key) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return JvmSignature.INSTANCE.verifySignature(data, signature, key);
    }

    @Override
    @Nullable
    public byte[] decryptWithOptions(@NotNull String data, @NotNull byte[] iv, @NotNull String algorithm, @NotNull byte[] key) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)iv, (String)"iv");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return JvmEncryption.INSTANCE.decryptWithOptions(data, iv, algorithm, key);
    }

    @Override
    @NotNull
    public String byteArrayToString(@NotNull byte[] src) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        String string = Base64.getEncoder().encodeToString(src);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getEncoder().encodeToString(src)");
        return string;
    }
}

