/*
 * Decompiled with CFR 0.152.
 */
package id.unum;

import com.ionspin.kotlin.bignum.BigNumber;
import com.ionspin.kotlin.bignum.NarrowingOperations;
import com.ionspin.kotlin.bignum.integer.BigInteger;
import com.ionspin.kotlin.bignum.integer.Sign;
import id.unum.exceptions.ParseException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\t\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J5\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u0010J\u000e\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0004J\u000e\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lid/unum/Base58;", "", "()V", "BASE58CHARS", "", "FIFTY_EIGHT", "Lcom/ionspin/kotlin/bignum/integer/BigInteger;", "arrayCopy", "", "src", "", "srcIndex", "", "dest", "destIndex", "size", "arrayCopy$cryptography_lib", "decode", "encoded", "encode", "bytes", "cryptography-lib"})
public final class Base58 {
    @NotNull
    public static final Base58 INSTANCE = new Base58();
    @NotNull
    private static final String BASE58CHARS = "123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz";
    @NotNull
    private static final BigInteger FIFTY_EIGHT = (BigInteger)BigNumber.Creator.DefaultImpls.parseString$default((BigNumber.Creator)((BigNumber.Creator)BigInteger.Companion), (String)"58", (int)0, (int)2, null);

    private Base58() {
    }

    @NotNull
    public final String encode(@NotNull byte[] bytes) {
        Object div;
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        byte[] extraZero = new byte[bytes.length + 1];
        String result = "";
        extraZero[0] = 0;
        this.arrayCopy$cryptography_lib(bytes, 0, extraZero, 1, bytes.length);
        BigInteger bn = BigInteger.Companion.fromByteArray(extraZero, Sign.POSITIVE);
        while (bn.compareTo((Object)BigInteger.Companion.getZERO()) == 1) {
            div = bn.divideAndRemainder(FIFTY_EIGHT);
            bn = (BigInteger)div.getFirst();
            char c = BASE58CHARS.charAt(NarrowingOperations.DefaultImpls.intValue$default((NarrowingOperations)((NarrowingOperations)div.getSecond()), (boolean)false, (int)1, null));
            result = Intrinsics.stringPlus((String)result, (Object)Character.valueOf(c));
        }
        div = result;
        int n = 0;
        String string = div;
        if (string == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        result = ((Object)StringsKt.reversed((CharSequence)string)).toString();
        div = bytes;
        n = 0;
        Object object = div;
        boolean bl = false;
        if (!(((Object)object).length == 0)) {
            int i = 0;
            while (bytes[i] == 0) {
                result = Intrinsics.stringPlus((String)"1", (Object)result);
                n = i;
                i = n + 1;
            }
        }
        return result;
    }

    @NotNull
    public final byte[] decode(@NotNull String encoded) {
        int pos;
        Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
        BigInteger bn = BigInteger.Companion.getZERO();
        BigInteger mult = null;
        String string = encoded;
        int n = 0;
        String reversed = ((Object)StringsKt.reversed((CharSequence)string)).toString();
        byte[] raw = null;
        n = 0;
        int n2 = reversed.length() + -1;
        if (n <= n2) {
            do {
                char letter;
                int value;
                if ((value = StringsKt.indexOf$default((CharSequence)BASE58CHARS, (char)(letter = reversed.charAt(pos = n++)), (int)0, (boolean)false, (int)6, null)) == -1) {
                    throw new ParseException(reversed, pos);
                }
                mult = FIFTY_EIGHT.pow(pos);
                bn = (BigInteger)bn.plus(mult.times((BigNumber)BigInteger.Companion.fromLong((long)value)));
            } while (n <= n2);
        }
        if ((raw = bn.toByteArray())[0] == 0) {
            byte[] raw2 = new byte[raw.length - 1];
            ArraysKt.copyInto((byte[])raw, (byte[])raw2, (int)0, (int)1, (int)(raw.length - 1));
            raw = raw2;
        }
        int leadingZeroes = 0;
        int pos2 = 0;
        while (encoded.charAt(pos2) == '1' && pos2 < encoded.length()) {
            pos = leadingZeroes;
            leadingZeroes = pos + 1;
            pos = pos2;
            pos2 = pos + 1;
        }
        byte[] fin = new byte[raw.length + leadingZeroes];
        ArraysKt.copyInto((byte[])raw, (byte[])fin, (int)leadingZeroes, (int)0, (int)raw.length);
        return fin;
    }

    public final void arrayCopy$cryptography_lib(@NotNull byte[] src, int srcIndex, @NotNull byte[] dest, int destIndex, int size) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        int n = 0;
        if (n < size) {
            do {
                int i = n++;
                dest[destIndex + i] = src[srcIndex + i];
            } while (n < size);
        }
    }
}

