/*
 * Decompiled with CFR 0.152.
 */
package id.unum.crossPlatformInterfaces;

import id.unum.crossPlatformInterfaces.Encoding;
import id.unum.crossPlatformInterfaces.JvmEncryption;
import id.unum.crossPlatformInterfaces.JvmKeys;
import id.unum.crossPlatformInterfaces.JvmSignature;
import id.unum.crossPlatformInterfaces.KeyType;
import id.unum.protos.crypto.v1.EncryptedData;
import id.unum.protos.crypto.v1.KeyPair;
import id.unum.protos.crypto.v1.PublicKeyInfo;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ(\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0004J\u0016\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bJ6\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0006J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\u0013\u001a\u00020\u0014J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\u0013\u001a\u00020\u0014J\u001e\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0006J\u001e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0006\u00a8\u0006\u001c"}, d2={"Lid/unum/crossPlatformInterfaces/CryptoLibJvm;", "", "()V", "decryptData", "", "data", "", "keyPair", "Lid/unum/protos/crypto/v1/KeyPair;", "decryptWithOptions", "iv", "algorithm", "key", "encryptData", "encryptDataWithOptions", "Lid/unum/protos/crypto/v1/EncryptedData;", "did", "pemKey", "generateEcKey", "encoding", "Lid/unum/crossPlatformInterfaces/Encoding;", "generateRsaKey", "signData", "type", "verifyDataWithProvidedKey", "", "Lid/unum/protos/crypto/v1/PublicKeyInfo;", "signatureResults", "cryptography-lib"})
public final class CryptoLibJvm {
    public final boolean verifyDataWithProvidedKey(@NotNull PublicKeyInfo key, @NotNull byte[] data, @NotNull String signatureResults) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)signatureResults, (String)"signatureResults");
        return JvmSignature.INSTANCE.verifyDataWithProvidedKey(key, data, signatureResults);
    }

    @NotNull
    public final String signData(@NotNull byte[] data, @NotNull KeyPair keyPair, @NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)keyPair, (String)"keyPair");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return JvmSignature.INSTANCE.signData(data, JvmKeys.INSTANCE.getPrivateKey(keyPair, KeyType.ECC), type);
    }

    @NotNull
    public final String encryptData(@NotNull byte[] data, @NotNull KeyPair keyPair) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)keyPair, (String)"keyPair");
        return JvmEncryption.INSTANCE.encryptData(data, JvmKeys.INSTANCE.getPublicKey(keyPair, KeyType.RSA));
    }

    @NotNull
    public final EncryptedData encryptDataWithOptions(@NotNull byte[] data, @NotNull byte[] iv, @NotNull String algorithm, @NotNull byte[] key, @NotNull String did, @NotNull String pemKey) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)iv, (String)"iv");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)did, (String)"did");
        Intrinsics.checkNotNullParameter((Object)pemKey, (String)"pemKey");
        return JvmEncryption.INSTANCE.encryptWithOptions(data, iv, algorithm, key, did, pemKey);
    }

    @Nullable
    public final byte[] decryptData(@NotNull String data, @NotNull KeyPair keyPair) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)keyPair, (String)"keyPair");
        return JvmEncryption.INSTANCE.decryptData(data, JvmKeys.INSTANCE.getPrivateKey(keyPair, KeyType.RSA));
    }

    @Nullable
    public final byte[] decryptWithOptions(@NotNull String data, @NotNull byte[] iv, @NotNull String algorithm, @NotNull byte[] key) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)iv, (String)"iv");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return JvmEncryption.INSTANCE.decryptWithOptions(data, iv, algorithm, key);
    }

    @Nullable
    public final KeyPair generateEcKey(@NotNull Encoding encoding) {
        Intrinsics.checkNotNullParameter((Object)((Object)encoding), (String)"encoding");
        return JvmKeys.INSTANCE.generateEcKey(encoding);
    }

    public static /* synthetic */ KeyPair generateEcKey$default(CryptoLibJvm cryptoLibJvm, Encoding encoding, int n, Object object) {
        if ((n & 1) != 0) {
            encoding = Encoding.PEM;
        }
        return cryptoLibJvm.generateEcKey(encoding);
    }

    @Nullable
    public final KeyPair generateRsaKey(@NotNull Encoding encoding) {
        Intrinsics.checkNotNullParameter((Object)((Object)encoding), (String)"encoding");
        return JvmKeys.INSTANCE.generateRsaKey(encoding);
    }

    public static /* synthetic */ KeyPair generateRsaKey$default(CryptoLibJvm cryptoLibJvm, Encoding encoding, int n, Object object) {
        if ((n & 1) != 0) {
            encoding = Encoding.PEM;
        }
        return cryptoLibJvm.generateRsaKey(encoding);
    }
}

