package id.unum.crossPlatformInterfaces

internal interface PlatformProvider {
    fun base64Encode(src: ByteArray): ByteArray
    fun base64Decode(src: String): ByteArray
    fun byteArrayToString(src: ByteArray): String {
        val encoded = base64Encode(src)
        return buildString(encoded.size) {
            encoded.forEach { append(it.toInt().toChar()) }
        }
    }

    fun verifySignature(data: ByteArray, signature: ByteArray, key: ByteArray): Boolean

    fun decryptWithOptions(data: String, iv: ByteArray, algorithm: String, key: ByteArray): ByteArray?
}

internal expect object PlatformProviderFactory {
    fun createPlatformProvider(): PlatformProvider
}