/*
 * Decompiled with CFR 0.152.
 */
package id.unum.crossPlatformInterfaces;

import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0019"}, d2={"Lid/unum/crossPlatformInterfaces/KeyGenerator;", "", "keyType", "", "(Ljava/lang/String;)V", "keyGen", "Ljava/security/KeyPairGenerator;", "privateKey", "Ljava/security/PrivateKey;", "getPrivateKey", "()Ljava/security/PrivateKey;", "setPrivateKey", "(Ljava/security/PrivateKey;)V", "prng", "Ljava/security/SecureRandom;", "publicKey", "Ljava/security/PublicKey;", "getPublicKey", "()Ljava/security/PublicKey;", "setPublicKey", "(Ljava/security/PublicKey;)V", "generate", "", "keyBits", "", "cryptography-lib"})
public final class KeyGenerator {
    @NotNull
    private final KeyPairGenerator keyGen;
    @Nullable
    private SecureRandom prng;
    @Nullable
    private PublicKey publicKey;
    @Nullable
    private PrivateKey privateKey;

    public KeyGenerator(@NotNull String keyType) {
        Intrinsics.checkNotNullParameter((Object)keyType, (String)"keyType");
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(keyType);
        Intrinsics.checkNotNullExpressionValue((Object)keyPairGenerator, (String)"getInstance(keyType)");
        this.keyGen = keyPairGenerator;
    }

    @Nullable
    public final PublicKey getPublicKey() {
        return this.publicKey;
    }

    public final void setPublicKey(@Nullable PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    @Nullable
    public final PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public final void setPrivateKey(@Nullable PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public final void generate(int keyBits) throws InvalidKeyException {
        Serializable serializable;
        KeyPair pair = null;
        try {
            if (this.prng == null) {
                this.prng = new SecureRandom();
            }
            this.keyGen.initialize(keyBits, this.prng);
            serializable = this.keyGen.genKeyPair();
            Intrinsics.checkNotNullExpressionValue((Object)serializable, (String)"keyGen.genKeyPair()");
            pair = serializable;
            this.publicKey = pair.getPublic();
            this.privateKey = pair.getPrivate();
        }
        catch (Exception e) {
            StackTraceElement[] stackTraceElementArray = e.getLocalizedMessage();
            boolean bl = false;
            System.out.println(stackTraceElementArray);
            stackTraceElementArray = e.getStackTrace();
            bl = false;
            System.out.println(stackTraceElementArray);
        }
        serializable = this.publicKey;
        if (!StringsKt.equals((String)"X.509", (String)(serializable == null ? null : serializable.getFormat()), (boolean)true)) {
            serializable = this.publicKey;
            throw new IllegalArgumentException(Intrinsics.stringPlus((String)"publicKey's is not X.509, but ", (Object)(serializable == null ? null : serializable.getFormat())));
        }
    }
}

