/*
 * Decompiled with CFR 0.152.
 */
package id.unum.crossPlatformInterfaces;

import id.unum.Base58;
import id.unum.crossPlatformInterfaces.PemUtil;
import id.unum.crossPlatformInterfaces.PlatformProvider;
import id.unum.crossPlatformInterfaces.PlatformProviderFactory;
import id.unum.protos.crypto.v1.PublicKeyInfo;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004J\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0004J\u001e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006\u00a8\u0006\u0011"}, d2={"Lid/unum/crossPlatformInterfaces/JvmSignature;", "", "()V", "signData", "", "data", "", "privateKey", "Ljava/security/PrivateKey;", "type", "verifyDataWithProvidedKey", "", "key", "Lid/unum/protos/crypto/v1/PublicKeyInfo;", "signatureResults", "verifySignature", "signature", "cryptography-lib"})
public final class JvmSignature {
    @NotNull
    public static final JvmSignature INSTANCE = new JvmSignature();

    private JvmSignature() {
    }

    public final boolean verifySignature(@NotNull byte[] data, @NotNull byte[] signature, @NotNull byte[] key) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Security.addProvider((Provider)new BouncyCastleProvider());
        KeyFactory keyFactory = KeyFactory.getInstance("EC");
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(key);
        String[] stringArray = new String[]{"NONEwithECDSA", "SHA1withECDSA", "SHA224withECDSA", "SHA256withECDSA", "SHA384withECDSA", "SHA512withECDSA"};
        List list = CollectionsKt.listOf((Object[])stringArray);
        for (String each : list) {
            Signature signature2 = Signature.getInstance(each);
            boolean bl = false;
            boolean bl2 = false;
            Signature $this$verifySignature_u24lambda_u2d0 = signature2;
            boolean bl3 = false;
            $this$verifySignature_u24lambda_u2d0.initVerify(keyFactory.generatePublic(keySpec));
            $this$verifySignature_u24lambda_u2d0.update(data);
            boolean result = $this$verifySignature_u24lambda_u2d0.verify(signature);
            if (!result) continue;
            return result;
        }
        return false;
    }

    @NotNull
    public final String signData(@NotNull byte[] data, @NotNull PrivateKey privateKey, @NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Security.addProvider((Provider)new BouncyCastleProvider());
        try {
            PrivateKey privateKey2 = privateKey;
            boolean bl = false;
            boolean bl2 = false;
            PrivateKey it = privateKey2;
            boolean bl3 = false;
            Signature signature = Signature.getInstance(type);
            boolean bl4 = false;
            boolean bl5 = false;
            Signature $this$signData_u24lambda_u2d2_u24lambda_u2d1 = signature;
            boolean bl6 = false;
            $this$signData_u24lambda_u2d2_u24lambda_u2d1.initSign(it);
            $this$signData_u24lambda_u2d2_u24lambda_u2d1.update(data);
            byte[] signature2 = $this$signData_u24lambda_u2d2_u24lambda_u2d1.sign();
            if (signature2 != null) {
                return Base58.INSTANCE.encode(signature2);
            }
        }
        catch (Exception e) {
            String string = Intrinsics.stringPlus((String)"error signing data:", (Object)e);
            boolean bl = false;
            System.out.println((Object)string);
            throw e;
        }
        throw new Exception("Error singingData");
    }

    public final boolean verifyDataWithProvidedKey(@NotNull PublicKeyInfo key, @NotNull byte[] data, @NotNull String signatureResults) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)signatureResults, (String)"signatureResults");
        PlatformProvider platformProvider = PlatformProviderFactory.INSTANCE.createPlatformProvider();
        try {
            byte[] byArray;
            String string = key.getEncoding();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"key.encoding");
            boolean bl = false;
            String string2 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
            if (Intrinsics.areEqual((Object)string2, (Object)"pem")) {
                string = key.getPublicKey();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"key.publicKey");
                byArray = PemUtil.INSTANCE.getPublicKeyFromPem$cryptography_lib(string);
            } else {
                string = key.getEncoding();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"key.encoding");
                bl = false;
                String string3 = string.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
                if (Intrinsics.areEqual((Object)string3, (Object)"base58")) {
                    string = key.getPublicKey();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"key.publicKey");
                    byArray = Base58.INSTANCE.decode(string);
                } else {
                    byArray = new byte[]{};
                }
            }
            byte[] encoded = byArray;
            byte[] signature = Base58.INSTANCE.decode(signatureResults);
            byte[] byArray2 = encoded;
            if (byArray2 != null) {
                byte[] byArray3 = byArray2;
                boolean bl2 = false;
                boolean bl3 = false;
                byte[] it = byArray3;
                boolean bl4 = false;
                return platformProvider.verifySignature(data, signature, it);
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }
}

