package id.unum.crossPlatformInterfaces

import java.util.*

internal actual object PlatformProviderFactory {
    actual fun createPlatformProvider(): PlatformProvider = JvmBasePlatformProvider
}

internal object JvmBasePlatformProvider : PlatformProvider {
    override fun base64Encode(src: ByteArray): ByteArray = Base64.getEncoder().encode(src)

    override fun base64Decode(src: String): ByteArray = Base64.getDecoder().decode(src)

    override fun verifySignature(data: ByteArray, signature: ByteArray, key: ByteArray): Boolean {
        return JvmSignature.verifySignature(data, signature, key)
    }

    override fun decryptWithOptions(data: String, iv: ByteArray, algorithm: String, key: ByteArray): ByteArray? {
        return JvmEncryption.decryptWithOptions(data, iv, algorithm, key)
    }

    override fun byteArrayToString(src: ByteArray): String = Base64.getEncoder().encodeToString(src)

}